/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib.logger;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.creeperhost.levelpreview.lib.logger.ReallySimpleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class ReallySimpleLoggerFactory
implements ILoggerFactory {
    private static final Map<String, Integer> LOG_LEVELS = ImmutableMap.of((Object)"trace", (Object)0, (Object)"debug", (Object)10, (Object)"info", (Object)20, (Object)"warn", (Object)30, (Object)"error", (Object)40);
    private static final Integer SELECTED_LOG_LEVEL = LOG_LEVELS.getOrDefault(System.getProperty("net.creeperhost.wailt.log_level", "info").toLowerCase(Locale.ROOT), 20);
    private final Map<String, ReallySimpleLogger> loggerMap = new ConcurrentHashMap<String, ReallySimpleLogger>();

    public Logger getLogger(String name) {
        return (Logger)this.loggerMap.computeIfAbsent(name, e -> new ReallySimpleLogger((String)e, SELECTED_LOG_LEVEL));
    }
}

