/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.util.HeatBody;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidTransitionTank
extends HeatBody
implements IPhosphophylliteFluidHandler,
INBTSerializable<CompoundTag> {
    public final boolean condenser;
    public long perSideCapacity;
    protected FluidTransitionRegistry.FluidTransition activeTransition;
    public static final int IN_TANK = 0;
    protected Fluid inFluid;
    protected long inAmount = 0L;
    public static final int OUT_TANK = 1;
    protected Fluid outFluid;
    protected long outAmount = 0L;
    protected long rfTransferredLastTick;
    protected long transitionedLastTick;
    protected long maxTransitionedLastTick;

    public FluidTransitionTank(boolean condenser) {
        this.condenser = condenser;
        this.setInfinite(true);
    }

    public int tankCount() {
        return 2;
    }

    public long tankCapacity(int tank) {
        return Long.min(this.perSideCapacity, Integer.MAX_VALUE);
    }

    @Nonnull
    public Fluid fluidTypeInTank(int tank) {
        if (tank == 0 && this.inFluid != null) {
            return this.inFluid;
        }
        if (tank == 1 && this.outFluid != null) {
            return this.outFluid;
        }
        return Fluids.f_76191_;
    }

    @Nullable
    public CompoundTag fluidTagInTank(int tank) {
        return null;
    }

    public long fluidAmountInTank(int tank) {
        if (tank == 0) {
            return this.inAmount;
        }
        if (tank == 1) {
            return this.outAmount;
        }
        return 0L;
    }

    public long transitionedLastTick() {
        return this.transitionedLastTick;
    }

    public long maxTransitionedLastTick() {
        return this.maxTransitionedLastTick;
    }

    public long rfTransferredLastTick() {
        return this.rfTransferredLastTick;
    }

    public boolean fluidValidForTank(int tank, @Nonnull Fluid fluid) {
        if (tank == 0) {
            return FluidTransitionRegistry.liquidTransition(fluid) != null;
        }
        if (tank == 1) {
            return FluidTransitionRegistry.gasTransition(fluid) != null;
        }
        return false;
    }

    public long fill(@Nonnull Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (tag != null) {
            return 0L;
        }
        return this.fill(fluid, amount, simulate, this.activeTransition);
    }

    @Deprecated
    public long fill(@Nonnull Fluid fluid, long amount, boolean simulate, @Nullable FluidTransitionRegistry.FluidTransition transition) {
        if (transition == null) {
            transition = this.selectTransition(fluid);
        }
        if (transition == null) {
            return 0L;
        }
        if (fluid == this.inFluid || (this.condenser ? transition.gases.contains(fluid) : transition.liquids.contains(fluid))) {
            long maxFill = this.perSideCapacity - this.inAmount;
            long toFill = Math.min(amount, maxFill);
            if (!simulate) {
                this.inFluid = fluid;
                if (this.activeTransition != transition) {
                    this.outFluid = this.condenser ? transition.liquids.get(0) : transition.gases.get(0);
                    this.activeTransition = transition;
                    this.transitionUpdate();
                }
                this.inAmount += toFill;
            }
            return toFill;
        }
        if (this.inAmount == 0L && this.outAmount == 0L) {
            return this.fill(fluid, amount, simulate, null);
        }
        return 0L;
    }

    public long drain(@Nonnull Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.activeTransition == null || tag != null) {
            return 0L;
        }
        if (fluid == this.outFluid || (this.condenser ? this.activeTransition.liquids.contains(fluid) : this.activeTransition.gases.contains(fluid))) {
            long maxDrain = this.outAmount;
            long toDrain = Math.min(amount, maxDrain);
            if (!simulate) {
                this.outFluid = fluid;
                this.outAmount -= toDrain;
            }
            return toDrain;
        }
        return 0L;
    }

    public void dumpTank(int tank) {
        if (tank == 0) {
            this.inAmount = 0L;
        }
        if (tank == 1) {
            this.outAmount = 0L;
        }
    }

    public double transferWith(HeatBody body, double rfkt) {
        if (this.activeTransition == null) {
            return 0.0;
        }
        rfkt *= this.condenser ? this.activeTransition.gasRFMKT : this.activeTransition.liquidRFMKT;
        double multiplier = (double)this.inAmount / (double)this.perSideCapacity;
        double newTemp = body.temperature() - this.activeTransition.boilingPoint;
        newTemp *= Math.exp(-(rfkt *= Math.max(multiplier, 0.01)) / body.rfPerKelvin());
        double toTransfer = (newTemp += this.activeTransition.boilingPoint) - body.temperature();
        toTransfer *= body.rfPerKelvin();
        toTransfer = this.absorbRF(toTransfer);
        body.absorbRF(toTransfer);
        return -toTransfer;
    }

    public double absorbRF(double rf) {
        if (rf > 0.0 && !this.condenser || rf < 0.0 && this.condenser) {
            return 0.0;
        }
        rf = Math.abs(rf);
        long toTransition = (long)(rf / this.activeTransition.latentHeat);
        long maxTransitionable = Math.min(this.inAmount, this.perSideCapacity - this.outAmount);
        this.maxTransitionedLastTick = toTransition;
        this.transitionedLastTick = toTransition = Math.min(maxTransitionable, toTransition);
        this.inAmount -= toTransition;
        this.outAmount += toTransition;
        rf = (double)toTransition * this.activeTransition.latentHeat;
        this.rfTransferredLastTick = (long)rf;
        if (!this.condenser) {
            rf *= -1.0;
        }
        return rf;
    }

    protected void transitionUpdate() {
    }

    public FluidTransitionRegistry.FluidTransition activeTransition() {
        return this.activeTransition;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.inFluid != null) {
            nbt.m_128359_("inFluid", ForgeRegistries.FLUIDS.getKey((Object)this.inFluid).toString());
            nbt.m_128356_("inAmount", this.inAmount);
            nbt.m_128359_("outFluid", ForgeRegistries.FLUIDS.getKey((Object)this.outFluid).toString());
            nbt.m_128356_("outAmount", this.outAmount);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (!nbt.m_128441_("inFluid")) {
            return;
        }
        ResourceLocation inFluidLocation = new ResourceLocation(nbt.m_128461_("inFluid"));
        if (ForgeRegistries.FLUIDS.containsKey(inFluidLocation)) {
            Fluid oldOutFluid;
            Fluid newInFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(inFluidLocation);
            if (newInFluid == null) {
                return;
            }
            FluidTransitionRegistry.FluidTransition newTransition = this.condenser ? FluidTransitionRegistry.gasTransition(newInFluid) : FluidTransitionRegistry.liquidTransition(newInFluid);
            if (newTransition == null) {
                return;
            }
            List<Fluid> outFluidList = this.condenser ? newTransition.liquids : newTransition.gases;
            Fluid newOutFluid = null;
            ResourceLocation outFluidLocation = new ResourceLocation(nbt.m_128461_("outFluid"));
            if (ForgeRegistries.FLUIDS.containsKey(outFluidLocation) && outFluidList.contains(oldOutFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(outFluidLocation))) {
                newOutFluid = oldOutFluid;
            }
            if (newOutFluid == null) {
                newOutFluid = outFluidList.get(0);
            }
            this.activeTransition = newTransition;
            this.inFluid = newInFluid;
            this.outFluid = newOutFluid;
            this.inAmount = nbt.m_128454_("inAmount");
            this.outAmount = nbt.m_128454_("outAmount");
            this.transitionUpdate();
        }
    }

    @Nullable
    protected FluidTransitionRegistry.FluidTransition selectTransition(Fluid fluid) {
        if (this.condenser) {
            return FluidTransitionRegistry.gasTransition(fluid);
        }
        return FluidTransitionRegistry.liquidTransition(fluid);
    }
}

