/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor2;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorManifold;
import net.roguelogix.biggerreactors.multiblocks.reactor2.blocks.ReactorBlock;
import net.roguelogix.biggerreactors.multiblocks.reactor2.blocks.ReactorBlocks;
import net.roguelogix.biggerreactors.multiblocks.reactor2.simulation.ModeratorRegistry;
import net.roguelogix.biggerreactors.multiblocks.reactor2.tiles.ReactorControlRodTile;
import net.roguelogix.biggerreactors.multiblocks.reactor2.tiles.ReactorFuelRodTile;
import net.roguelogix.biggerreactors.multiblocks.reactor2.tiles.ReactorTerminalTile;
import net.roguelogix.biggerreactors.multiblocks.reactor2.tiles.ReactorTile;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.ValidationException;
import net.roguelogix.phosphophyllite.multiblock.common.IPersistentMultiblock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblock;
import net.roguelogix.phosphophyllite.multiblock.touching.ITouchingMultiblock;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@NonnullDefault
public class ReactorMultiblockController
extends MultiblockController<ReactorTile, ReactorBlock, ReactorMultiblockController>
implements IPersistentMultiblock<ReactorTile, ReactorBlock, ReactorMultiblockController>,
IRectangularMultiblock<ReactorTile, ReactorBlock, ReactorMultiblockController>,
ITouchingMultiblock<ReactorTile, ReactorBlock, ReactorMultiblockController> {
    private final FastArraySet<ReactorControlRodTile> controlRods = new FastArraySet();
    private final FastArraySet<ReactorTile> fuelRods = new FastArraySet();
    private final Set<ReactorTerminalTile> terminals = new ObjectOpenHashSet();
    private final Set<ReactorTile> powerTaps = new ObjectOpenHashSet();
    private final Set<ReactorTile> accessPorts = new ObjectOpenHashSet();
    private final Set<ReactorTile> coolantPorts = new ObjectOpenHashSet();
    private final Set<ReactorTile> manifolds = new ObjectOpenHashSet();
    private int foundRods = 0;
    private int foundManifolds = 0;
    String nbtTestValue = Integer.toHexString(((Object)((Object)this)).hashCode());

    public ReactorMultiblockController(Level level) {
        super(level, ReactorTile.class, ReactorBlock.class);
    }

    public void validateStage1() throws ValidationException {
        if (this.blocks.size() < 27) {
            throw new ValidationException("minblocks");
        }
        if (this.controlRods.size() == 0) {
            throw new ValidationException("controlRodCount");
        }
        for (int i = 0; i < this.controlRods.size(); ++i) {
            if (((ReactorControlRodTile)((Object)this.controlRods.get(i))).m_58899_().m_123342_() == this.max().y()) continue;
            throw new ValidationException("controlRodsOnTop");
        }
    }

    public void rectangularValidationStarted() {
        this.foundRods = 0;
        this.foundManifolds = 0;
    }

    public void rectangularBlockValidated(Block block) {
        if (block instanceof ReactorBlock.FuelRod) {
            ++this.foundRods;
        }
        if (block == ReactorManifold.INSTANCE) {
            ++this.foundManifolds;
        }
    }

    public void validateStage2() throws ValidationException {
        if (this.foundRods > this.fuelRods.size()) {
            Util.chunkCachedBlockStateIteration((Vector3ic)this.min().add(1, 1, 1, new Vector3i()), (Vector3ic)this.max().sub(1, 1, 1, new Vector3i()), (Level)this.level, (state, position) -> {
                ReactorFuelRodTile fuelRodTile;
                if (!(state.m_60734_() instanceof ReactorBlock.FuelRod)) {
                    return;
                }
                BlockEntity patt4597$temp = this.blocks.getTile((Vector3ic)position);
                if (patt4597$temp instanceof ReactorFuelRodTile && (fuelRodTile = (ReactorFuelRodTile)patt4597$temp).controller() != this) {
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.reactor.dangling_rod", (Object[])new Object[]{position.toString()}));
                }
            });
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.reactor.dangling_rod_unknown_position"));
        }
        if (this.foundRods < this.fuelRods.size()) {
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.reactor.unable_to_find_all_rods"));
        }
    }

    public void validateStage3() throws ValidationException {
        int i;
        long tick = Phosphophyllite.tickNumber();
        int maxY = this.max().y();
        int internalMinY = this.min().y() + 1;
        int rodCount = 0;
        for (i = 0; i < this.controlRods.size(); ++i) {
            BlockPos controlRodPos = ((ReactorControlRodTile)((Object)this.controlRods.get(i))).m_58899_();
            int x = controlRodPos.m_123341_();
            int z = controlRodPos.m_123343_();
            for (int j = internalMinY; j < maxY; ++j) {
                ReactorTile tile = (ReactorTile)this.blocks.getTile(x, j, z);
                if (!(tile instanceof ReactorFuelRodTile)) {
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.reactor.fuel_rod_gap", (Object[])new Object[]{controlRodPos.m_123341_(), controlRodPos.m_123342_() + (-1 - i), controlRodPos.m_123343_()}));
                }
                tile.lastCheckedTick = tick;
                ++rodCount;
            }
        }
        if (rodCount != this.fuelRods.size()) {
            for (i = 0; i < this.fuelRods.size(); ++i) {
                ReactorTile fuelRod = (ReactorTile)((Object)this.fuelRods.get(i));
                if (fuelRod.lastCheckedTick == tick) continue;
                throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.reactor.no_control_rod_for_fuel_rod", (Object[])new Object[]{fuelRod.m_58899_().m_123341_(), fuelRod.m_58899_().m_123343_()}));
            }
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.reactor.no_control_rod_for_fuel_rod_unknown_position"));
        }
        if (!this.manifolds.isEmpty()) {
            BlockPos pos;
            int checkedManifolds = 0;
            ArrayList<MultiblockTileModule> manifoldsToCheck = new ArrayList<MultiblockTileModule>();
            Direction[] directions = Direction.values();
            int minx = this.min().x() + 1;
            int miny = this.min().y() + 1;
            int minz = this.min().z() + 1;
            int maxx = this.max().x() - 1;
            int maxy = this.max().y() - 1;
            int maxz = this.max().z() - 1;
            block3: for (ReactorTile manifold : this.manifolds) {
                pos = manifold.m_58899_();
                if (pos.m_123341_() != minx && pos.m_123341_() != maxx && pos.m_123342_() != miny && pos.m_123342_() != maxy && pos.m_123343_() != minz && pos.m_123343_() != maxz) continue;
                MultiblockTileModule manifoldModule = manifold.multiblockModule();
                for (int i2 = 0; i2 < 6; ++i2) {
                    ReactorTile neighborTile;
                    Direction direction = directions[i2];
                    MultiblockTileModule neighborModule = manifoldModule.getNeighbor(direction);
                    if (neighborModule == null || (neighborTile = (ReactorTile)neighborModule.iface).m_58900_().m_60734_() == ReactorBlocks.GLASS || !((ReactorBlock)neighborTile.m_58900_().m_60734_()).isGoodForExterior()) continue;
                    manifoldsToCheck.add(manifoldModule);
                    manifold.lastCheckedTick = tick;
                    ++checkedManifolds;
                    continue block3;
                }
            }
            while (!manifoldsToCheck.isEmpty()) {
                MultiblockTileModule manifoldModule = (MultiblockTileModule)manifoldsToCheck.remove(manifoldsToCheck.size() - 1);
                for (int i3 = 0; i3 < 6; ++i3) {
                    ReactorTile neighborTile;
                    Direction direction = directions[i3];
                    MultiblockTileModule neighborModule = manifoldModule.getNeighbor(direction);
                    if (neighborModule == null || (neighborTile = (ReactorTile)neighborModule.iface).m_58900_().m_60734_() != ReactorBlocks.MANIFOLD || neighborTile.lastCheckedTick == tick) continue;
                    manifoldsToCheck.add(neighborModule);
                    neighborTile.lastCheckedTick = tick;
                    ++checkedManifolds;
                }
            }
            if (this.manifolds.size() != checkedManifolds) {
                for (ReactorTile manifold : this.manifolds) {
                    if (manifold.lastCheckedTick == tick) continue;
                    pos = manifold.m_58899_();
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.disconnected_manifold", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
                }
                throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.disconnected_manifold_unknown_pos"));
            }
        }
    }

    public boolean allowedInteriorBlock(Block block) {
        return ModeratorRegistry.isModerator(block);
    }

    public CompoundTag mergeNBTs(CompoundTag nbtA, CompoundTag nbtB) {
        return nbtA;
    }

    public void read(CompoundTag nbt) {
        if (nbt.m_128441_("testValue")) {
            this.nbtTestValue = nbt.m_128461_("testValue");
        }
    }

    @Nullable
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("testValue", this.nbtTestValue);
        return tag;
    }

    @Nullable
    public Vector3ic minSize() {
        return new Vector3i(3, 3, 3);
    }

    @Nullable
    public Vector3ic maxSize() {
        return new Vector3i(Config.CONFIG.Reactor.MaxLength, Config.CONFIG.Reactor.MaxHeight, Config.CONFIG.Reactor.MaxWidth);
    }

    protected void onPartAdded(@Nonnull ReactorTile tile) {
        Block block;
        ReactorTile rod;
        if (tile instanceof ReactorControlRodTile) {
            rod = (ReactorControlRodTile)tile;
            this.controlRods.add((Object)rod);
        }
        if (tile instanceof ReactorFuelRodTile) {
            rod = (ReactorFuelRodTile)tile;
            this.fuelRods.add((Object)rod);
        }
        if ((block = tile.m_58900_().m_60734_()) == ReactorBlocks.MANIFOLD) {
            this.manifolds.add(tile);
        }
    }

    protected void onPartRemoved(@Nonnull ReactorTile tile) {
        Block block;
        ReactorTile rod;
        if (tile instanceof ReactorControlRodTile) {
            rod = (ReactorControlRodTile)tile;
            this.controlRods.remove((Object)rod);
        }
        if (tile instanceof ReactorFuelRodTile) {
            rod = (ReactorFuelRodTile)tile;
            this.fuelRods.remove((Object)rod);
        }
        if ((block = tile.m_58900_().m_60734_()) == ReactorBlocks.MANIFOLD) {
            this.manifolds.remove((Object)tile);
        }
    }

    @Nonnull
    public DebugInfo getControllerDebugInfo() {
        DebugInfo debugInfo = new DebugInfo(((Object)((Object)this)).getClass().getSimpleName());
        debugInfo.add("TestValue: " + this.nbtTestValue);
        return debugInfo;
    }

    public void tick() {
        this.dirty();
    }
}

