/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.cpu;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimulationDescription;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.BaseReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.ModeratorCache;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.SimUtil;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.Queues;

public class FullPassReactorSimulation
extends BaseReactorSimulation {
    protected static final ReactorModeratorRegistry.IModeratorProperties CONTROL_ROD_MODERATOR = new ReactorModeratorRegistry.ModeratorProperties(-1.0, 0.0, 1.0, 0.0);
    protected final ObjectArrayList<ModeratorCache> moderatorCaches = new ObjectArrayList();
    protected final byte[] moderatorIndices;
    protected final double[] initialIntensties;
    protected double fuelAbsorptionTemperatureCoefficient;
    protected double FuelAbsorptionCoefficient;
    protected double FuelModerationFactor;
    protected double fuelHardnessMultiplier;
    protected double rayMultiplier;
    protected double initialHardness;
    protected IrradiationRequest fullPassIrradiationRequest;
    protected double rawFuelUsage = 0.0;
    protected double fuelRFAdded = 0.0;
    protected double fuelRadAdded = 0.0;
    protected double caseRFAdded = 0.0;

    public FullPassReactorSimulation(SimulationDescription simulationDescription) {
        super(simulationDescription);
        int k;
        ObjectArrayList moderators = new ObjectArrayList();
        moderators.add((Object)CONTROL_ROD_MODERATOR);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                for (k = 0; k < this.z; ++k) {
                    ReactorModeratorRegistry.IModeratorProperties moderator = this.moderatorProperties[i][j][k];
                    if (moderator == null || moderators.contains((Object)moderator)) continue;
                    moderators.add((Object)moderator);
                }
            }
        }
        if (moderators.size() > 127) {
            throw new IllegalArgumentException("Full pass reactor simulations only supports 127 moderator types, switch back to time sliced simulation to load world");
        }
        for (ReactorModeratorRegistry.IModeratorProperties moderator : moderators) {
            this.moderatorCaches.add((Object)new ModeratorCache(moderator));
        }
        this.moderatorIndices = new byte[this.x * this.y * this.z];
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.z; ++j) {
                for (k = 0; k < this.y; ++k) {
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[i][k][j];
                    byte moderatorIndex = 0;
                    if (properties != null) {
                        moderatorIndex = (byte)moderators.indexOf((Object)properties);
                    }
                    int linearIndex = (i * this.z + j) * this.y + k;
                    this.moderatorIndices[linearIndex] = moderatorIndex;
                }
            }
        }
        this.initialIntensties = new double[this.controlRods.length];
        this.fullPassIrradiationRequest = new IrradiationRequest(0, this.controlRods.length, (ModeratorCache[])this.moderatorCaches.toArray((Object[])new ModeratorCache[0]), this.y);
    }

    @Override
    protected double radiate() {
        if (this.fuelTank.fuel() <= 0L) {
            return 0.0;
        }
        this.setupIrradiationTick();
        this.fullPassIrradiationRequest.updateCache();
        this.runIrradiationRequest(this.fullPassIrradiationRequest);
        this.collectIrradiationResult(this.fullPassIrradiationRequest.result);
        return this.realizeIrradiationTick();
    }

    protected void setupIrradiationTick() {
        this.moderatorCaches.forEach(ModeratorCache::update);
        double radiationPenaltyBase = Math.exp(-Config.CONFIG.Reactor.RadPenaltyShiftMultiplier * Math.exp(-0.001 * Config.CONFIG.Reactor.RadPenaltyRateMultiplier * (this.fuelHeat.temperature() - 273.15)));
        long baseFuelAmount = this.fuelTank.fuel() + this.fuelTank.waste() / 100L;
        double rawRadIntensity = (double)baseFuelAmount * Config.CONFIG.Reactor.FissionEventsPerFuelUnit;
        double scaledRadIntensity = Math.pow(Math.pow(rawRadIntensity, Config.CONFIG.Reactor.FuelReactivity) / (double)this.controlRods.length, Config.CONFIG.Reactor.FuelReactivity) * (double)this.controlRods.length;
        this.initialHardness = Math.min(1.0, (double)0.2f + 0.8 * radiationPenaltyBase);
        double rawIntensity = 1.0 + -Config.CONFIG.Reactor.RadIntensityScalingMultiplier * Math.exp(-10.0 * Config.CONFIG.Reactor.RadIntensityScalingShiftMultiplier * Math.exp((double)-0.001f * Config.CONFIG.Reactor.RadIntensityScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        this.fuelAbsorptionTemperatureCoefficient = 1.0 - Config.CONFIG.Reactor.FuelAbsorptionScalingMultiplier * Math.exp(-10.0 * Config.CONFIG.Reactor.FuelAbsorptionScalingShiftMultiplier * Math.exp(-0.001 * Config.CONFIG.Reactor.FuelAbsorptionScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double FuelUsageMultiplier = Config.CONFIG.Reactor.FuelUsageMultiplier;
        double FuelPerRadiationUnit = Config.CONFIG.Reactor.FuelPerRadiationUnit;
        this.FuelAbsorptionCoefficient = Config.CONFIG.Reactor.FuelAbsorptionCoefficient;
        this.FuelModerationFactor = Config.CONFIG.Reactor.FuelModerationFactor;
        this.fuelHardnessMultiplier = 1.0 / Config.CONFIG.Reactor.FuelHardnessDivisor;
        this.rayMultiplier = 1.0 / (double)(SimUtil.rays.size() * this.y);
        double rawFuelUsage = 0.0;
        double fuelRFAdded = 0.0;
        for (int i = 0; i < this.controlRods.length; ++i) {
            SimUtil.ControlRod rod = this.controlRods[i];
            double controlRodModifier = (100.0 - rod.insertion) / 100.0;
            double effectiveRadIntensity = scaledRadIntensity * controlRodModifier;
            double effectiveRawRadIntensity = rawRadIntensity * controlRodModifier;
            double initialIntensity = effectiveRadIntensity * rawIntensity;
            rawFuelUsage += FuelPerRadiationUnit * effectiveRawRadIntensity / this.fertility() * FuelUsageMultiplier;
            fuelRFAdded += initialIntensity;
            this.initialIntensties[i] = initialIntensity;
        }
        this.rawFuelUsage = rawFuelUsage / (double)this.controlRods.length;
        this.fuelRFAdded = fuelRFAdded;
    }

    protected void collectIrradiationResult(IrradiationResult result) {
        this.fuelRFAdded += result.fuelRFAdded;
        this.fuelRadAdded += result.fuelRadAdded;
        this.caseRFAdded += result.caseRFAdded;
        result.fuelRFAdded = 0.0;
        result.fuelRadAdded = 0.0;
        result.caseRFAdded = 0.0;
    }

    protected double realizeIrradiationTick() {
        double FEPerRadiationUnit = Config.CONFIG.Reactor.FEPerRadiationUnit;
        this.caseRFAdded *= FEPerRadiationUnit;
        this.fuelRFAdded *= FEPerRadiationUnit;
        this.fuelRFAdded /= (double)this.controlRods.length;
        this.fuelRadAdded /= (double)this.controlRods.length;
        this.caseRFAdded /= (double)this.controlRods.length;
        if (!Double.isNaN(this.fuelRadAdded)) {
            if (Config.CONFIG.Reactor.fuelRadScalingMultiplier != 0.0) {
                this.fuelRadAdded *= Config.CONFIG.Reactor.fuelRadScalingMultiplier * ((double)Config.CONFIG.Reactor.PerFuelRodCapacity / Math.max(1.0, (double)this.fuelTank().totalStored()));
            }
            this.fuelFertility += this.fuelRadAdded;
        }
        if (!Double.isNaN(this.fuelRFAdded)) {
            this.fuelHeat.absorbRF(this.fuelRFAdded);
        }
        if (!Double.isNaN(this.caseRFAdded)) {
            this.stackHeat.absorbRF(this.caseRFAdded);
        }
        this.fuelRFAdded = 0.0;
        this.fuelRadAdded = 0.0;
        this.caseRFAdded = 0.0;
        return this.rawFuelUsage;
    }

    protected void runIrradiationRequest(IrradiationRequest request) {
        double FuelAbsorptionCoefficient = this.FuelAbsorptionCoefficient;
        double FuelModerationFactor = this.FuelModerationFactor;
        double fuelHardnessMultiplier = this.fuelHardnessMultiplier;
        double rayMultiplier = this.rayMultiplier;
        ModeratorCache[] moderatorCache = request.moderatorCache;
        double fuelRFAdded = 0.0;
        double fuelRadAdded = 0.0;
        double caseRFAdded = 0.0;
        double[] intensities = request.intensities;
        double[] hardnesses = request.hardnesses;
        int rods = 0;
        for (int cro = 0; cro < request.controlRodCount; ++cro) {
            int cri = cro + request.baseControlRod;
            SimUtil.ControlRod controlRod = this.controlRods[cri];
            double initialIntensity = this.initialIntensties[cri] * rayMultiplier;
            block1: for (int i = 0; i < SimUtil.rays.size(); ++i) {
                for (int j = 0; j < intensities.length; ++j) {
                    intensities[j] = initialIntensity;
                    hardnesses[j] = this.initialHardness;
                }
                ArrayList<SimUtil.RayStep> raySteps = SimUtil.rays.get(i);
                block3: for (int j = 0; j < raySteps.size(); ++j) {
                    SimUtil.RayStep step = raySteps.get(j);
                    int currentX = controlRod.x + step.offset.x;
                    int offsetY = step.offset.y;
                    int currentZ = controlRod.z + step.offset.z;
                    if (currentX < 0 || currentX >= this.x || currentZ < 0 || currentZ >= this.z) continue block1;
                    int moderatorIndexIndex = (currentX * this.z + currentZ) * this.y;
                    byte baseModeratorIndex = this.getModeratorIndex(moderatorIndexIndex);
                    if (baseModeratorIndex != 0) {
                        for (int k = 0; k < this.y; ++k) {
                            int currentY = k + offsetY;
                            if (currentY < 0) {
                                k -= currentY;
                                --k;
                                continue;
                            }
                            if (currentY >= this.y) continue block3;
                            double neutronIntensity = intensities[k];
                            double neutronHardness = hardnesses[k];
                            byte moderatorIndex = this.moderatorIndices[moderatorIndexIndex + currentY];
                            ModeratorCache properties = moderatorCache[moderatorIndex];
                            double radiationAbsorbed = neutronIntensity * properties.absorption * (1.0 - neutronHardness) * step.length;
                            intensities[k] = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                            hardnesses[k] = neutronHardness / (properties.moderation * step.length + 1.0);
                            caseRFAdded += properties.heatEfficiency * radiationAbsorbed;
                        }
                        continue;
                    }
                    double controlRodInsertion = this.controlRodsXZ[currentX][currentZ].insertion * 0.001;
                    double halfRodInsertion = controlRodInsertion * 0.5;
                    double fuelModerationFactor = FuelModerationFactor + (FuelModerationFactor * controlRodInsertion + controlRodInsertion);
                    double hardnessMultiplier = 1.0 / ((fuelModerationFactor - 1.0) * step.length + 1.0);
                    double stepFuelAbsorptionCoefficient = FuelAbsorptionCoefficient * step.length;
                    for (int k = 0; k < this.y; ++k) {
                        int currentY = k + offsetY;
                        if (currentY < 0) {
                            k -= currentY;
                            --k;
                            continue;
                        }
                        if (currentY >= this.y) continue block3;
                        ++rods;
                        double neutronIntensity = intensities[k];
                        double neutronHardness = hardnesses[k];
                        double baseAbsorption = this.fuelAbsorptionTemperatureCoefficient * (1.0 - neutronHardness * fuelHardnessMultiplier);
                        double scaledAbsorption = baseAbsorption * stepFuelAbsorptionCoefficient;
                        double controlRodBonus = (1.0 - scaledAbsorption) * halfRodInsertion;
                        double controlRodPenalty = scaledAbsorption * halfRodInsertion;
                        double radiationAbsorbed = (scaledAbsorption + controlRodBonus) * neutronIntensity;
                        double fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * neutronIntensity;
                        intensities[k] = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                        hardnesses[k] = neutronHardness * hardnessMultiplier;
                        fuelRFAdded += radiationAbsorbed;
                        fuelRadAdded += fertilityAbsorbed;
                    }
                }
            }
        }
        request.result.fuelRFAdded = fuelRFAdded;
        request.result.fuelRadAdded = fuelRadAdded;
        request.result.caseRFAdded = caseRFAdded;
    }

    protected byte getModeratorIndex(int moderatorIndexIndex) {
        return this.moderatorIndices[moderatorIndexIndex];
    }

    protected static class IrradiationRequest {
        public final int baseControlRod;
        public final int controlRodCount;
        public final IrradiationResult result = new IrradiationResult();
        public final ModeratorCache[] moderatorCache;
        public final double[] intensities;
        public final double[] hardnesses;

        public IrradiationRequest(int baseControlRod, int controlRodCount, ModeratorCache[] moderatorCache, int controlRodLength) {
            this.baseControlRod = baseControlRod;
            this.controlRodCount = controlRodCount;
            this.moderatorCache = new ModeratorCache[moderatorCache.length];
            for (int i = 0; i < moderatorCache.length; ++i) {
                this.moderatorCache[i] = moderatorCache[i].duplicate();
            }
            this.intensities = new double[controlRodLength];
            this.hardnesses = new double[controlRodLength];
        }

        public void updateCache() {
            for (int i = 0; i < this.moderatorCache.length; ++i) {
                this.moderatorCache[i].update();
            }
        }
    }

    protected static class IrradiationResult {
        public double fuelRFAdded = 0.0;
        public double fuelRadAdded = 0.0;
        public double caseRFAdded = 0.0;

        protected IrradiationResult() {
        }
    }

    public static class MultiThreaded
    extends FullPassReactorSimulation {
        @Nullable
        protected final Runnable[] irradiationRequestRunnables;
        @Nullable
        protected final IrradiationRequest[] irradiationRequests;
        @Nullable
        protected final Event[] irradiationRequestEvents;
        @Nullable
        private Event doneEvent;
        private final Runnable mainRunnable = () -> this.runIrradiationRequest(this.fullPassIrradiationRequest);

        public MultiThreaded(SimulationDescription simulationDescription, boolean singleThread) {
            super(simulationDescription);
            if (!singleThread) {
                ModeratorCache[] cacheArray = (ModeratorCache[])this.moderatorCaches.toArray((Object[])new ModeratorCache[0]);
                int batchSize = Config.CONFIG.Reactor.ModeSpecific.ControlRodBatchSize;
                int batches = this.controlRods.length / batchSize + (this.controlRods.length % batchSize == 0 ? 0 : 1);
                this.irradiationRequestRunnables = new Runnable[batches];
                this.irradiationRequests = new IrradiationRequest[batches];
                this.irradiationRequestEvents = new Event[batches];
                for (int i = 0; i < batches; ++i) {
                    int baseRod = i * batchSize;
                    int rodCount = Math.min(batchSize, this.controlRods.length - baseRod);
                    IrradiationRequest request = new IrradiationRequest(baseRod, rodCount, cacheArray, this.y);
                    this.irradiationRequestRunnables[i] = () -> this.runIrradiationRequest(request);
                    this.irradiationRequests[i] = request;
                }
            } else {
                this.irradiationRequestRunnables = null;
                this.irradiationRequests = null;
                this.irradiationRequestEvents = null;
            }
        }

        @Override
        protected double radiate() {
            if (this.irradiationRequests != null && this.irradiationRequestEvents != null && this.irradiationRequestRunnables != null) {
                for (int i = 0; i < this.irradiationRequests.length; ++i) {
                    Event event = this.irradiationRequestEvents[i];
                    if (event == null) continue;
                    event.join();
                    this.irradiationRequestEvents[i] = null;
                    this.collectIrradiationResult(this.irradiationRequests[i].result);
                }
            } else if (this.doneEvent != null) {
                this.doneEvent.join();
                this.doneEvent = null;
                this.collectIrradiationResult(this.fullPassIrradiationRequest.result);
            }
            return this.realizeIrradiationTick();
        }

        @Override
        protected void startNextRadiate() {
            if (this.fuelTank.fuel() <= 0L) {
                return;
            }
            this.setupIrradiationTick();
            if (this.irradiationRequests != null && this.irradiationRequestEvents != null && this.irradiationRequestRunnables != null) {
                for (int i = 0; i < this.irradiationRequests.length; ++i) {
                    this.irradiationRequests[i].updateCache();
                    this.irradiationRequestEvents[i] = Queues.offThread.enqueue(this.irradiationRequestRunnables[i], new Event[0]);
                }
            } else {
                this.fullPassIrradiationRequest.updateCache();
                this.doneEvent = Queues.offThread.enqueue(this.mainRunnable, new Event[0]);
            }
        }

        @Override
        public boolean isAsync() {
            return true;
        }
    }
}

