/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.accellerated.ocl;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Cleaner;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL11;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class CLUtil {
    public static final long SIZEOF_REACTOR_INFO = 36L;
    public static final long SIZEOF_MODERATOR = 12L;
    public static final long SIZEOF_RAY = 8L;
    public static final long SIZEOF_RAY_STEP = 16L;
    public static final long SIZEOF_ROD_RAY_INFO = 4L;
    public static final long SIZEOF_RAY_BURN_INFO = 12L;
    private static final Cleaner CL_CLEANER;
    private static final Logger LOGGER;
    public static final boolean available;
    private static final long platform;
    private static final long context;
    private static final long program;
    private static final LongArrayList devices;
    private static final long largestSizeMultiple;
    private static final LongArrayList sizeMultiples;
    private static final LongArrayList maxWorkGroupSizes;
    private static final AtomicInteger nextDevice;

    public long createCommandQueue(long device, IntBuffer returnCode) {
        long queue = CL11.clCreateCommandQueue((long)context, (long)device, (long)0L, (IntBuffer)returnCode);
        CLUtil.checkReturnCode(returnCode.get(0));
        CL_CLEANER.register(this, () -> CL11.clReleaseCommandQueue((long)queue));
        return queue;
    }

    public PointerBuffer allocPointer(int capacity) {
        PointerBuffer buffer = MemoryUtil.memAllocPointer((int)capacity);
        CL_CLEANER.register(this, () -> MemoryUtil.memFree((CustomBuffer)buffer));
        return buffer;
    }

    public LongBuffer allocLong(int capacity) {
        LongBuffer buffer = MemoryUtil.memAllocLong((int)capacity);
        CL_CLEANER.register(this, () -> MemoryUtil.memFree((Buffer)buffer));
        return buffer;
    }

    public IntBuffer allocInt(int capacity) {
        IntBuffer buffer = MemoryUtil.memAllocInt((int)capacity);
        CL_CLEANER.register(this, () -> MemoryUtil.memFree((Buffer)buffer));
        return buffer;
    }

    public FloatBuffer allocFloat(int capacity) {
        FloatBuffer buffer = MemoryUtil.memAllocFloat((int)capacity);
        CL_CLEANER.register(this, () -> MemoryUtil.memFree((Buffer)buffer));
        return buffer;
    }

    public long createCLKernel(String name, IntBuffer errorBuffer) {
        long kernel = CL11.clCreateKernel((long)program, (CharSequence)name, (IntBuffer)errorBuffer);
        CLUtil.checkReturnCode(errorBuffer.get(0));
        CL_CLEANER.register(this, () -> CL11.clReleaseKernel((long)kernel));
        return kernel;
    }

    public long createCLBuffer(long flags, long size, IntBuffer errorBuffer) {
        long buffer = CL11.clCreateBuffer((long)context, (long)flags, (long)size, (IntBuffer)errorBuffer);
        CLUtil.checkReturnCode(errorBuffer.get(0));
        CL_CLEANER.register(this, () -> CL11.clReleaseMemObject((long)buffer));
        return buffer;
    }

    private static int getNextDeviceIndex() {
        if (devices.size() == 1) {
            return 0;
        }
        int deviceIndex = nextDevice.incrementAndGet();
        if (deviceIndex > devices.size()) {
            nextDevice.addAndGet(-devices.size());
        }
        return deviceIndex %= devices.size();
    }

    static long nextDevice() {
        return devices.getLong(CLUtil.getNextDeviceIndex());
    }

    @OnModLoad(required=false)
    private static void onModLoad() {
    }

    public static void shutdown() {
        if (!available) {
            return;
        }
        CL11.clReleaseContext((long)context);
    }

    static void checkReturnCode(int code) {
        switch (code) {
            case 0: {
                break;
            }
            case -1: {
                throw new IllegalStateException("CL_DEVICE_NOT_FOUND");
            }
            case -2: {
                throw new IllegalStateException("CL_DEVICE_NOT_AVAILABLE");
            }
            case -3: {
                throw new IllegalStateException("CL_COMPILER_NOT_AVAILABLE");
            }
            case -4: {
                throw new IllegalStateException("CL_MEM_OBJECT_ALLOCATION_FAILURE");
            }
            case -5: {
                throw new IllegalStateException("CL_OUT_OF_RESOURCES");
            }
            case -6: {
                throw new IllegalStateException("CL_OUT_OF_HOST_MEMORY");
            }
            case -7: {
                throw new IllegalStateException("CL_PROFILING_INFO_NOT_AVAILABLE");
            }
            case -8: {
                throw new IllegalStateException("CL_MEM_COPY_OVERLAP");
            }
            case -9: {
                throw new IllegalStateException("CL_IMAGE_FORMAT_MISMATCH");
            }
            case -10: {
                throw new IllegalStateException("CL_IMAGE_FORMAT_NOT_SUPPORTED");
            }
            case -11: {
                throw new IllegalStateException("CL_BUILD_PROGRAM_FAILURE");
            }
            case -12: {
                throw new IllegalStateException("CL_MAP_FAILURE");
            }
            case -30: {
                throw new IllegalStateException("CL_INVALID_VALUE");
            }
            case -31: {
                throw new IllegalStateException("CL_INVALID_DEVICE_TYPE");
            }
            case -32: {
                throw new IllegalStateException("CL_INVALID_PLATFORM");
            }
            case -33: {
                throw new IllegalStateException("CL_INVALID_DEVICE");
            }
            case -34: {
                throw new IllegalStateException("CL_INVALID_CONTEXT");
            }
            case -35: {
                throw new IllegalStateException("CL_INVALID_QUEUE_PROPERTIES");
            }
            case -36: {
                throw new IllegalStateException("CL_INVALID_COMMAND_QUEUE");
            }
            case -37: {
                throw new IllegalStateException("CL_INVALID_HOST_PTR");
            }
            case -38: {
                throw new IllegalStateException("CL_INVALID_MEM_OBJECT");
            }
            case -39: {
                throw new IllegalStateException("CL_INVALID_IMAGE_FORMAT_DESCRIPTOR");
            }
            case -40: {
                throw new IllegalStateException("CL_INVALID_IMAGE_SIZE");
            }
            case -41: {
                throw new IllegalStateException("CL_INVALID_SAMPLER");
            }
            case -42: {
                throw new IllegalStateException("CL_INVALID_BINARY");
            }
            case -43: {
                throw new IllegalStateException("CL_INVALID_BUILD_OPTIONS");
            }
            case -44: {
                throw new IllegalStateException("CL_INVALID_PROGRAM");
            }
            case -45: {
                throw new IllegalStateException("CL_INVALID_PROGRAM_EXECUTABLE");
            }
            case -46: {
                throw new IllegalStateException("CL_INVALID_KERNEL_NAME");
            }
            case -47: {
                throw new IllegalStateException("CL_INVALID_KERNEL_DEFINITION");
            }
            case -48: {
                throw new IllegalStateException("CL_INVALID_KERNEL");
            }
            case -49: {
                throw new IllegalStateException("CL_INVALID_ARG_INDEX");
            }
            case -50: {
                throw new IllegalStateException("CL_INVALID_ARG_VALUE");
            }
            case -51: {
                throw new IllegalStateException("CL_INVALID_ARG_SIZE");
            }
            case -52: {
                throw new IllegalStateException("CL_INVALID_KERNEL_ARGS");
            }
            case -53: {
                throw new IllegalStateException("CL_INVALID_WORK_DIMENSION");
            }
            case -54: {
                throw new IllegalStateException("CL_INVALID_WORK_GROUP_SIZE");
            }
            case -55: {
                throw new IllegalStateException("CL_INVALID_WORK_ITEM_SIZE");
            }
            case -56: {
                throw new IllegalStateException("CL_INVALID_GLOBAL_OFFSET");
            }
            case -57: {
                throw new IllegalStateException("CL_INVALID_EVENT_WAIT_LIST");
            }
            case -58: {
                throw new IllegalStateException("CL_INVALID_EVENT");
            }
            case -59: {
                throw new IllegalStateException("CL_INVALID_OPERATION");
            }
            case -61: {
                throw new IllegalStateException("CL_INVALID_BUFFER_SIZE");
            }
            case -63: {
                throw new IllegalStateException("CL_INVALID_GLOBAL_WORK_SIZE");
            }
            default: {
                throw new IllegalStateException("Unknown CL Error: " + code);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block39: {
            block41: {
                block40: {
                    block38: {
                        CLUtil.CL_CLEANER = Cleaner.create();
                        CLUtil.LOGGER = LogManager.getLogger((String)"BiggerReactors/Reactor/OpenCL");
                        CLUtil.devices = new LongArrayList();
                        CLUtil.sizeMultiples = new LongArrayList();
                        CLUtil.maxWorkGroupSizes = new LongArrayList();
                        CLUtil.nextDevice = new AtomicInteger();
                        forcePlatform = -1;
                        debug = false;
                        CLUtil.LOGGER.warn("Initializing OpenCL, may cause native level crash, check debug log for details");
                        available1 = false;
                        platform1 = -1L;
                        context1 = -1L;
                        largestSizeMultiple1 = -1L;
                        program1 = -1L;
                        CLUtil.LOGGER.info("Creating LWJGL memory stack");
                        stack = MemoryStack.create((int)0x4000000).push();
                        platformCount = stack.mallocInt(1);
                        try {
                            CLUtil.LOGGER.info("Checking for LWJGL OpenCL classes");
                            CL11.clGetPlatformIDs(null, (IntBuffer)platformCount);
                        }
                        catch (Throwable ignored) {
                            CLUtil.LOGGER.info("Failed to load LWJGL OpenCL Classes");
                            if (stack == null) ** GOTO lbl184
                            stack.close();
                        }
                        CLUtil.LOGGER.info("Success");
                        platforms = platformCount.get(0);
                        if (platforms != 0) break block38;
                        CLUtil.LOGGER.info("No OpenCL platforms found, disabling");
                        ** if (stack == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            stack.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block39;
                        }
                    }
                    platformIDs = stack.mallocPointer(platforms);
                    CLUtil.LOGGER.info("Querying Platforms");
                    CLUtil.checkReturnCode(CL11.clGetPlatformIDs((PointerBuffer)platformIDs, (IntBuffer)platformCount));
                    CLUtil.LOGGER.info(String.format("%d Platforms found", new Object[]{platformCount.get(0)}));
                    CLUtil.LOGGER.info("Querying Platform Devices");
                    selectedPlatform = 0L;
                    selectedPlatformIndex = -1;
                    selectedGPUCount = 0;
                    deviceCount = stack.mallocInt(1);
                    platformNameSize = stack.mallocPointer(1);
                    platformName = null;
                    for (i = 0; i < platformCount.get(0); ++i) {
                        CLUtil.LOGGER.info(String.format("Querying GPUs for platform %d", new Object[]{i}));
                        currentPlatform = platformIDs.get(i);
                        CL11.clGetPlatformInfo((long)currentPlatform, (int)2306, (ByteBuffer)null, (PointerBuffer)platformNameSize);
                        if (platformName == null || (long)platformName.capacity() < platformNameSize.get(0)) {
                            platformName = stack.malloc((int)platformNameSize.get(0));
                        }
                        CL11.clGetPlatformInfo((long)currentPlatform, (int)2306, (ByteBuffer)platformName, null);
                        CLUtil.LOGGER.info(String.format("Platform Name: %s", new Object[]{Charset.defaultCharset().decode((ByteBuffer)platformName)}));
                        returnCode = CL11.clGetDeviceIDs((long)currentPlatform, (long)4L, null, (IntBuffer)deviceCount);
                        if (returnCode == -1) {
                            CLUtil.LOGGER.info(String.format("No GPUs found for platform %d", new Object[]{i}));
                            if (selectedPlatform != 0L) continue;
                            selectedPlatform = currentPlatform;
                            selectedPlatformIndex = i;
                            CLUtil.LOGGER.info(String.format("Platform %d currently selected", new Object[]{selectedPlatformIndex}));
                            continue;
                        }
                        CLUtil.checkReturnCode(returnCode);
                        CLUtil.LOGGER.info(String.format("%d GPUs found for platform %d", new Object[]{deviceCount.get(0), i}));
                        if (deviceCount.get(0) <= selectedGPUCount) continue;
                        selectedPlatform = currentPlatform;
                        selectedGPUCount = deviceCount.get(0);
                        selectedPlatformIndex = i;
                        CLUtil.LOGGER.info(String.format("Platform %d currently selected", new Object[]{selectedPlatformIndex}));
                    }
                    if (selectedPlatform != 0L) break block40;
                    CLUtil.LOGGER.info("No platform selected");
                    ** if (stack == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        stack.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block39;
                    }
                }
                CLUtil.LOGGER.info(String.format("Selected platform %d", new Object[]{selectedPlatformIndex}));
                platform1 = selectedPlatform;
                contextProperties = stack.mallocPointer(4);
                contextProperties.put(0, 4228L);
                contextProperties.put(1, platform1);
                contextProperties.put(2, 0L);
                contextProperties.put(3, 0L);
                CLUtil.LOGGER.info("Creating context");
                context1 = CL11.clCreateContextFromType((PointerBuffer)contextProperties, (long)-1L, null, (long)0L, (IntBuffer)null);
                if (context1 != 0L) break block41;
                ** if (stack == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    stack.close();
                }
lbl-1000:
                // 2 sources

                {
                    break block39;
                }
            }
            CLUtil.LOGGER.info("Getting context device info");
            CL11.clGetContextInfo((long)context1, (int)4227, (IntBuffer)deviceCount, null);
            devicesBB = stack.malloc(deviceCount.get(0) * 8);
            CL11.clGetContextInfo((long)context1, (int)4225, (ByteBuffer)devicesBB, null);
            devicesLB = devicesBB.asLongBuffer();
            intBuffer = stack.mallocInt(1);
            longBuffer = stack.mallocLong(1);
            CLUtil.LOGGER.info("Getting devices");
            for (i = 0; i < deviceCount.get(0); ++i) {
                device = devicesLB.get(i);
                CLUtil.devices.add(device);
                CL11.clGetDeviceInfo((long)device, (int)4531, (LongBuffer)longBuffer, null);
                sizeMultiple = longBuffer.get(0);
                CLUtil.sizeMultiples.add(sizeMultiple);
                if (sizeMultiple > largestSizeMultiple1) {
                    largestSizeMultiple1 = sizeMultiple;
                }
                CL11.clGetDeviceInfo((long)device, (int)4100, (LongBuffer)longBuffer, null);
                CLUtil.maxWorkGroupSizes.add(longBuffer.get(0));
            }
            CLUtil.LOGGER.info("Creating program");
            CLUtil.LOGGER.info("Reading file");
            try {
                in = CLUtil.class.getResourceAsStream("/opencl/reactorsim.cl");
                try {
                    reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(in)));
                    try {
                        builder = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            builder.append(line);
                            builder.append('\n');
                        }
                        programSource = builder.toString();
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (stack == null) ** GOTO lbl184
                stack.close();
            }
            try {
                CLUtil.LOGGER.info("Creating CL program");
                program1 = CL11.clCreateProgramWithSource((long)context1, (CharSequence)programSource, (IntBuffer)intBuffer);
                CLUtil.checkReturnCode(intBuffer.get(0));
                CLUtil.LOGGER.info("Building CL program");
                returnCode = CL11.clBuildProgram((long)program1, null, (CharSequence)String.format("-DMAX_RAY_STEPS=%d -cl-fast-relaxed-math", new Object[]{Config.CONFIG.Reactor.IrradiationDistance * 2L}), null, (long)0L);
                if (returnCode == -11) {
                    pointerBuf = stack.mallocPointer(1);
                    for (Long device : CLUtil.devices) {
                        CL11.clGetProgramBuildInfo((long)program1, (long)device, (int)4483, (ByteBuffer)null, (PointerBuffer)pointerBuf);
                        stringBuf = stack.malloc((int)pointerBuf.get(0));
                        CL11.clGetProgramBuildInfo((long)program1, (long)device, (int)4483, (ByteBuffer)stringBuf, (PointerBuffer)pointerBuf);
                        CLUtil.LOGGER.info((CharSequence)Charset.defaultCharset().decode(stringBuf));
                    }
                }
                CLUtil.checkReturnCode(returnCode);
            }
            catch (Throwable var12_9) {
                throw var12_9;
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
            CLUtil.LOGGER.info("CL loading complete");
            available1 = true;
        }
        CLUtil.available = available1;
        CLUtil.platform = platform1;
        CLUtil.context = context1;
        CLUtil.largestSizeMultiple = largestSizeMultiple1;
        CLUtil.program = program1;
        if (!CLUtil.available) {
            CLUtil.LOGGER.info("OpenCL acceleration not available");
        }
    }
}

