/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorFuelRod;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorManifold;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimulationDescription;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorAccessPortTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorControlRodTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorCoolantPortTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorFuelRodTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorGlassTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorManifoldTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorPowerTapTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorTerminalTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.util.ReactorTransitionTank;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.ValidationException;
import net.roguelogix.phosphophyllite.multiblock.common.IEventMultiblock;
import net.roguelogix.phosphophyllite.multiblock.common.IPersistentMultiblock;
import net.roguelogix.phosphophyllite.multiblock.common.ITickablePartsMultiblock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblock;
import net.roguelogix.phosphophyllite.multiblock.touching.ITouchingMultiblock;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@NonnullDefault
@ParametersAreNonnullByDefault
public class ReactorMultiblockController
extends MultiblockController<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController>
implements IRectangularMultiblock<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController>,
IPersistentMultiblock<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController>,
ITouchingMultiblock<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController>,
IEventMultiblock<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController>,
ITickablePartsMultiblock<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController> {
    private int foundRods = 0;
    private int foundManifolds = 0;
    private boolean updateBlockStates = false;
    private ReactorActivity reactorActivity = ReactorActivity.INACTIVE;
    private final Set<ReactorTerminalTile> terminals = new HashSet<ReactorTerminalTile>();
    private final ObjectArrayList<ReactorControlRodTile> controlRods = new ObjectArrayList();
    private final ObjectArrayList<ReactorFuelRodTile> fuelRods = new ObjectArrayList();
    private final ObjectArrayList<ObjectArrayList<ReactorFuelRodTile>> fuelRodsByLevel = ObjectArrayList.wrap((Object[])new ObjectArrayList[0]);
    private final Set<ReactorPowerTapTile> powerPorts = new HashSet<ReactorPowerTapTile>();
    private final Set<ReactorAccessPortTile> accessPorts = new HashSet<ReactorAccessPortTile>();
    private final Set<ReactorCoolantPortTile> coolantPorts = new HashSet<ReactorCoolantPortTile>();
    private final ObjectArrayList<ReactorManifoldTile> manifolds = new ObjectArrayList();
    @Nullable
    private IReactorSimulation simulation;
    @Nullable
    PhosphophylliteCompound simulationData;
    @Nullable
    ReactorTransitionTank coolantTank;
    @Nullable
    CompoundTag coolantTankNBT;
    private boolean forceDirty = false;
    long currentFuelRenderLevel = 0L;
    long currentWasteRenderLevel = 0L;
    private boolean autoEjectWaste = true;

    public ReactorMultiblockController(Level level) {
        super(level, ReactorBaseTile.class, ReactorBaseBlock.class);
    }

    @Nullable
    public Vector3ic minSize() {
        return new Vector3i(3);
    }

    @Nullable
    public Vector3ic maxSize() {
        return new Vector3i(Config.CONFIG.Reactor.MaxLength, Config.CONFIG.Reactor.MaxHeight, Config.CONFIG.Reactor.MaxWidth);
    }

    public void rectangularValidationStarted() {
        this.foundRods = 0;
        this.foundManifolds = 0;
    }

    public void rectangularBlockValidated(Block block) {
        if (block == ReactorFuelRod.INSTANCE) {
            ++this.foundRods;
        }
        if (block == ReactorManifold.INSTANCE) {
            ++this.foundManifolds;
        }
    }

    public boolean allowedInteriorBlock(Block block) {
        return ReactorModeratorRegistry.isBlockAllowed(block);
    }

    public void validateStage1() throws ValidationException {
        if (this.terminals.isEmpty()) {
            throw new ValidationException("multiblock.error.biggerreactors.no_terminal");
        }
        if (this.controlRods.isEmpty()) {
            throw new ValidationException("multiblock.error.biggerreactors.no_rods");
        }
        if (!this.powerPorts.isEmpty() && !this.coolantPorts.isEmpty()) {
            throw new ValidationException("multiblock.error.biggerreactors.coolant_and_power_ports");
        }
    }

    public void validateStage2() throws ValidationException {
        if (this.foundRods > this.fuelRods.size()) {
            Util.chunkCachedBlockStateIteration((Vector3ic)this.min().add(1, 1, 1, new Vector3i()), (Vector3ic)this.max().sub(1, 1, 1, new Vector3i()), (Level)this.level, (state, position) -> {
                ReactorFuelRodTile fuelRodTile;
                if (!(state.m_60734_() instanceof ReactorFuelRod)) {
                    return;
                }
                ReactorBaseTile tile = (ReactorBaseTile)this.blocks.getTile((Vector3ic)position);
                if (tile == null || tile instanceof ReactorFuelRodTile && (fuelRodTile = (ReactorFuelRodTile)tile).controller() != this) {
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.reactor.dangling_rod", (Object[])new Object[]{position.toString()}));
                }
            });
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.reactor.dangling_rod_unknown_position"));
        }
        if (this.foundManifolds > this.manifolds.size()) {
            Util.chunkCachedBlockStateIteration((Vector3ic)this.min().add(1, 1, 1, new Vector3i()), (Vector3ic)this.max().sub(1, 1, 1, new Vector3i()), (Level)this.level, (state, position) -> {
                ReactorManifoldTile manifoldTile;
                if (!(state.m_60734_() instanceof ReactorManifold)) {
                    return;
                }
                ReactorBaseTile tile = (ReactorBaseTile)this.blocks.getTile((Vector3ic)position);
                if (tile == null || tile instanceof ReactorManifoldTile && (manifoldTile = (ReactorManifoldTile)tile).controller() != this) {
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.reactor.dangling_manifold", (Object[])new Object[]{position.toString()}));
                }
            });
            throw new ValidationException((Component)Component.m_237115_((String)"multiblock.error.biggerreactors.reactor.dangling_manifold_unknown_position"));
        }
        long tick = Phosphophyllite.tickNumber();
        int maxY = this.max().y();
        int internalMinY = this.min().y() + 1;
        int rodCount = 0;
        for (int j = 0; j < this.controlRods.size(); ++j) {
            BlockPos controlRodPos = ((ReactorControlRodTile)((Object)this.controlRods.get(j))).m_58899_();
            if (controlRodPos.m_123342_() != this.max().y()) {
                throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.control_rod_not_on_top", (Object[])new Object[]{controlRodPos.m_123341_(), controlRodPos.m_123342_(), controlRodPos.m_123343_()}));
            }
            int x = controlRodPos.m_123341_();
            int z = controlRodPos.m_123343_();
            for (int i = internalMinY; i < maxY; ++i) {
                ReactorBaseTile tile = (ReactorBaseTile)this.blocks.getTile(x, i, z);
                if (!(tile instanceof ReactorFuelRodTile)) {
                    throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.fuel_rod_gap", (Object[])new Object[]{controlRodPos.m_123341_(), i, controlRodPos.m_123343_()}));
                }
                ((ReactorFuelRodTile)tile).lastCheckedTick = tick;
                ++rodCount;
            }
        }
        if (rodCount != this.fuelRods.size()) {
            for (int i = 0; i < this.fuelRods.size(); ++i) {
                ReactorFuelRodTile fuelRod = (ReactorFuelRodTile)((Object)this.fuelRods.get(i));
                if (fuelRod.lastCheckedTick == tick) continue;
                throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.no_control_rod_for_fuel_rod", (Object[])new Object[]{fuelRod.m_58899_().m_123341_(), fuelRod.m_58899_().m_123343_()}));
            }
        }
        if (!this.manifolds.isEmpty()) {
            BlockPos pos;
            ArrayList<Object> manifoldsToCheck = new ArrayList<Object>();
            Direction[] directions = Direction.values();
            int minx = this.min().x() + 1;
            int miny = this.min().y() + 1;
            int minz = this.min().z() + 1;
            int maxx = this.max().x() - 1;
            int maxy = this.max().y() - 1;
            int maxz = this.max().z() - 1;
            block3: for (ReactorManifoldTile manifold : this.manifolds) {
                pos = manifold.m_58899_();
                if (pos.m_123341_() != minx && pos.m_123341_() != maxx && pos.m_123342_() != miny && pos.m_123342_() != maxy && pos.m_123343_() != minz && pos.m_123343_() != maxz) continue;
                MultiblockTileModule<ReactorBaseTile, ReactorBaseBlock, ReactorMultiblockController> manifoldModule = manifold.multiblockModule();
                for (int i = 0; i < 6; ++i) {
                    BlockEntity neighborTile;
                    Direction direction = directions[i];
                    MultiblockTileModule neighborModule = manifoldModule.getNeighbor(direction);
                    if (neighborModule == null || (neighborTile = (BlockEntity)neighborModule.iface) instanceof ReactorGlassTile || !((ReactorBaseBlock)neighborTile.m_58900_().m_60734_()).isGoodForExterior()) continue;
                    manifoldsToCheck.add(manifoldModule);
                    manifold.lastCheckedTick = tick;
                    continue block3;
                }
            }
            while (!manifoldsToCheck.isEmpty()) {
                MultiblockTileModule manifoldModule = (MultiblockTileModule)manifoldsToCheck.remove(manifoldsToCheck.size() - 1);
                for (int i = 0; i < 6; ++i) {
                    BlockEntity neighborTile;
                    Direction direction = directions[i];
                    MultiblockTileModule neighborModule = manifoldModule.getNeighbor(direction);
                    if (neighborModule == null || !((neighborTile = (BlockEntity)neighborModule.iface) instanceof ReactorManifoldTile)) continue;
                    ReactorManifoldTile neighborManifoldTile = (ReactorManifoldTile)neighborTile;
                    if (neighborManifoldTile.lastCheckedTick == tick) continue;
                    manifoldsToCheck.add(neighborModule);
                    neighborManifoldTile.lastCheckedTick = tick;
                }
            }
            for (ReactorManifoldTile manifold : this.manifolds) {
                if (manifold.lastCheckedTick == tick) continue;
                pos = manifold.m_58899_();
                throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.biggerreactors.disconnected_manifold", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
            }
        }
    }

    protected synchronized void onPartAdded(ReactorBaseTile tile) {
        if (tile instanceof ReactorTerminalTile) {
            tile.index = this.terminals.size();
            this.terminals.add((ReactorTerminalTile)tile);
        }
        if (tile instanceof ReactorControlRodTile) {
            tile.index = this.controlRods.size();
            this.controlRods.add((Object)((ReactorControlRodTile)tile));
        }
        if (tile instanceof ReactorFuelRodTile) {
            tile.index = this.fuelRods.size();
            this.fuelRods.add((Object)((ReactorFuelRodTile)tile));
        }
        if (tile instanceof ReactorPowerTapTile) {
            tile.index = this.powerPorts.size();
            this.powerPorts.add((ReactorPowerTapTile)tile);
        }
        if (tile instanceof ReactorAccessPortTile) {
            tile.index = this.accessPorts.size();
            this.accessPorts.add((ReactorAccessPortTile)tile);
        }
        if (tile instanceof ReactorCoolantPortTile) {
            tile.index = this.coolantPorts.size();
            this.coolantPorts.add((ReactorCoolantPortTile)tile);
        }
        if (tile instanceof ReactorManifoldTile) {
            tile.index = this.manifolds.size();
            this.manifolds.add((Object)((ReactorManifoldTile)tile));
        }
    }

    protected synchronized void onPartRemoved(ReactorBaseTile tile) {
        int index;
        if (tile instanceof ReactorTerminalTile) {
            this.terminals.remove((Object)tile);
        }
        if (tile instanceof ReactorControlRodTile) {
            index = tile.index;
            ReactorControlRodTile endControlRod = (ReactorControlRodTile)((Object)this.controlRods.pop());
            if (index != this.controlRods.size()) {
                endControlRod.index = index;
                this.controlRods.set(index, (Object)endControlRod);
            }
        }
        if (tile instanceof ReactorFuelRodTile) {
            index = tile.index;
            ReactorFuelRodTile endFuelRod = (ReactorFuelRodTile)((Object)this.fuelRods.pop());
            if (index != this.fuelRods.size()) {
                endFuelRod.index = index;
                this.fuelRods.set(index, (Object)endFuelRod);
            }
        }
        if (tile instanceof ReactorPowerTapTile) {
            this.powerPorts.remove((Object)tile);
        }
        if (tile instanceof ReactorAccessPortTile) {
            this.accessPorts.remove((Object)tile);
        }
        if (tile instanceof ReactorCoolantPortTile) {
            this.coolantPorts.remove((Object)tile);
        }
        if (tile instanceof ReactorManifoldTile) {
            index = tile.index;
            ReactorManifoldTile endManifold = (ReactorManifoldTile)((Object)this.manifolds.pop());
            if (index != this.manifolds.size()) {
                endManifold.index = index;
                this.manifolds.set(index, (Object)endManifold);
            }
        }
    }

    public void updateBlockStates() {
        this.terminals.forEach(terminal -> {
            this.level.m_7731_(terminal.m_58899_(), (BlockState)terminal.m_58900_().m_61124_(ReactorActivity.REACTOR_ACTIVITY_ENUM_PROPERTY, (Comparable)((Object)this.reactorActivity)), 3);
            terminal.m_6596_();
        });
    }

    public synchronized void setActive(ReactorActivity newState) {
        if (this.reactorActivity != newState) {
            this.reactorActivity = newState;
            this.updateBlockStates = true;
        }
    }

    public void toggleActive() {
        this.setActive(this.reactorActivity == ReactorActivity.ACTIVE ? ReactorActivity.INACTIVE : ReactorActivity.ACTIVE);
    }

    public boolean isActive() {
        return this.reactorActivity == ReactorActivity.ACTIVE;
    }

    public CompoundTag mergeNBTs(CompoundTag nbtA, CompoundTag nbtB) {
        return nbtA;
    }

    public void read(CompoundTag compound) {
        if (compound.m_128441_("reactorState")) {
            this.reactorActivity = ReactorActivity.valueOf(compound.m_128461_("reactorState").toUpperCase(Locale.US));
        }
        if (compound.m_128441_("autoEjectWaste")) {
            this.autoEjectWaste = compound.m_128471_("autoEjectWaste");
        }
        if (compound.m_128441_("simulationData")) {
            this.simulation = null;
            this.simulationData = new PhosphophylliteCompound(compound.m_128463_("simulationData"));
        }
        if (compound.m_128441_("coolantTankWrapper")) {
            this.coolantTankNBT = compound.m_128469_("coolantTankWrapper");
        }
        this.updateBlockStates = true;
    }

    @Nonnull
    public CompoundTag write() {
        PhosphophylliteCompound phosCompound;
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("reactorState", this.reactorActivity.toString());
        compound.m_128379_("autoEjectWaste", this.autoEjectWaste);
        if (this.simulation != null && (phosCompound = this.simulation.save()) != null) {
            compound.m_177853_("simulationData", (List)phosCompound.toROBN());
        }
        if (this.coolantTank != null) {
            compound.m_128365_("coolantTankWrapper", (Tag)this.coolantTank.serializeNBT());
        }
        return compound;
    }

    protected void merge(ReactorMultiblockController other) {
        this.distributeFuel();
        other.distributeFuel();
    }

    public void onStateTransition(IValidatedMultiblock.AssemblyState oldAssemblyState, IValidatedMultiblock.AssemblyState newAssemblyState) {
        super.onStateTransition(oldAssemblyState, newAssemblyState);
        if (newAssemblyState == IValidatedMultiblock.AssemblyState.ASSEMBLED) {
            this.onValidationPassed();
        }
        for (ReactorCoolantPortTile coolantPort : this.coolantPorts) {
            coolantPort.onAssemblyStateTransition(oldAssemblyState, newAssemblyState);
        }
    }

    protected void onValidationPassed() {
        IReactorSimulation.ICoolantTank simCoolantTank;
        int i;
        SimulationDescription simulationDescription = new SimulationDescription();
        simulationDescription.setSize(this.max().x() - this.min().x() - 1, this.max().y() - this.min().y() - 1, this.max().z() - this.min().z() - 1);
        Vector3i start = new Vector3i(1).add(this.min());
        Vector3i end = new Vector3i(-1).add(this.max());
        Util.chunkCachedBlockStateIteration((Vector3ic)start, (Vector3ic)end, (Level)this.level, (state, pos) -> {
            if (!(state.m_60734_() instanceof ReactorBaseBlock)) {
                pos.sub((Vector3ic)start);
                simulationDescription.setModeratorProperties(pos.x, pos.y, pos.z, ReactorModeratorRegistry.blockModeratorProperties(state.m_60734_()));
            }
        });
        for (i = 0; i < this.manifolds.size(); ++i) {
            BlockPos manifoldPos = ((ReactorManifoldTile)((Object)this.manifolds.get(i))).m_58899_();
            simulationDescription.setManifold(manifoldPos.m_123341_() - start.x, manifoldPos.m_123342_() - start.y, manifoldPos.m_123343_() - start.z, true);
        }
        for (i = 0; i < this.controlRods.size(); ++i) {
            BlockPos rodPos = ((ReactorControlRodTile)((Object)this.controlRods.get(i))).m_58899_();
            simulationDescription.setControlRod(rodPos.m_123341_() - start.x, rodPos.m_123343_() - start.z, true);
        }
        simulationDescription.setPassivelyCooled(this.coolantPorts.isEmpty());
        simulationDescription.setAmbientTemperature(293.15);
        ReactorModeratorRegistry.ModeratorProperties airProperties = ReactorModeratorRegistry.blockModeratorProperties(Blocks.f_50016_);
        if (airProperties == null) {
            airProperties = ReactorModeratorRegistry.ModeratorProperties.EMPTY_MODERATOR;
        }
        simulationDescription.setDefaultIModeratorProperties(airProperties);
        if (this.simulation != null) {
            this.simulationData = this.simulation.save();
        }
        SimulationDescription.Builder simulationBuilder = new SimulationDescription.Builder(Config.CONFIG.mode == Config.Mode.EXPERIMENTAL, Config.CONFIG.Reactor.useFullPassSimulation, Config.CONFIG.Reactor.allowOffThreadSimulation, Config.CONFIG.Reactor.allowMultiThreadSimulation, Config.CONFIG.Reactor.allowAcceleratedSimulation);
        this.simulation = simulationBuilder.build(simulationDescription);
        if (this.simulationData != null) {
            this.simulation.load(this.simulationData);
        }
        if ((simCoolantTank = this.simulation.coolantTank()) != null) {
            this.coolantTank = new ReactorTransitionTank(simCoolantTank);
            if (this.coolantTankNBT != null) {
                this.coolantTank.deserializeNBT(this.coolantTankNBT);
            }
        }
        this.updateControlRodLevels();
        this.collectFuel();
        int levels = this.max().y() - this.min().y() - 1;
        int rodsPerLevel = this.fuelRods.size() / levels;
        this.fuelRodsByLevel.clear();
        this.fuelRodsByLevel.ensureCapacity(levels);
        for (int i2 = 0; i2 < levels; ++i2) {
            ObjectArrayList newList = new ObjectArrayList(rodsPerLevel);
            this.fuelRodsByLevel.add((Object)newList);
        }
        ObjectArrayList[] levelArrays = (ObjectArrayList[])this.fuelRodsByLevel.elements();
        int minY = this.min().y() + 1;
        for (int i3 = 0; i3 < this.fuelRods.size(); ++i3) {
            ReactorFuelRodTile rod = (ReactorFuelRodTile)((Object)this.fuelRods.get(i3));
            int rodLevel = rod.m_58899_().m_123342_();
            levelArrays[rodLevel -= minY].add((Object)rod);
        }
        this.updateFuelRenderingLevel(true);
    }

    public void onDisassembled() {
        this.distributeFuel();
        this.setActive(ReactorActivity.INACTIVE);
        if (this.simulation != null) {
            this.simulationData = this.simulation.save();
            this.simulation = null;
        }
    }

    @Nullable
    public IReactorSimulation simulation() {
        return this.simulation;
    }

    @Nullable
    public ReactorTransitionTank coolantTank() {
        return this.coolantTank;
    }

    public synchronized void tick() {
        IReactorSimulation.IBattery battery;
        if (this.updateBlockStates) {
            this.updateBlockStates = false;
            this.updateBlockStates();
        }
        if (this.simulation == null) {
            return;
        }
        this.simulation.tick(this.reactorActivity == ReactorActivity.ACTIVE);
        if (this.autoEjectWaste) {
            this.ejectWaste();
        }
        if ((battery = this.simulation.battery()) != null) {
            long totalPowerRequested = 0L;
            long startingPower = battery.stored();
            for (ReactorPowerTapTile powerPort : this.powerPorts) {
                long requested = powerPort.distributePower(startingPower, true);
                if (requested > startingPower) continue;
                totalPowerRequested += requested;
            }
            float distributionMultiplier = Math.min(1.0f, (float)startingPower / (float)totalPowerRequested);
            for (ReactorPowerTapTile powerPort : this.powerPorts) {
                long powerRequested = powerPort.distributePower(startingPower, true);
                if (powerRequested > startingPower) continue;
                powerRequested = (long)((float)powerRequested * distributionMultiplier);
                powerRequested = Math.min(battery.stored(), powerRequested);
                long powerAccepted = powerPort.distributePower(powerRequested, false);
                battery.extract(powerAccepted);
            }
        }
        if (this.coolantTank != null) {
            this.coolantPorts.forEach(ReactorCoolantPortTile::pushFluid);
        }
        this.updateFuelRenderingLevel();
        if (Phosphophyllite.tickNumber() % 2L == 0L || this.forceDirty) {
            this.forceDirty = false;
            this.dirty();
        }
    }

    private void updateFuelRenderingLevel() {
        this.updateFuelRenderingLevel(false);
    }

    private void updateFuelRenderingLevel(boolean forceFullUpdate) {
        ObjectArrayList rodLevel;
        long levelBasePixel;
        long i;
        if (this.simulation == null || this.simulation.fuelTank().capacity() == 0L) {
            return;
        }
        long rodPixels = (long)this.fuelRodsByLevel.size() * 16L;
        long fuelPixels = this.simulation.fuelTank().totalStored() * rodPixels / this.simulation.fuelTank().capacity();
        long wastePixels = this.simulation.fuelTank().waste() * rodPixels / this.simulation.fuelTank().capacity();
        if (!forceFullUpdate && fuelPixels == this.currentFuelRenderLevel && wastePixels == this.currentWasteRenderLevel) {
            return;
        }
        long lowerFuelPixel = Math.min(this.currentFuelRenderLevel, fuelPixels);
        long upperFuelPixel = Math.max(this.currentFuelRenderLevel, fuelPixels);
        long lowerWastePixel = Math.min(this.currentWasteRenderLevel, wastePixels);
        long upperWastePixel = Math.max(this.currentWasteRenderLevel, wastePixels);
        if (forceFullUpdate) {
            lowerWastePixel = 0L;
            lowerFuelPixel = 0L;
            upperFuelPixel = upperWastePixel = rodPixels;
        }
        long lowerFuelUpdateLevel = lowerFuelPixel / 16L;
        long upperFuelUpdateLevel = upperFuelPixel / 16L + (long)(upperFuelPixel % 16L > 0L ? 1 : 0);
        long lowerWasteUpdateLevel = lowerWastePixel / 16L;
        long upperWasteUpdateLevel = upperWastePixel / 16L + (long)(upperWastePixel % 16L > 0L ? 1 : 0);
        Long2ObjectLinkedOpenHashMap newStates = new Long2ObjectLinkedOpenHashMap();
        if (lowerFuelPixel != upperFuelPixel) {
            for (i = lowerFuelUpdateLevel; i < upperFuelUpdateLevel; ++i) {
                levelBasePixel = i * 16L;
                int levelFuelPixel = (int)Math.max(Math.min(fuelPixels - levelBasePixel, 16L), 0L);
                rodLevel = (ObjectArrayList)this.fuelRodsByLevel.get((int)i);
                BlockState state = ((ReactorFuelRodTile)((Object)rodLevel.get(0))).m_58900_();
                BlockState newState = (BlockState)state.m_61124_((Property)ReactorFuelRod.FUEL_HEIGHT_PROPERTY, (Comparable)Integer.valueOf(levelFuelPixel));
                int levelRodCount = rodLevel.size();
                for (int j = 0; j < levelRodCount; ++j) {
                    ReactorFuelRodTile currentFuelRod = (ReactorFuelRodTile)((Object)rodLevel.get(j));
                    if (currentFuelRod.m_58900_() == newState) continue;
                    newStates.put(currentFuelRod.m_58899_().m_121878_(), (Object)newState);
                    currentFuelRod.m_155250_(newState);
                }
            }
        }
        if (lowerWastePixel != upperWastePixel) {
            for (i = lowerWasteUpdateLevel; i < upperWasteUpdateLevel; ++i) {
                levelBasePixel = i * 16L;
                int levelWastePixel = (int)Math.max(Math.min(wastePixels - levelBasePixel, 16L), 0L);
                rodLevel = (ObjectArrayList)this.fuelRodsByLevel.get((int)i);
                ReactorFuelRodTile baseFuelRod = (ReactorFuelRodTile)((Object)((ObjectArrayList)this.fuelRodsByLevel.get((int)i)).get(0));
                BlockState state = baseFuelRod.m_58900_();
                state = (BlockState)newStates.getOrDefault(baseFuelRod.m_58899_().m_121878_(), (Object)state);
                BlockState newState = (BlockState)state.m_61124_((Property)ReactorFuelRod.WASTE_HEIGHT_PROPERTY, (Comparable)Integer.valueOf(levelWastePixel));
                int levelRodCount = rodLevel.size();
                for (int j = 0; j < levelRodCount; ++j) {
                    ReactorFuelRodTile currentFuelRod = (ReactorFuelRodTile)((Object)rodLevel.get(j));
                    if (currentFuelRod.m_58900_() == newState) continue;
                    newStates.put(currentFuelRod.m_58899_().m_121878_(), (Object)newState);
                    currentFuelRod.m_155250_(newState);
                }
            }
        }
        Util.setBlockStates((Long2ObjectMap)newStates, (Level)this.level);
        this.currentFuelRenderLevel = fuelPixels;
        this.currentWasteRenderLevel = wastePixels;
    }

    private void distributeFuel() {
        if (this.simulation == null) {
            return;
        }
        if (this.simulation.fuelTank().totalStored() > 0L && !this.fuelRods.isEmpty()) {
            long fuelToDistribute = this.simulation.fuelTank().fuel();
            long fuelLeft = this.simulation.fuelTank().fuel();
            long wasteToDistribute = this.simulation.fuelTank().waste();
            long wasteLeft = this.simulation.fuelTank().waste();
            this.simulation.fuelTank().extractFuel(fuelToDistribute, false);
            this.simulation.fuelTank().extractWaste(wasteToDistribute, false);
            fuelToDistribute /= (long)this.fuelRods.size();
            wasteToDistribute /= (long)this.fuelRods.size();
            for (int i = 0; i < this.fuelRods.size(); ++i) {
                ReactorFuelRodTile fuelRod = (ReactorFuelRodTile)((Object)this.fuelRods.get(i));
                fuelRod.fuel = fuelToDistribute;
                fuelLeft -= fuelToDistribute;
                fuelRod.waste = wasteToDistribute;
                wasteLeft -= wasteToDistribute;
            }
            if (fuelLeft > 0L || wasteLeft > 0L) {
                long fuelRodCapacity = Config.CONFIG.Reactor.PerFuelRodCapacity;
                for (int i = 0; i < this.fuelRods.size(); ++i) {
                    ReactorFuelRodTile fuelRod = (ReactorFuelRodTile)((Object)this.fuelRods.get(i));
                    long spaceLeft = fuelRodCapacity - fuelRod.waste - fuelRod.fuel;
                    if (spaceLeft <= 0L) continue;
                    long fuelToAdd = Math.min(spaceLeft, fuelLeft);
                    fuelRod.fuel += fuelToAdd;
                    long wasteToAdd = Math.min(spaceLeft -= fuelToAdd, wasteLeft);
                    fuelRod.waste += wasteToAdd;
                    if ((fuelLeft -= fuelToAdd) <= 0L && (wasteLeft -= wasteToAdd) <= 0L) break;
                }
            }
            this.dirty();
        }
    }

    private void collectFuel() {
        if (this.simulation == null) {
            return;
        }
        long totalFuel = 0L;
        long totalWaste = 0L;
        for (int i = 0; i < this.fuelRods.size(); ++i) {
            ReactorFuelRodTile fuelRod = (ReactorFuelRodTile)((Object)this.fuelRods.get(i));
            totalFuel += fuelRod.fuel;
            totalWaste += fuelRod.waste;
            fuelRod.fuel = 0L;
            fuelRod.waste = 0L;
        }
        this.simulation.fuelTank().insertFuel(totalFuel, false);
        this.simulation.fuelTank().insertWaste(totalWaste, false);
        this.dirty();
    }

    public synchronized void ejectWaste() {
        long wastePushed;
        if (this.simulation == null) {
            return;
        }
        for (ReactorAccessPortTile accessPort : this.accessPorts) {
            if (accessPort.isInlet()) continue;
            wastePushed = accessPort.pushWaste((int)this.simulation.fuelTank().waste(), false);
            this.forceDirty = this.simulation.fuelTank().extractWaste(wastePushed, false) > 0L;
        }
        if (this.simulation.fuelTank().waste() > Config.CONFIG.Reactor.FuelMBPerIngot) {
            for (ReactorAccessPortTile accessPort : this.accessPorts) {
                wastePushed = accessPort.pushWaste((int)this.simulation.fuelTank().waste(), false);
                this.forceDirty = this.simulation.fuelTank().extractWaste(wastePushed, false) > 0L;
            }
        }
    }

    public synchronized long extractWaste(long mb, boolean simulated) {
        if (this.simulation == null || this.assemblyState() != IValidatedMultiblock.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long wasteExtracted = this.simulation.fuelTank().extractWaste(mb, simulated);
        this.forceDirty = wasteExtracted > 0L && !simulated;
        return wasteExtracted;
    }

    public synchronized long extractFuel(long mb, boolean simulated) {
        if (this.simulation == null || this.assemblyState() != IValidatedMultiblock.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long fuelExtracted = this.simulation.fuelTank().extractFuel(mb, simulated);
        this.forceDirty = fuelExtracted > 0L && !simulated;
        return fuelExtracted;
    }

    public synchronized long refuel(long mb, boolean simulated) {
        if (this.simulation == null || this.assemblyState() != IValidatedMultiblock.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long fuelInserted = this.simulation.fuelTank().insertFuel(mb, simulated);
        this.forceDirty = fuelInserted > 0L && !simulated;
        return fuelInserted;
    }

    public void updateReactorState(ReactorState reactorState) {
        if (this.simulation == null) {
            return;
        }
        IReactorSimulation.IBattery battery = this.simulation.battery();
        IReactorSimulation.ICoolantTank coolantTank = this.simulation.coolantTank();
        ReactorTransitionTank coolantTankWrapper = this.coolantTank;
        if (battery == null && (coolantTank == null || coolantTankWrapper == null)) {
            return;
        }
        reactorState.reactorActivity = this.reactorActivity;
        reactorState.reactorType = this.simulation.battery() != null ? ReactorType.PASSIVE : ReactorType.ACTIVE;
        reactorState.doAutoEject = this.autoEjectWaste;
        if (battery != null) {
            reactorState.energyStored = battery.stored();
            reactorState.energyCapacity = battery.capacity();
        } else {
            reactorState.energyStored = 0L;
            reactorState.energyCapacity = 0L;
        }
        reactorState.wasteStored = this.simulation.fuelTank().waste();
        reactorState.fuelStored = this.simulation.fuelTank().fuel();
        reactorState.fuelCapacity = this.simulation.fuelTank().capacity();
        if (coolantTank != null && coolantTankWrapper != null) {
            reactorState.coolantStored = coolantTank.liquidAmount();
            reactorState.coolantCapacity = coolantTank.perSideCapacity();
            coolantTankWrapper.liquidType();
            reactorState.coolantResourceLocation = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)coolantTankWrapper.liquidType())).toString();
            reactorState.exhaustStored = coolantTank.vaporAmount();
            reactorState.exhaustCapacity = coolantTank.perSideCapacity();
            coolantTankWrapper.vaporType();
            reactorState.exhaustResourceLocation = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)coolantTankWrapper.vaporType())).toString();
        } else {
            reactorState.coolantStored = 0L;
            reactorState.coolantCapacity = 0L;
            reactorState.coolantResourceLocation = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)Fluids.f_76191_)).toString();
            reactorState.exhaustStored = 0L;
            reactorState.exhaustCapacity = 0L;
            reactorState.exhaustResourceLocation = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)Fluids.f_76191_)).toString();
        }
        reactorState.caseHeatStored = this.simulation.stackHeat();
        reactorState.fuelHeatStored = this.simulation.fuelHeat();
        reactorState.reactivityRate = this.simulation.fertility();
        reactorState.fuelUsageRate = this.simulation.fuelTank().burnedLastTick();
        reactorState.reactorOutputRate = battery != null ? (double)battery.generatedLastTick() : (double)coolantTank.transitionedLastTick();
    }

    public void runRequest(String requestName, @Nullable Object requestData) {
        switch (requestName) {
            case "setActive": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setActive(ReactorActivity.fromInt((Integer)requestData));
                break;
            }
            case "setAutoEject": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.autoEjectWaste = (Integer)requestData != 0;
                break;
            }
            case "ejectWaste": {
                this.ejectWaste();
                break;
            }
            case "dumpTanks": {
                if (this.coolantTank == null) break;
                this.coolantTank.dumpLiquid();
                this.coolantTank.dumpVapor();
            }
        }
    }

    @Nullable
    public DebugInfo getControllerDebugInfo() {
        DebugInfo info = new DebugInfo("Reactor Controller");
        info.add("State: " + this.reactorActivity);
        info.add("AutoEjectWaste: " + this.autoEjectWaste);
        if (this.simulation == null) {
            info.add("Simulation is null");
        } else {
            info.add(this.simulation.getDebugInfo());
        }
        return info;
    }

    public synchronized void setAllControlRodLevels(double newLevel) {
        this.controlRods.forEach(rod -> rod.setInsertion(newLevel));
        this.updateControlRodLevels();
    }

    public synchronized void setControlRodLevel(int index, double newLevel) {
        ((ReactorControlRodTile)((Object)this.controlRods.get(index))).setInsertion(newLevel);
        this.updateControlRodLevels();
    }

    public double controlRodLevel(int index) {
        return ((ReactorControlRodTile)((Object)this.controlRods.get(index))).getInsertion();
    }

    public void updateControlRodLevels() {
        this.controlRods.forEach(rod -> {
            IReactorSimulation.ControlRod simRod;
            BlockPos pos = rod.m_58899_();
            if (this.simulation != null && (simRod = this.simulation.controlRodAt(pos.m_123341_() - this.min().x() - 1, pos.m_123343_() - this.min().z() - 1)) != null) {
                simRod.setInsertion(rod.getInsertion());
            }
        });
    }

    public int controlRodCount() {
        return this.controlRods.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String controlRodName(int index) {
        ObjectArrayList<ReactorControlRodTile> objectArrayList = this.controlRods;
        synchronized (objectArrayList) {
            return ((ReactorControlRodTile)((Object)this.controlRods.get(index))).getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControlRodName(int index, String newName) {
        ObjectArrayList<ReactorControlRodTile> objectArrayList = this.controlRods;
        synchronized (objectArrayList) {
            ((ReactorControlRodTile)((Object)this.controlRods.get(index))).setName(newName);
        }
    }
}

