/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.ParticleDataFluid;
import com.direwolf20.laserio.util.ParticleRenderDataFluid;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketNodeParticlesFluid {
    private List<ParticleDataFluid> particleList;

    public PacketNodeParticlesFluid(List<ParticleDataFluid> particleList) {
        this.particleList = particleList;
    }

    public static void encode(PacketNodeParticlesFluid msg, FriendlyByteBuf buffer) {
        List<ParticleDataFluid> tempList = msg.particleList;
        int size = tempList.size();
        buffer.writeInt(size);
        for (ParticleDataFluid data : tempList) {
            buffer.writeFluidStack(data.fluidStack);
            if (data.fromData != null) {
                buffer.m_236858_(data.fromData.node().levelKey);
                buffer.m_130064_(data.fromData.node().blockPos);
                buffer.writeByte((int)data.fromData.direction());
                buffer.writeByte((int)data.fromData.position());
            }
            if (data.toData == null) continue;
            buffer.m_236858_(data.toData.node().levelKey);
            buffer.m_130064_(data.toData.node().blockPos);
            buffer.writeByte((int)data.toData.direction());
            buffer.writeByte((int)data.toData.position());
        }
    }

    public static PacketNodeParticlesFluid decode(FriendlyByteBuf buffer) {
        ArrayList<ParticleDataFluid> thisList = new ArrayList<ParticleDataFluid>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            FluidStack fluidStack = buffer.readFluidStack();
            DimBlockPos fromNode = new DimBlockPos((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), buffer.m_130135_());
            byte fromDirection = buffer.readByte();
            byte extractPosition = buffer.readByte();
            DimBlockPos toNode = new DimBlockPos((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), buffer.m_130135_());
            byte toDirection = buffer.readByte();
            byte insertPosition = buffer.readByte();
            ParticleDataFluid data = new ParticleDataFluid(fluidStack, fromNode, fromDirection, toNode, toDirection, extractPosition, insertPosition);
            thisList.add(data);
        }
        return new PacketNodeParticlesFluid(thisList);
    }

    public static void clientPacketHandler(PacketNodeParticlesFluid msg) {
        List<ParticleDataFluid> tempList = msg.particleList;
        for (ParticleDataFluid data : tempList) {
            if (data.fromData != null) {
                DimBlockPos fromPos = data.fromData.node();
                BlockEntity fromTE = Minecraft.m_91087_().f_91073_.m_7702_(fromPos.blockPos);
                if (fromTE instanceof LaserNodeBE) {
                    ((LaserNodeBE)fromTE).addParticleDataFluid(new ParticleRenderDataFluid(data.fluidStack, fromPos.blockPos.m_121945_(Direction.values()[data.fromData.direction()]), data.fromData.direction(), data.fromData.node().blockPos, data.fromData.position()));
                }
            }
            if (data.toData == null) continue;
            DimBlockPos toPos = data.toData.node();
            BlockEntity toTE = Minecraft.m_91087_().f_91073_.m_7702_(toPos.blockPos);
            if (!(toTE instanceof LaserNodeBE)) continue;
            ((LaserNodeBE)toTE).addParticleDataFluid(new ParticleRenderDataFluid(data.fluidStack, data.toData.node().blockPos, data.toData.direction(), toPos.blockPos.m_121945_(Direction.values()[data.toData.direction()]), data.toData.position()));
        }
    }

    public static class Handler {
        public static void handle(PacketNodeParticlesFluid msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketNodeParticlesFluid.clientPacketHandler(msg)));
            ctx.get().setPacketHandled(true);
        }
    }
}

