/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reliquary.items.ToggleableItem;
import reliquary.items.util.ICuriosItem;
import reliquary.util.WorldHelper;

public class InventoryHelper {
    private static final Set<BiFunction<Player, ICuriosItem.Type, IItemHandler>> baublesItemHandlerFactories = new HashSet<BiFunction<Player, ICuriosItem.Type, IItemHandler>>();

    private InventoryHelper() {
    }

    public static void addBaublesItemHandlerFactory(BiFunction<Player, ICuriosItem.Type, IItemHandler> factory) {
        baublesItemHandlerFactories.add(factory);
    }

    public static void spawnItemStack(Level world, BlockPos pos, ItemStack stack) {
        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
    }

    public static ItemStack getTargetItem(ItemStack self, IItemHandler inventory) {
        if (self.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack targetItem = ItemStack.f_41583_;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)self, (ItemStack)stack) || stack.m_41741_() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.m_41777_();
        }
        return targetItem;
    }

    public static int getItemQuantity(ItemStack stack, IItemHandler inventory) {
        if (stack.m_41619_()) {
            return 0;
        }
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack newStack = inventory.getStackInSlot(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)newStack)) continue;
            itemQuantity += newStack.m_41613_();
        }
        return itemQuantity;
    }

    public static ItemStack consumeItemStack(Predicate<ItemStack> itemMatches, Player player, int count) {
        return player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).map(inventory -> InventoryHelper.extractFromInventory(itemMatches, count, inventory, false)).orElse(ItemStack.f_41583_);
    }

    public static ItemStack extractFromInventory(Predicate<ItemStack> itemMatches, int count, IItemHandler inventory, boolean simulate) {
        ItemStack ret = ItemStack.f_41583_;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && ret.m_41613_() < count; ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (!itemMatches.test(slotStack) || !ret.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)ret, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.m_41613_(), count - ret.m_41613_());
            ItemStack extractedStack = inventory.extractItem(slot, toExtract, simulate);
            if (ret.m_41619_()) {
                ret = extractedStack;
                continue;
            }
            ret.m_41764_(ret.m_41613_() + extractedStack.m_41613_());
        }
        return ret;
    }

    public static boolean consumeItem(ItemStack itemStack, Player player, int minCount, int countToConsume) {
        if (player.m_7500_()) {
            return true;
        }
        if (itemStack.m_41619_() || countToConsume <= 0) {
            return false;
        }
        int itemCount = 0;
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> slotCounts = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
            ItemStack slotStack = (ItemStack)player.m_150109_().f_35974_.get(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            int n = slotStack.m_41613_();
            itemCount += n;
            slotCounts.add(new AbstractMap.SimpleEntry<Integer, Integer>(slot, n));
        }
        if (itemCount - countToConsume < minCount) {
            return false;
        }
        if (itemCount >= countToConsume) {
            slotCounts.sort((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
            int countToFill = itemCount - countToConsume;
            for (Map.Entry entry : slotCounts) {
                int slot = (Integer)entry.getKey();
                if (countToFill > 0) {
                    int stackSizeToFill = Math.min(itemStack.m_41741_(), countToFill);
                    player.m_150109_().m_8020_(slot).m_41764_(stackSizeToFill);
                    countToFill -= stackSizeToFill;
                    continue;
                }
                player.m_150109_().m_7407_(slot, player.m_150109_().m_8020_(slot).m_41613_());
            }
            return true;
        }
        return false;
    }

    public static int tryToRemoveFromInventory(ItemStack contents, IItemHandler inventory, int maxToRemove) {
        int remaining = maxToRemove;
        ItemStack stackToExtract = contents.m_41777_();
        int currentStackCount = Math.min(remaining, stackToExtract.m_41741_());
        stackToExtract.m_41764_(currentStackCount);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack extractedStack;
            if (inventory.getStackInSlot(slot).m_41619_()) continue;
            while (inventory.getStackInSlot(slot).m_41613_() > 0 && ItemHandlerHelper.canItemStacksStack((ItemStack)inventory.getStackInSlot(slot), (ItemStack)contents) && remaining > 0 && (extractedStack = inventory.extractItem(slot, Math.min(maxToRemove, inventory.getStackInSlot(slot).m_41613_()), false)).m_41613_() != 0) {
                stackToExtract = contents.m_41777_();
                currentStackCount = Math.min(remaining -= extractedStack.m_41613_(), stackToExtract.m_41741_());
                stackToExtract.m_41764_(currentStackCount);
            }
            if (remaining <= 0) break;
        }
        return maxToRemove - remaining;
    }

    public static LazyOptional<IItemHandler> getInventoryAtPos(Level world, BlockPos pos) {
        return InventoryHelper.getInventoryAtPos(world, pos, null);
    }

    public static LazyOptional<IItemHandler> getInventoryAtPos(Level world, BlockPos pos, @Nullable Direction side) {
        return WorldHelper.getBlockEntity((BlockGetter)world, pos).map(te -> InventoryHelper.getItemHandlerFrom(te, side)).orElse(LazyOptional.empty());
    }

    public static LazyOptional<IItemHandler> getItemHandlerFrom(Player player, @Nullable Direction side) {
        return player.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
    }

    public static LazyOptional<IItemHandler> getItemHandlerFrom(Player player) {
        return InventoryHelper.getItemHandlerFrom(player, Direction.UP);
    }

    public static LazyOptional<IItemHandler> getItemHandlerFrom(BlockEntity te) {
        return InventoryHelper.getItemHandlerFrom(te, null);
    }

    private static LazyOptional<IItemHandler> getItemHandlerFrom(BlockEntity te, @Nullable Direction side) {
        return te.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
    }

    public static int insertIntoInventory(ItemStack contents, IItemHandler inventory) {
        return InventoryHelper.tryToAddToInventory(contents, inventory, contents.m_41613_());
    }

    public static int tryToAddToInventory(ItemStack contents, IItemHandler inventory, int maxToAdd) {
        int inventorySize = inventory.getSlots();
        int remaining = maxToAdd;
        ItemStack stackToInsert = contents.m_41777_();
        int currentStackCount = Math.min(remaining, stackToInsert.m_41741_());
        stackToInsert.m_41764_(currentStackCount);
        for (int slot = 0; slot < inventorySize; ++slot) {
            while (inventory.insertItem(slot, stackToInsert, true).m_41613_() < stackToInsert.m_41613_()) {
                ItemStack remainingStack = inventory.insertItem(slot, stackToInsert, false);
                if (remainingStack.m_41613_() >= currentStackCount) continue;
                if ((remaining -= currentStackCount - remainingStack.m_41613_()) <= 0) {
                    return maxToAdd;
                }
                stackToInsert = contents.m_41777_();
                currentStackCount = Math.min(remaining, stackToInsert.m_41741_());
                stackToInsert.m_41764_(currentStackCount);
            }
        }
        return maxToAdd - remaining;
    }

    public static void tryRemovingLastStack(IItemHandler inventory, Level world, BlockPos pos) {
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            if (inventory.getStackInSlot(i).m_41619_()) continue;
            ItemStack stack = inventory.getStackInSlot(i).m_41777_();
            inventory.extractItem(i, stack.m_41613_(), false);
            if (world.f_46443_) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, stack);
            world.m_7967_((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(Player player, IItemHandler inventory, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand).m_41777_();
        stack.m_41764_(1);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack remainingStack = inventory.insertItem(slot, stack, false);
            if (!remainingStack.m_41619_()) continue;
            player.m_21120_(hand).m_41774_(1);
            if (player.m_21120_(hand).m_41613_() == 0) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            player.m_150109_().m_6596_();
            return true;
        }
        return false;
    }

    public static boolean playerHasItem(Player player, Item item) {
        return InventoryHelper.playerHasItem(player, item, false, ICuriosItem.Type.NONE);
    }

    public static boolean playerHasItem(Player player, Item item, boolean checkEnabled, ICuriosItem.Type baubleType) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || stack.m_41720_() != item || checkEnabled && stack.m_41720_() instanceof ToggleableItem && !((ToggleableItem)stack.m_41720_()).isEnabled(stack)) continue;
            return true;
        }
        return baubleType != ICuriosItem.Type.NONE && InventoryHelper.hasItemInBaubleInventories(player, item, checkEnabled, baubleType);
    }

    private static boolean hasItemInBaubleInventories(Player player, Item item, boolean checkEnabled, ICuriosItem.Type baubleType) {
        for (BiFunction<Player, ICuriosItem.Type, IItemHandler> factory : baublesItemHandlerFactories) {
            IItemHandler handler = factory.apply(player, baubleType);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack baubleStack = handler.getStackInSlot(i);
                if (baubleStack.m_41619_() || baubleStack.m_41720_() != item || checkEnabled && baubleStack.m_41720_() instanceof ToggleableItem && !((ToggleableItem)baubleStack.m_41720_()).isEnabled(baubleStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getCorrectItemFromEitherHand(Player player, Item item) {
        return InventoryHelper.getHandHoldingCorrectItem(player, item).map(arg_0 -> ((Player)player).m_21120_(arg_0)).orElse(ItemStack.f_41583_);
    }

    private static Optional<InteractionHand> getHandHoldingCorrectItem(Player player, Item item) {
        if (player.m_21205_().m_41720_() == item) {
            return Optional.of(InteractionHand.MAIN_HAND);
        }
        if (player.m_21206_().m_41720_() == item) {
            return Optional.of(InteractionHand.OFF_HAND);
        }
        return Optional.empty();
    }

    public static void addItemToPlayerInventory(Player player, ItemStack stack) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (!player.m_150109_().m_8020_(i).m_41619_()) continue;
            player.m_150109_().m_6836_(i, stack);
            return;
        }
        player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack));
    }

    public static NonNullList<ItemStack> getItemStacks(IItemHandler inventory) {
        NonNullList ret = NonNullList.m_122779_();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ret.add((Object)inventory.getStackInSlot(slot));
        }
        return ret;
    }

    public static void dropInventoryItems(Level world, BlockPos pos, IItemHandler inventory) {
        InventoryHelper.dropInventoryItems(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), inventory);
    }

    private static void dropInventoryItems(Level world, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            Containers.m_18992_((Level)world, (double)x, (double)y, (double)z, (ItemStack)itemstack);
        }
    }

    public static boolean hasItemHandler(Level world, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)world, pos).map(InventoryHelper::hasItemHandler).orElse(false);
    }

    private static boolean hasItemHandler(BlockEntity te) {
        return te.getCapability(ForgeCapabilities.ITEM_HANDLER, null).isPresent();
    }

    public static <T extends IItemHandler> void runOnItemHandler(ItemStack stack, Consumer<T> run, Class<T> itemHandlerClass) {
        InventoryHelper.getItemHandler(stack, itemHandlerClass).ifPresent(run);
    }

    private static <T extends IItemHandler> Optional<T> getItemHandler(ItemStack stack, Class<T> itemHandlerClass) {
        return stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).filter(itemHandlerClass::isInstance).map(itemHandlerClass::cast);
    }

    public static <R, T extends IItemHandler> Optional<R> getFromHandler(ItemStack stack, Function<T, R> get, Class<T> itemHandlerClass) {
        return InventoryHelper.getItemHandler(stack, itemHandlerClass).map(get);
    }
}

