/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.init.ModItems;
import reliquary.init.ModPotions;
import reliquary.items.RendingGaleItem;
import reliquary.reference.Settings;

public class PedestalRendingGaleWrapper
implements IPedestalActionItemWrapper {
    private static final int SECONDS_BETWEEN_BUFF_CHECKS = 2;
    private static final int TICKS_BETWEEN_PUSH_PULL_CHECKS = 1;
    private int buffCheckCoolDown;
    private int pushPullCheckCoolDown;

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        BlockPos pos = pedestal.getBlockPosition();
        RendingGaleItem rendingGale = (RendingGaleItem)stack.m_41720_();
        if (rendingGale.getMode(stack) == RendingGaleItem.Mode.FLIGHT) {
            if (this.buffCheckCoolDown <= 0) {
                this.buffPlayersWithFlight(stack, level, pos);
                this.buffCheckCoolDown = 40;
            } else {
                --this.buffCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack) == RendingGaleItem.Mode.PUSH) {
            if (this.pushPullCheckCoolDown <= 0) {
                this.pushEntities(stack, level, pos, rendingGale, false);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack) == RendingGaleItem.Mode.PULL) {
            if (this.pushPullCheckCoolDown <= 0) {
                this.pushEntities(stack, level, pos, rendingGale, true);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        }
    }

    private void pushEntities(ItemStack stack, Level world, BlockPos pos, RendingGaleItem rendingGale, boolean b) {
        rendingGale.doRadialPush(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), null, b);
        ((RendingGaleItem)ModItems.RENDING_GALE.get()).setFeatherCount(stack, ((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCount(stack) - (int)(0.05f * (float)((Integer)Settings.COMMON.items.rendingGale.pedestalCostPerSecond.get()).intValue()), true);
    }

    private void buffPlayersWithFlight(ItemStack stack, Level world, BlockPos pos) {
        List players;
        int flightRange = (Integer)Settings.COMMON.items.rendingGale.pedestalFlightRange.get();
        if (((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCount(stack) >= RendingGaleItem.getChargeCost() * 2 && !(players = world.m_45976_(Player.class, new AABB((double)pos.m_123341_() - (double)flightRange, (double)pos.m_123342_() - (double)flightRange, (double)pos.m_123343_() - (double)flightRange, (double)pos.m_123341_() + (double)flightRange, (double)pos.m_123342_() + (double)flightRange, (double)pos.m_123343_() + (double)flightRange))).isEmpty()) {
            for (Player player : players) {
                player.m_7292_(new MobEffectInstance((MobEffect)ModPotions.FLIGHT_POTION.get(), 400));
            }
            ((RendingGaleItem)ModItems.RENDING_GALE.get()).setFeatherCount(stack, ((RendingGaleItem)ModItems.RENDING_GALE.get()).getFeatherCount(stack) - 2 * (Integer)Settings.COMMON.items.rendingGale.pedestalCostPerSecond.get(), true);
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }
}

