/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import reliquary.items.util.FilteredItemStack;

public class FilteredItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private boolean dynamicSlotNumber = false;
    private final List<FilteredItemStack> filteredItemStacks;
    private static final String NOT_IN_RANGE_ERROR = "%s %d not in valid range - (0, %d)";

    FilteredItemStackHandler(List<FilteredItemStack> filteredItemStacks) {
        this.filteredItemStacks = filteredItemStacks;
    }

    public void setTotalCount(int stackSlot, int count) {
        if (this.dynamicSlotNumber && count == 0 && this.filteredItemStacks.get(stackSlot).canRemove()) {
            this.filteredItemStacks.remove(stackSlot);
        } else {
            this.filteredItemStacks.get(stackSlot).setCount(count);
        }
    }

    public int getTotalAmount(int stackSlot) {
        this.validateStackSlot(stackSlot);
        return this.filteredItemStacks.get(stackSlot).getCount();
    }

    private void validateStackSlot(int stackSlot) {
        if (stackSlot < 0 || stackSlot >= this.filteredItemStacks.size()) {
            throw new IllegalArgumentException(String.format(NOT_IN_RANGE_ERROR, "Big Stack Slot", stackSlot, this.filteredItemStacks.size() - 1));
        }
    }

    public void markDirty() {
        this.filteredItemStacks.removeIf(stack -> stack.isEmpty() && stack.canRemove());
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (this.filteredItemStacks.size() > slot ? !this.isValidForStackSlot(stack, slot) : this.alreadyExistsInAnotherSlot(stack, slot)) {
            return;
        }
        if (this.isValidForDynamicStack(stack)) {
            this.addDynamicStack(stack, slot);
        }
        this.updateStack(slot, stack);
    }

    protected boolean isValidForStackSlot(ItemStack stack, int stackSlot) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.filteredItemStacks.get(stackSlot).getFilterStack(), (ItemStack)stack);
    }

    private void updateStack(int slot, ItemStack stack) {
        FilteredItemStack filteredStack = this.filteredItemStacks.get(slot);
        filteredStack.setCount(filteredStack.unitsToWorth(stack.m_41613_()));
        if (filteredStack.isEmpty() && filteredStack.canRemove()) {
            this.filteredItemStacks.remove(slot);
        }
    }

    private void addDynamicStack(ItemStack stack, int stackSlot) {
        if (this.dynamicSlotNumber && !stack.m_41619_() && stackSlot == this.filteredItemStacks.size()) {
            ItemStack filter = stack.m_41777_();
            filter.m_41764_(1);
            this.filteredItemStacks.add(new FilteredItemStack(filter, this.getDynamicStackLimit(), true));
        }
    }

    protected int getDynamicStackLimit() {
        return Integer.MAX_VALUE;
    }

    private boolean alreadyExistsInAnotherSlot(ItemStack stack, int stackSlot) {
        for (int i = 0; i < this.filteredItemStacks.size(); ++i) {
            if (i == stackSlot || !this.isValidForStackSlot(stack, i)) continue;
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.filteredItemStacks.size() + (this.dynamicSlotNumber ? 1 : 0);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int getStackSlots() {
        return this.filteredItemStacks.size();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        return this.isValidForStackSlot(stack, slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        if (slot < this.filteredItemStacks.size()) {
            return this.filteredItemStacks.get(slot).getStack();
        }
        return ItemStack.f_41583_;
    }

    void setFilteredStack(int stackSlot, FilteredItemStack filteredItemStack) {
        if (stackSlot < 0 || stackSlot > this.filteredItemStacks.size()) {
            throw new IllegalArgumentException(String.format(NOT_IN_RANGE_ERROR, "Filtered Stack Slot", stackSlot, this.filteredItemStacks.size()));
        }
        if (stackSlot == this.filteredItemStacks.size()) {
            this.filteredItemStacks.add(filteredItemStack);
            return;
        }
        this.filteredItemStacks.set(stackSlot, filteredItemStack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || stack.m_41613_() == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        if (slot == this.filteredItemStacks.size()) {
            if (this.alreadyExistsInAnotherSlot(stack, slot) || !this.isValidForDynamicStack(stack)) return stack;
            if (simulate) return ItemStack.f_41583_;
            this.addDynamicStack(stack, slot);
        }
        if (this.isValidForStackSlot(stack, slot)) return this.filteredItemStacks.get(slot).insertItem(stack, simulate);
        return stack;
    }

    protected boolean isValidForDynamicStack(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        if (slot >= this.getSlots()) {
            return ItemStack.f_41583_;
        }
        ItemStack currentStack = this.filteredItemStacks.get(slot).getStack();
        if (currentStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int numberRemoved = Math.min(currentStack.m_41613_(), amount);
        ItemStack ret = ItemHandlerHelper.copyStackWithSize((ItemStack)currentStack, (int)numberRemoved);
        if (!simulate) {
            ItemStack updatedStack = numberRemoved == currentStack.m_41613_() ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)currentStack, (int)(currentStack.m_41613_() - numberRemoved));
            this.updateStack(slot, updatedStack);
        }
        return ret;
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (FilteredItemStack filteredStack : this.filteredItemStacks) {
            nbtTagList.add((Object)filteredStack.serializeNBT());
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            if (i < this.filteredItemStacks.size()) {
                this.filteredItemStacks.get(i).deserializeNBT(itemTags);
                continue;
            }
            FilteredItemStack filteredStack = new FilteredItemStack(this.getDynamicStackLimit(), true);
            filteredStack.deserializeNBT(itemTags);
            this.filteredItemStacks.add(filteredStack);
        }
    }

    void setDynamicSlotNumber() {
        this.dynamicSlotNumber = true;
    }

    private void validateSlotIndex(int slot) {
        int slots = this.getSlots();
        if (slot < 0 || slot >= slots) {
            throw new IllegalArgumentException(String.format(NOT_IN_RANGE_ERROR, "Slot", slot, this.filteredItemStacks.size() - 1));
        }
    }
}

