/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerDeathHandler;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.items.AngelicFeatherItem;
import reliquary.network.PacketHandler;
import reliquary.network.SpawnPhoenixDownParticlesPacket;
import reliquary.reference.Settings;
import reliquary.util.EntityHelper;
import reliquary.util.InventoryHelper;

public class PhoenixDownItem
extends AngelicFeatherItem {
    public PhoenixDownItem() {
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(Player player, LivingAttackEvent event) {
                return event.getSource() == player.m_269291_().m_268989_() && player.m_21223_() > (float)Math.round(event.getAmount()) && player.m_36324_().m_38702_() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.PHOENIX_DOWN.get());
            }

            @Override
            public boolean apply(Player player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Settings.COMMON.items.phoenixDown.hungerCostPercent.get()).intValue() / 100.0f);
                player.m_36399_(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(){

            @Override
            public boolean canApply(Player player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, (Item)ModItems.PHOENIX_DOWN.get());
            }

            @Override
            public boolean apply(Player player, LivingDeathEvent event) {
                PhoenixDownItem.revertPhoenixDownToAngelicFeather(player);
                float amountHealed = player.m_21233_() * (float)((Integer)Settings.COMMON.items.phoenixDown.healPercentageOfMaxLife.get()).intValue() / 100.0f;
                player.m_21153_(amountHealed);
                if (Boolean.TRUE.equals(Settings.COMMON.items.phoenixDown.removeNegativeStatus.get())) {
                    EntityHelper.removeNegativeStatusEffects((LivingEntity)player);
                }
                if (event.getSource() == player.m_269291_().m_269233_() && Boolean.TRUE.equals(Settings.COMMON.items.phoenixDown.giveTemporaryFireResistanceIfFireDamageKilledYou.get())) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
                }
                if (event.getSource() == player.m_269291_().m_269063_() && Boolean.TRUE.equals(Settings.COMMON.items.phoenixDown.giveTemporaryWaterBreathingIfDrowningKilledYou.get())) {
                    player.m_20301_(10);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200, 0));
                }
                if (Boolean.TRUE.equals(Settings.COMMON.items.phoenixDown.giveTemporaryDamageResistance.get())) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
                }
                if (Boolean.TRUE.equals(Settings.COMMON.items.phoenixDown.giveTemporaryRegeneration.get())) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
                }
                PhoenixDownItem.spawnPhoenixResurrectionParticles(player);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    private static void revertPhoenixDownToAngelicFeather(Player player) {
        for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
            if (((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41619_() || ((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41720_() != ModItems.PHOENIX_DOWN.get()) continue;
            player.m_150109_().f_35974_.set(slot, (Object)new ItemStack((ItemLike)ModItems.ANGELIC_FEATHER.get()));
            return;
        }
    }

    private static void spawnPhoenixResurrectionParticles(Player player) {
        PacketHandler.sendToClient((ServerPlayer)player, SpawnPhoenixDownParticlesPacket.INSTANCE);
    }
}

