/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModItems;
import reliquary.init.ModSounds;
import reliquary.items.BulletItem;
import reliquary.items.ItemBase;
import reliquary.items.MagazineItem;
import reliquary.reference.Settings;
import reliquary.util.NBTHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.XRPotionHelper;

public class HandgunItem
extends ItemBase {
    private static final int HANDGUN_RELOAD_SKILL_OFFSET = 10;
    private static final int HANDGUN_COOLDOWN_SKILL_OFFSET = 5;
    private static final String MAGAZINE_TYPE_TAG = "magazineType";
    private final Map<String, IShotEntityFactory> magazineShotFactories = new HashMap<String, IShotEntityFactory>();
    private final Map<String, Supplier<BulletItem>> magazineBulletItems = new HashMap<String, Supplier<BulletItem>>();

    public void registerMagazine(String magazineRegistryName, IShotEntityFactory factory, Supplier<BulletItem> getBulletItem) {
        this.magazineShotFactories.put(magazineRegistryName, factory);
        this.magazineBulletItems.put(magazineRegistryName, getBulletItem);
    }

    public HandgunItem() {
        super(new Item.Properties().m_41487_(1), () -> ((ForgeConfigSpec.BooleanValue)Settings.COMMON.disable.disableHandgun).get());
    }

    private short getBulletCount(ItemStack handgun) {
        return NBTHelper.getShort("bulletCount", handgun);
    }

    public ItemStack getBulletStack(ItemStack handgun) {
        String magazineType = this.getMagazineType(handgun);
        if (!this.magazineBulletItems.containsKey(magazineType)) {
            return new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get(), 1);
        }
        BulletItem bulletItem = this.magazineBulletItems.get(magazineType).get();
        ItemStack bulletStack = new ItemStack((ItemLike)bulletItem, (int)this.getBulletCount(handgun));
        XRPotionHelper.addPotionEffectsToStack(bulletStack, this.getPotionEffects(handgun));
        return bulletStack;
    }

    private void setBulletCount(ItemStack handgun, short bulletCount) {
        NBTHelper.putShort("bulletCount", handgun, bulletCount);
    }

    private String getMagazineType(ItemStack handgun) {
        return NBTHelper.getString(MAGAZINE_TYPE_TAG, handgun);
    }

    private void setMagazineType(ItemStack handgun, ItemStack magazine) {
        NBTHelper.putString(MAGAZINE_TYPE_TAG, handgun, RegistryHelper.getItemRegistryName(magazine.m_41720_()));
    }

    private boolean hasAmmo(ItemStack handgun) {
        return this.getBulletCount(handgun) > 0;
    }

    public long getCooldown(ItemStack handgun) {
        return NBTHelper.getLong("coolDownTime", handgun);
    }

    private void setCooldown(ItemStack handgun, long coolDownTime) {
        NBTHelper.putLong("coolDownTime", handgun, coolDownTime);
    }

    private List<MobEffectInstance> getPotionEffects(ItemStack handgun) {
        return XRPotionHelper.getPotionEffectsFromStack(handgun);
    }

    private void setPotionEffects(ItemStack handgun, List<MobEffectInstance> potionEffects) {
        XRPotionHelper.cleanPotionEffects(handgun);
        XRPotionHelper.addPotionEffectsToStack(handgun, potionEffects);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack handgun, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        ItemStack bullets = this.getBulletStack(handgun);
        if (this.hasAmmo(handgun)) {
            tooltipBuilder.data(this, ".tooltip2", this.getBulletCount(handgun), this.getMagazineName(handgun)).potionEffects(handgun);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack handgun) {
        return this.hasAmmo(handgun);
    }

    private String getMagazineName(ItemStack handgun) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.getMagazineType(handgun)));
        return item != null ? item.m_7626_(new ItemStack((ItemLike)item)).getString() : "";
    }

    public UseAnim m_6164_(ItemStack handgun) {
        if (this.getBulletCount(handgun) > 0) {
            return UseAnim.NONE;
        }
        return UseAnim.BLOCK;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_() || this.getBulletCount(oldStack) < this.getBulletCount(newStack);
    }

    private boolean isCooldownOver(Level world, ItemStack handgun) {
        return this.getCooldown(handgun) < world.m_46467_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack handgun = player.m_21120_(hand);
        if (this.getBulletCount(handgun) > 0 && !this.isCooldownOver(world, handgun) && this.otherHandgunCooledDownMore(player, hand, handgun)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)handgun);
        }
        if (this.getBulletCount(handgun) > 0 || this.hasFilledMagazine(player)) {
            player.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)handgun);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)handgun);
    }

    private boolean otherHandgunCooledDownMore(Player player, InteractionHand currentHand, ItemStack currentHandgun) {
        if (currentHand == InteractionHand.MAIN_HAND) {
            ItemStack offHandItem = player.m_21206_();
            return offHandItem.m_41720_() == this && this.getCooldown(offHandItem) < this.getCooldown(currentHandgun);
        }
        ItemStack mainHandItem = player.m_21205_();
        return mainHandItem.m_41720_() == this && this.getCooldown(mainHandItem) < this.getCooldown(currentHandgun);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack handgun, int remainingUseDuration) {
        if (livingEntity.m_9236_().f_46443_ || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int maxUseOffset = this.getItemUseDuration() - this.getPlayerReloadDelay(player);
        int actualCount = remainingUseDuration - maxUseOffset;
        if (--actualCount == 0 || this.isCooldownOver(livingEntity.m_9236_(), handgun) && this.getBulletCount(handgun) > 0 || !this.hasFilledMagazine(player)) {
            player.m_21253_();
        }
    }

    public int m_8105_(ItemStack handgun) {
        return this.getItemUseDuration();
    }

    public void m_5551_(ItemStack handgun, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        if (this.hasAmmo(handgun)) {
            if (this.isCooldownOver(player.m_9236_(), handgun)) {
                this.setFiringCooldown(handgun, worldIn, player);
                this.fireBullet(handgun, worldIn, player, handgun == player.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            }
            return;
        }
        this.setCooldown(handgun, player.m_9236_().m_46467_() + 12L);
        this.getMagazineSlot(player).ifPresent(slot -> {
            ItemStack magazine = (ItemStack)player.m_150109_().f_35974_.get(slot.intValue());
            this.setMagazineType(handgun, magazine);
            this.setPotionEffects(handgun, XRPotionHelper.getPotionEffectsFromStack(magazine));
            magazine.m_41774_(1);
            if (magazine.m_41619_()) {
                player.m_150109_().f_35974_.set(slot.intValue(), (Object)ItemStack.f_41583_);
            }
            player.m_6674_(player.m_7655_());
            this.spawnEmptyMagazine(player);
            this.setBulletCount(handgun, (short)8);
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.HANDGUN_LOAD.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
            this.setFiringCooldown(handgun, worldIn, player);
        });
        if (this.getBulletCount(handgun) == 0) {
            this.setPotionEffects(handgun, Collections.emptyList());
        }
    }

    private void setSecondHandgunFiringCooldown(Player player, ItemStack currentHandgun) {
        if (player.m_21205_() == currentHandgun) {
            this.setHalfFiringCooldown(player, player.m_21206_());
        } else if (player.m_21206_() == currentHandgun) {
            this.setHalfFiringCooldown(player, player.m_21205_());
        }
    }

    private void setHalfFiringCooldown(Player player, ItemStack potentialHandgun) {
        if (potentialHandgun.m_41720_() == this && this.isCooldownOver(player.m_9236_(), potentialHandgun)) {
            this.setCooldown(potentialHandgun, player.m_9236_().m_46467_() + (long)(this.getPlayerFiringCooldown(player) / 2));
        }
    }

    private void setFiringCooldown(ItemStack handgun, Level worldIn, Player player) {
        this.setCooldown(handgun, worldIn.m_46467_() + (long)this.getPlayerFiringCooldown(player));
        this.setSecondHandgunFiringCooldown(player, handgun);
    }

    private int getPlayerFiringCooldown(Player player) {
        return (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get() + 5 - Math.min(player.f_36078_, (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get());
    }

    private int getItemUseDuration() {
        return 10 + (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get();
    }

    private void fireBullet(ItemStack handgun, Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            String magazineType = this.getMagazineType(handgun);
            if (!this.magazineShotFactories.containsKey(magazineType)) {
                return;
            }
            this.spawnShotEntity(handgun, world, player, hand, magazineType);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.HANDGUN_SHOT.get(), SoundSource.PLAYERS, 0.5f, 1.2f);
            this.setBulletCount(handgun, (short)(this.getBulletCount(handgun) - 1));
            if (this.getBulletCount(handgun) == 0) {
                this.setPotionEffects(handgun, Collections.emptyList());
            }
            this.spawnCasing(player);
        }
    }

    private void spawnShotEntity(ItemStack handgun, Level world, Player player, InteractionHand hand, String magazineType) {
        if (!this.magazineShotFactories.containsKey(magazineType)) {
            return;
        }
        ShotEntityBase shot = this.magazineShotFactories.get(magazineType).createShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun));
        double motionX = -Mth.m_14031_((float)(player.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(player.m_146909_() / 180.0f * (float)Math.PI));
        double motionZ = Mth.m_14089_((float)(player.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(player.m_146909_() / 180.0f * (float)Math.PI));
        double motionY = -Mth.m_14031_((float)(player.m_146909_() / 180.0f * (float)Math.PI));
        shot.m_6686_(motionX, motionY, motionZ, 1.2f, 1.0f);
        world.m_7967_((Entity)shot);
    }

    private void spawnEmptyMagazine(Player player) {
        ItemStack emptyMagazine = new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get());
        if (!player.m_150109_().m_36054_(emptyMagazine)) {
            player.m_5552_(emptyMagazine, 0.1f);
        }
    }

    private void spawnCasing(Player player) {
        ItemStack emptyCasing = new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get());
        if (!player.m_150109_().m_36054_(emptyCasing)) {
            player.m_5552_(emptyCasing, 0.1f);
        }
    }

    private boolean hasFilledMagazine(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack == null || !(stack.m_41720_() instanceof MagazineItem) || stack.m_41720_() == ModItems.EMPTY_MAGAZINE.get()) continue;
            return true;
        }
        return false;
    }

    private Optional<Integer> getMagazineSlot(Player player) {
        for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
            Item item = ((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41720_();
            if (!(item instanceof MagazineItem) || item == ModItems.EMPTY_MAGAZINE.get()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    private int getPlayerReloadDelay(Player player) {
        return (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get() + 10 - Math.min(player.f_36078_, (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get());
    }

    public static interface IShotEntityFactory {
        public ShotEntityBase createShot(Level var1, Player var2, InteractionHand var3);
    }
}

