/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting.alkahestry;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import reliquary.crafting.conditions.AlkahestryEnabledCondition;
import reliquary.init.ModItems;

public class ChargingRecipeBuilder {
    private final Ingredient ingredient;
    private final int charge;

    private ChargingRecipeBuilder(ItemLike ingredient, int charge) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        this.charge = charge;
    }

    public static ChargingRecipeBuilder chargingRecipe(ItemLike result, int charge) {
        return new ChargingRecipeBuilder(result, charge);
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation fullId = new ResourceLocation("reliquary", "alkahestry/charging/" + id.m_135815_());
        ConditionalRecipe.builder().addCondition((ICondition)new AlkahestryEnabledCondition()).addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(fullId, this.ingredient, this.charge))).build(consumer, fullId);
    }

    public static class Result
    implements FinishedRecipe {
        private final Ingredient ingredient;
        private final int charge;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient ingredient, int charge) {
            this.id = id;
            this.ingredient = ingredient;
            this.charge = charge;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("charge", (Number)this.charge);
            json.add("ingredient", this.ingredient.m_43942_());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModItems.ALKAHESTRY_CHARGING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

