/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import reliquary.compat.jei.ItemDescriptionBuilder;
import reliquary.compat.jei.MobCharmRecipeMaker;
import reliquary.compat.jei.SortedNbtSubtypeInterpreter;
import reliquary.compat.jei.SpawnEggRecipeMaker;
import reliquary.compat.jei.alkahestry.AlkahestryChargingRecipeCategory;
import reliquary.compat.jei.alkahestry.AlkahestryCraftingRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeMaker;
import reliquary.compat.jei.infernaltear.InfernalTearRecipeCategory;
import reliquary.compat.jei.infernaltear.InfernalTearRecipeMaker;
import reliquary.compat.jei.lingering.ArrowShotRecipeMaker;
import reliquary.compat.jei.magazines.MagazineRecipeMaker;
import reliquary.compat.jei.mortar.MortarRecipeCategory;
import reliquary.compat.jei.mortar.MortarRecipeMaker;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.items.MobCharmFragmentItem;
import reliquary.reference.Settings;

@JeiPlugin
public class ReliquaryPlugin
implements IModPlugin {
    private static final String EFFECTS_TAG = "effects";

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.MOB_CHARM_FRAGMENT.get(), "entity");
        this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.MOB_CHARM.get(), "entity");
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.POTION_ESSENCE.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.SPLASH_POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.LINGERING_POTION.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.TIPPED_ARROW.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.NEUTRAL_BULLET.get(), EFFECTS_TAG);
            this.registerNbtSubtypeInterpreter(registration, (Item)ModItems.NEUTRAL_MAGAZINE.get(), EFFECTS_TAG);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryCraftingRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryChargingRecipeCategory(guiHelper)});
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MortarRecipeCategory(guiHelper)});
            registration.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(guiHelper)});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new InfernalTearRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50091_), new RecipeType[]{AlkahestryChargingRecipeCategory.TYPE, AlkahestryCraftingRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.APOTHECARY_MORTAR.get()), new RecipeType[]{MortarRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get()), new RecipeType[]{CauldronRecipeCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get()), new RecipeType[]{InfernalTearRecipeCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
            registration.addRecipes(AlkahestryCraftingRecipeCategory.TYPE, AlkahestryRecipeRegistry.getCraftingRecipes());
            registration.addRecipes(AlkahestryChargingRecipeCategory.TYPE, AlkahestryRecipeRegistry.getChargingRecipes());
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registration.addRecipes(MortarRecipeCategory.TYPE, MortarRecipeMaker.getRecipes());
            registration.addRecipes(CauldronRecipeCategory.TYPE, CauldronRecipeMaker.getRecipes());
            registration.addRecipes(RecipeTypes.CRAFTING, ArrowShotRecipeMaker.getRecipes(new ItemStack((ItemLike)ModItems.TIPPED_ARROW.get()), new ItemStack((ItemLike)Items.f_42412_), 0.125f, "arrow"));
            registration.addRecipes(RecipeTypes.CRAFTING, ArrowShotRecipeMaker.getRecipes(new ItemStack((ItemLike)ModItems.NEUTRAL_BULLET.get()), "bullet"));
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableHandgun.get())) {
            registration.addRecipes(RecipeTypes.CRAFTING, MagazineRecipeMaker.getRecipes());
        }
        registration.addRecipes(RecipeTypes.CRAFTING, MobCharmRecipeMaker.getRecipes());
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disableSpawnEggRecipes.get())) {
            registration.addRecipes(RecipeTypes.CRAFTING, SpawnEggRecipeMaker.getRecipes());
        }
        registration.addRecipes(InfernalTearRecipeCategory.TYPE, InfernalTearRecipeMaker.getRecipes());
        this.registerMobCharmBeltRecipe(registration);
        ItemDescriptionBuilder.addIngredientInfo(registration);
    }

    private void registerMobCharmBeltRecipe(IRecipeRegistration registration) {
        NonNullList fragments = NonNullList.m_122779_();
        ((MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get()).addCreativeTabItems(arg_0 -> fragments.add(arg_0));
        ItemStack[] fragmentStacks = (ItemStack[])fragments.toArray((Object[])new ItemStack[0]);
        registration.addRecipes(RecipeTypes.CRAFTING, Collections.singletonList(new ShapedRecipe(new ResourceLocation("reliquary", "items/mob_charm_belt"), "", CraftingBookCategory.MISC, 3, 3, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{() -> Items.f_42454_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{() -> Items.f_42454_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{() -> Items.f_42454_}), Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.m_43927_((ItemStack[])fragmentStacks), Ingredient.m_43927_((ItemStack[])fragmentStacks)}), new ItemStack((ItemLike)ModItems.MOB_CHARM_BELT.get()))));
    }

    private void registerNbtSubtypeInterpreter(ISubtypeRegistration registration, Item item, String ... keys) {
        registration.registerSubtypeInterpreter(item, (IIngredientSubtypeInterpreter)new SortedNbtSubtypeInterpreter(keys));
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("reliquary", "default");
    }
}

