/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.impl.registry;

import com.simibubi.create.api.registry.SimpleRegistry;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TagProviderImpl<K, V>
implements SimpleRegistry.Provider<K, V> {
    private final TagKey<K> tag;
    private final Function<K, Holder<K>> holderGetter;
    private final V value;

    public TagProviderImpl(TagKey<K> tag, Function<K, Holder<K>> holderGetter, V value) {
        this.tag = tag;
        this.holderGetter = holderGetter;
        this.value = value;
    }

    @Override
    @Nullable
    public V get(K object) {
        Holder<K> holder = this.holderGetter.apply(object);
        return holder.m_203656_(this.tag) ? (V)this.value : null;
    }

    @Override
    public void onRegister(Runnable invalidate) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.shouldUpdateStaticData()) {
                invalidate.run();
            }
        });
    }

    public static Holder<BlockEntityType<?>> getBeHolder(BlockEntityType<?> type) {
        return (Holder)ForgeRegistries.BLOCK_ENTITY_TYPES.getHolder(type).orElseThrow(() -> new IllegalStateException("Unregistered BlockEntityType: " + String.valueOf(type)));
    }
}

