/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ArmBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity {
    List<ArmInteractionPoint> inputs = new ArrayList<ArmInteractionPoint>();
    List<ArmInteractionPoint> outputs = new ArrayList<ArmInteractionPoint>();
    ListTag interactionPointTag = null;
    float chasedPointProgress;
    int chasedPointIndex;
    ItemStack heldItem = ItemStack.f_41583_;
    Phase phase = Phase.SEARCH_INPUTS;
    boolean goggles;
    ArmAngleTarget previousTarget = ArmAngleTarget.NO_TARGET;
    LerpedFloat lowerArmAngle;
    LerpedFloat upperArmAngle;
    LerpedFloat baseAngle = LerpedFloat.angular();
    LerpedFloat headAngle;
    LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    int tooltipWarmup;
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;

    public ArmBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.baseAngle.startWithValue((double)this.previousTarget.baseAngle);
        this.lowerArmAngle = LerpedFloat.angular();
        this.lowerArmAngle.startWithValue((double)this.previousTarget.lowerArmAngle);
        this.upperArmAngle = LerpedFloat.angular();
        this.upperArmAngle.startWithValue((double)this.previousTarget.upperArmAngle);
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)this.previousTarget.headAngle);
        this.clawAngle = LerpedFloat.angular();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
        this.tooltipWarmup = 15;
        this.goggles = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour<SelectionMode>(SelectionMode.class, (Component)CreateLang.translateDirect("logistics.when_multiple_outputs_available", new Object[0]), this, new SelectionModeValueBox());
        behaviours.add(this.selectionMode);
        this.registerAwardables(behaviours, AllAdvancements.ARM_BLAZE_BURNER, AllAdvancements.ARM_MANY_TARGETS, AllAdvancements.MECHANICAL_ARM, AllAdvancements.MUSICAL_ARM);
    }

    @Override
    public void tick() {
        super.tick();
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.tooltipWarmup > 0) {
            --this.tooltipWarmup;
        }
        if (this.chasedPointProgress < 1.0f) {
            ArmInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive();
            }
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.phase == Phase.MOVE_TO_INPUT) {
            this.collectItem();
        } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
            this.depositItem();
        } else if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.searchForItem();
        }
        if (targetReached) {
            this.lazyTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.chasedPointProgress < 0.5f) {
            return;
        }
        if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.checkForMusic();
        }
        if (this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    private void checkForMusic() {
        boolean hasMusic = this.checkForMusicAmong(this.inputs) || this.checkForMusicAmong(this.outputs);
        if (hasMusic != (this.phase == Phase.DANCING)) {
            this.phase = hasMusic ? Phase.DANCING : Phase.SEARCH_INPUTS;
            this.m_6596_();
            this.sendData();
        }
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(3.0);
    }

    private boolean checkForMusicAmong(List<ArmInteractionPoint> list) {
        for (ArmInteractionPoint armInteractionPoint : list) {
            BlockState state;
            if (!(armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint) || !(state = this.f_58857_.m_8055_(armInteractionPoint.getPos())).m_61145_((Property)JukeboxBlock.f_54254_).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        this.chasedPointProgress += Math.min(256.0f, Math.abs(this.getSpeed())) / 1024.0f;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (!this.f_58857_.f_46443_) {
            return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
        }
        ArmInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
        ArmAngleTarget previousTarget = this.previousTarget;
        ArmAngleTarget target = targetedInteractionPoint == null ? ArmAngleTarget.NO_TARGET : targetedInteractionPoint.getTargetAngles(this.f_58858_, this.isOnCeiling());
        this.baseAngle.setValue((double)AngleHelper.angleLerp((double)this.chasedPointProgress, (double)this.previousBaseAngle, (double)(target == ArmAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle)));
        if (this.chasedPointProgress < 0.5f) {
            target = ArmAngleTarget.NO_TARGET;
        } else {
            previousTarget = ArmAngleTarget.NO_TARGET;
        }
        float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
        this.lowerArmAngle.setValue((double)Mth.m_14179_((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle));
        this.upperArmAngle.setValue((double)Mth.m_14179_((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle));
        this.headAngle.setValue((double)AngleHelper.angleLerp((double)progress, (double)(previousTarget.headAngle % 360.0f), (double)(target.headAngle % 360.0f)));
        return false;
    }

    protected boolean isOnCeiling() {
        BlockState state = this.m_58900_();
        return this.m_58898_() && state.m_61145_((Property)ArmBlock.CEILING).orElse(false) != false;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (!this.heldItem.m_41619_()) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)this.heldItem);
        }
    }

    @Nullable
    private ArmInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size()) {
            return this.outputs.get(this.chasedPointIndex);
        }
        return null;
    }

    protected void searchForItem() {
        int scanRange;
        if (this.redstoneLocked) {
            return;
        }
        boolean foundInput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
        if (scanRange > this.inputs.size()) {
            scanRange = this.inputs.size();
        }
        block0: for (int i = startIndex; i < scanRange; ++i) {
            ArmInteractionPoint armInteractionPoint = this.inputs.get(i);
            if (!armInteractionPoint.isValid()) continue;
            for (int j = 0; j < armInteractionPoint.getSlotCount(); ++j) {
                if (this.getDistributableAmount(armInteractionPoint, j) == 0) continue;
                this.selectIndex(true, i);
                foundInput = true;
                break block0;
            }
        }
        if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastInputIndex = -1;
        }
        if (this.lastInputIndex == this.inputs.size() - 1) {
            this.lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        int scanRange;
        ItemStack held = this.heldItem.m_41777_();
        boolean foundOutput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastOutputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastOutputIndex + 2 : this.outputs.size();
        if (scanRange > this.outputs.size()) {
            scanRange = this.outputs.size();
        }
        for (int i = startIndex; i < scanRange; ++i) {
            ItemStack remainder;
            ArmInteractionPoint armInteractionPoint = this.outputs.get(i);
            if (!armInteractionPoint.isValid() || (remainder = armInteractionPoint.insert(held, true)).equals(this.heldItem, false)) continue;
            this.selectIndex(false, i);
            foundOutput = true;
            break;
        }
        if (!foundOutput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastOutputIndex = -1;
        }
        if (this.lastOutputIndex == this.outputs.size() - 1) {
            this.lastOutputIndex = -1;
        }
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.m_6596_();
    }

    protected int getDistributableAmount(ArmInteractionPoint armInteractionPoint, int i) {
        ItemStack remainder;
        ItemStack stack = armInteractionPoint.extract(i, true);
        if (ItemStack.m_41656_((ItemStack)stack, (ItemStack)(remainder = this.simulateInsertion(stack)))) {
            return stack.m_41613_() - remainder.m_41613_();
        }
        return stack.m_41613_();
    }

    private ItemStack simulateInsertion(ItemStack stack) {
        for (ArmInteractionPoint armInteractionPoint : this.outputs) {
            if (armInteractionPoint.isValid()) {
                stack = armInteractionPoint.insert(stack, true);
            }
            if (!stack.m_41619_()) continue;
            break;
        }
        return stack;
    }

    protected void depositItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            ItemStack remainder;
            ItemStack toInsert = this.heldItem.m_41777_();
            this.heldItem = remainder = armInteractionPoint.insert(toInsert, false);
            if (armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint && remainder.m_41619_()) {
                this.award(AllAdvancements.MUSICAL_ARM);
            }
        }
        this.phase = this.heldItem.m_41619_() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            this.award(AllAdvancements.MECHANICAL_ARM);
        }
    }

    protected void collectItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            for (int i = 0; i < armInteractionPoint.getSlotCount(); ++i) {
                int amountExtracted = this.getDistributableAmount(armInteractionPoint, i);
                if (amountExtracted == 0) continue;
                ItemStack prevHeld = this.heldItem;
                this.heldItem = armInteractionPoint.extract(i, amountExtracted, false);
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.m_6596_();
                if (!ItemStack.m_41656_((ItemStack)this.heldItem, (ItemStack)prevHeld)) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.125f, 0.5f + Create.RANDOM.nextFloat() * 0.25f);
                }
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.m_6596_();
    }

    public void redstoneUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean blockPowered = this.f_58857_.m_276867_(this.f_58858_);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
        if (!this.redstoneLocked) {
            this.searchForItem();
        }
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        if (this.interactionPointTag == null) {
            return;
        }
        for (Tag tag : this.interactionPointTag) {
            ArmInteractionPoint.transformPos((CompoundTag)tag, transform);
        }
        this.notifyUpdate();
    }

    protected boolean isAreaActuallyLoaded(BlockPos center, int range) {
        if (!this.f_58857_.isAreaLoaded(center, range)) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            int minY = center.m_123342_() - range;
            int maxY = center.m_123342_() + range;
            if (maxY < this.f_58857_.m_141937_() || minY >= this.f_58857_.m_151558_()) {
                return false;
            }
            int minX = center.m_123341_() - range;
            int minZ = center.m_123343_() - range;
            int maxX = center.m_123341_() + range;
            int maxZ = center.m_123343_() + range;
            int minChunkX = SectionPos.m_123171_((int)minX);
            int maxChunkX = SectionPos.m_123171_((int)maxX);
            int minChunkZ = SectionPos.m_123171_((int)minZ);
            int maxChunkZ = SectionPos.m_123171_((int)maxZ);
            ChunkSource chunkSource = this.f_58857_.m_7726_();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (chunkSource.m_5563_(chunkX, chunkZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (!this.updateInteractionPoints || this.interactionPointTag == null) {
            return;
        }
        if (!this.isAreaActuallyLoaded(this.f_58858_, ArmBlockEntity.getRange() + 1)) {
            return;
        }
        this.inputs.clear();
        this.outputs.clear();
        boolean hasBlazeBurner = false;
        for (Tag tag : this.interactionPointTag) {
            ArmInteractionPoint point = ArmInteractionPoint.deserialize((CompoundTag)tag, this.f_58857_, this.f_58858_);
            if (point == null) continue;
            if (point.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                this.outputs.add(point);
            } else if (point.getMode() == ArmInteractionPoint.Mode.TAKE) {
                this.inputs.add(point);
            }
            hasBlazeBurner |= point instanceof AllArmInteractionPointTypes.BlazeBurnerPoint;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.outputs.size() >= 10) {
                this.award(AllAdvancements.ARM_MANY_TARGETS);
            }
            if (hasBlazeBurner) {
                this.award(AllAdvancements.ARM_BLAZE_BURNER);
            }
        }
        this.updateInteractionPoints = false;
        this.sendData();
        this.m_6596_();
    }

    public void writeInteractionPoints(CompoundTag compound) {
        if (this.updateInteractionPoints && this.interactionPointTag != null) {
            compound.m_128365_("InteractionPoints", (Tag)this.interactionPointTag);
        } else {
            ListTag pointsNBT = new ListTag();
            this.inputs.stream().map(aip -> aip.serialize(this.f_58858_)).forEach(arg_0 -> pointsNBT.add(arg_0));
            this.outputs.stream().map(aip -> aip.serialize(this.f_58858_)).forEach(arg_0 -> pointsNBT.add(arg_0));
            compound.m_128365_("InteractionPoints", (Tag)pointsNBT);
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeInteractionPoints(compound);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"Phase", (Enum)this.phase);
        compound.m_128379_("Powered", this.redstoneLocked);
        compound.m_128379_("Goggles", this.goggles);
        compound.m_128365_("HeldItem", (Tag)this.heldItem.serializeNBT());
        compound.m_128405_("TargetPointIndex", this.chasedPointIndex);
        compound.m_128350_("MovementProgress", this.chasedPointProgress);
    }

    @Override
    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        this.writeInteractionPoints(compound);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        ListTag interactionPointTagBefore = this.interactionPointTag;
        super.read(compound, clientPacket);
        this.heldItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("HeldItem"));
        this.phase = (Phase)NBTHelper.readEnum((CompoundTag)compound, (String)"Phase", Phase.class);
        this.chasedPointIndex = compound.m_128451_("TargetPointIndex");
        this.chasedPointProgress = compound.m_128457_("MovementProgress");
        this.interactionPointTag = compound.m_128437_("InteractionPoints", 10);
        this.redstoneLocked = compound.m_128471_("Powered");
        boolean hadGoggles = this.goggles;
        this.goggles = compound.m_128471_("Goggles");
        if (!clientPacket) {
            return;
        }
        if (hadGoggles != this.goggles) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
        boolean ceiling = this.isOnCeiling();
        if (interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size()) {
            this.updateInteractionPoints = true;
        }
        if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
            ArmInteractionPoint targetedPoint;
            ArmInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                previousPoint = this.inputs.get(previousIndex);
            }
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                previousPoint = this.outputs.get(previousIndex);
            }
            ArmAngleTarget armAngleTarget = this.previousTarget = previousPoint == null ? ArmAngleTarget.NO_TARGET : previousPoint.getTargetAngles(this.f_58858_, ceiling);
            if (previousPoint != null) {
                this.previousBaseAngle = this.previousTarget.baseAngle;
            }
            if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                targetedPoint.updateCachedState();
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.tooltipWarmup > 0) {
            return false;
        }
        if (!this.inputs.isEmpty()) {
            return false;
        }
        if (!this.outputs.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.mechanical_arm_no_targets", new Object[0]);
        return true;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        for (ArmInteractionPoint input : this.inputs) {
            input.setLevel(level);
        }
        for (ArmInteractionPoint output : this.outputs) {
            output.setLevel(level);
        }
    }

    public static enum Phase {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT,
        DANCING;

    }

    public static enum SelectionMode implements INamedIconOptions
    {
        ROUND_ROBIN(AllIcons.I_ARM_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_ARM_FORCED_ROUND_ROBIN),
        PREFER_FIRST(AllIcons.I_ARM_PREFER_FIRST);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "mechanical_arm.selection_mode." + Lang.asId((String)this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class SelectionModeValueBox
    extends CenteredSideValueBoxTransform {
        public SelectionModeValueBox() {
            super((BlockState blockState, Direction direction) -> !direction.m_122434_().m_122478_());
        }

        @Override
        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            int yPos = (Boolean)state.m_61143_((Property)ArmBlock.CEILING) != false ? 13 : 3;
            Vec3 location = VecHelper.voxelSpace((double)8.0, (double)yPos, (double)15.5);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            return location;
        }

        @Override
        public float getScale() {
            return super.getScale();
        }
    }
}

