/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.blocks.mek_reg;

import java.util.function.Supplier;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ResourceType;
import net.allthemods.alltheores.infos.ItemTagRegistry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public enum ATOResource implements IResource
{
    ALUMINUM("aluminum", 0xE3E3E3, ItemTagRegistry.ALUMINUM_ORE_ITEM),
    NICKEL("nickel", 11118980, ItemTagRegistry.NICKEL_ORE_ITEM),
    PLATINUM("platinum", 12634589, ItemTagRegistry.PLATINUM_ORE_ITEM),
    SILVER("silver", 10805479, ItemTagRegistry.SILVER_ORE_ITEM),
    IRIDIUM("iridium", 10282212, ItemTagRegistry.IRIDIUM_ORE_ITEM),
    ZINC("zinc", 0xB5B575, ItemTagRegistry.ZINC_ORE_ITEM);

    private final String name;
    private final int tint;
    private final Supplier<TagKey<Item>> oreTag;
    private final boolean isVanilla;
    private final BlockResourceInfo resourceBlockInfo;
    private final BlockResourceInfo rawResourceBlockInfo;

    private ATOResource(String name, int colour, TagKey<Item> oreTag) {
        this(name, colour, () -> oreTag, true, null, null);
    }

    private ATOResource(String name, int tint, Supplier<TagKey<Item>> oreTag, boolean isVanilla, BlockResourceInfo resourceBlockInfo, BlockResourceInfo rawResourceBlockInfo) {
        this.name = name;
        this.tint = tint;
        this.oreTag = oreTag;
        this.isVanilla = isVanilla;
        this.resourceBlockInfo = resourceBlockInfo;
        this.rawResourceBlockInfo = rawResourceBlockInfo;
    }

    public String getRegistrySuffix() {
        return this.name;
    }

    public int getTint() {
        return this.tint;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag.get();
    }

    public boolean has(ResourceType type) {
        return type != ResourceType.ENRICHED && (!this.isVanilla || !type.isVanilla());
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Nullable
    public BlockResourceInfo getResourceBlockInfo() {
        return this.resourceBlockInfo;
    }

    @Nullable
    public BlockResourceInfo getRawResourceBlockInfo() {
        return this.rawResourceBlockInfo;
    }
}

