/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.PotionAffix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionBonus
extends GemBonus {
    public static final Codec<PotionBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(PotionBonus.gemClass(), (App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)PotionAffix.Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply)).apply((Applicative)inst, PotionBonus::new));
    protected final MobEffect effect;
    protected final PotionAffix.Target target;
    protected final Map<LootRarity, EffectData> values;
    protected final boolean stackOnReapply;

    public PotionBonus(GemClass gemClass, MobEffect effect, PotionAffix.Target target, Map<LootRarity, EffectData> values, boolean stackOnReapply) {
        super(Apotheosis.loc("mob_effect"), gemClass);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.stackOnReapply = stackOnReapply;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        MobEffectInstance inst = this.values.get(rarity).build(this.effect);
        MutableComponent comp = this.target.toComponent(PotionBonus.toComponent(inst)).m_130940_(ChatFormatting.YELLOW);
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public void doPostHurt(ItemStack gem, LootRarity rarity, LivingEntity user, Entity attacker) {
        if (this.target == PotionAffix.Target.HURT_SELF) {
            this.applyEffect(gem, user, rarity);
        } else if (this.target == PotionAffix.Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffect(gem, tLiving, rarity);
        }
    }

    @Override
    public void doPostAttack(ItemStack gem, LootRarity rarity, LivingEntity user, Entity target) {
        if (this.target == PotionAffix.Target.ATTACK_SELF) {
            this.applyEffect(gem, user, rarity);
        } else if (this.target == PotionAffix.Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(gem, tLiving, rarity);
        }
    }

    @Override
    public void onBlockBreak(ItemStack gem, LootRarity rarity, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.target == PotionAffix.Target.BREAK_SELF) {
            this.applyEffect(gem, (LivingEntity)player, rarity);
        }
    }

    @Override
    public void onArrowImpact(ItemStack gemStack, LootRarity rarity, AbstractArrow arrow, HitResult res) {
        Entity entity;
        if (this.target == PotionAffix.Target.ARROW_SELF) {
            Entity entity2 = arrow.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                this.applyEffect(gemStack, owner, rarity);
            }
        } else if (this.target == PotionAffix.Target.ARROW_TARGET && res.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffect(gemStack, target, rarity);
        }
    }

    @Override
    public float onShieldBlock(ItemStack gem, LootRarity rarity, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        if (this.target == PotionAffix.Target.BLOCK_SELF) {
            this.applyEffect(gem, entity, rarity);
        } else if (this.target == PotionAffix.Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(gem, target, rarity);
        }
        return amount;
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        return data.cooldown;
    }

    private void applyEffect(ItemStack gemStack, LivingEntity target, LootRarity rarity) {
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && Affix.isOnCooldown(this.getCooldownId(gemStack), cooldown, target)) {
            return;
        }
        EffectData data = this.values.get(rarity);
        MobEffectInstance inst = target.m_21124_(this.effect);
        if (this.stackOnReapply && inst != null) {
            if (inst != null) {
                MobEffectInstance newInst = new MobEffectInstance(this.effect, Math.max(inst.m_19557_(), data.duration), inst.m_19564_() + 1 + data.amplifier);
                target.m_7292_(newInst);
            }
        } else {
            target.m_7292_(data.build(this.effect));
        }
        Affix.startCooldown(this.getCooldownId(gemStack), target);
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    @Override
    public PotionBonus validate() {
        Preconditions.checkNotNull((Object)this.effect, (Object)"Null mob effect");
        Preconditions.checkNotNull((Object)((Object)this.target), (Object)"Null target");
        Preconditions.checkNotNull(this.values, (Object)"Null values map");
        return this;
    }

    public record EffectData(int duration, int amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(EffectData::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(MobEffect effect) {
            return new MobEffectInstance(effect, this.duration, this.amplifier);
        }
    }
}

