/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import cofh.thermal.core.util.managers.machine.BottlerRecipeManager;
import cofh.thermal.core.util.managers.machine.BrewerRecipeManager;
import cofh.thermal.core.util.managers.machine.CentrifugeRecipeManager;
import cofh.thermal.core.util.managers.machine.ChillerRecipeManager;
import cofh.thermal.core.util.managers.machine.CrucibleRecipeManager;
import cofh.thermal.core.util.managers.machine.CrystallizerRecipeManager;
import cofh.thermal.core.util.managers.machine.FurnaceRecipeManager;
import cofh.thermal.core.util.managers.machine.PressRecipeManager;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.core.util.managers.machine.PyrolyzerRecipeManager;
import cofh.thermal.core.util.managers.machine.RefineryRecipeManager;
import cofh.thermal.core.util.managers.machine.SawmillRecipeManager;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.thermal.ThermalRecipeJS;

public interface BasicRecipeSchema {
    public static final RecipeKey<Either<OutputFluid, OutputItem>[]> RESULTS = FluidComponents.OUTPUT_OR_ITEM_ARRAY.key("results").alt(new String[]{"result", "output", "outputs"});
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients").alt(new String[]{"ingredient", "input", "inputs"});
    public static final RecipeKey<Float> EXPERIENCE = NumberComponent.FLOAT.key("experience").optional((Object)Float.valueOf(0.0f)).preferred("xp");
    public static final RecipeKey<Integer> ENERGY = NumberComponent.INT.key("energy").optional(type -> switch (type.id.m_135815_()) {
        case "furnace" -> FurnaceRecipeManager.instance().getDefaultEnergy();
        case "sawmill" -> SawmillRecipeManager.instance().getDefaultEnergy();
        case "pulverizer", "pulverizer_recycle" -> PulverizerRecipeManager.instance().getDefaultEnergy();
        case "smelter", "smelter_recycle" -> SmelterRecipeManager.instance().getDefaultEnergy();
        case "centrifuge" -> CentrifugeRecipeManager.instance().getDefaultEnergy();
        case "press" -> PressRecipeManager.instance().getDefaultEnergy();
        case "crucible" -> CrucibleRecipeManager.instance().getDefaultEnergy();
        case "chiller" -> ChillerRecipeManager.instance().getDefaultEnergy();
        case "refinery" -> RefineryRecipeManager.instance().getDefaultEnergy();
        case "pyrolyzer" -> PyrolyzerRecipeManager.instance().getDefaultEnergy();
        case "bottler" -> BottlerRecipeManager.instance().getDefaultEnergy();
        case "brewer" -> BrewerRecipeManager.instance().getDefaultEnergy();
        case "crystallizer" -> CrystallizerRecipeManager.instance().getDefaultEnergy();
        default -> 0;
    });
    public static final RecipeKey<Float> ENERGY_MOD = NumberComponent.FLOAT.key("energy_mod").optional((Object)Float.valueOf(1.0f)).preferred("energyMod").exclude();
    public static final RecipeSchema SCHEMA = new RecipeSchema(ThermalRecipeJS.class, ThermalRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, EXPERIENCE, ENERGY, ENERGY_MOD});
}

