/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.HashMap;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalHandler {
    private static final WeakHashMap<Player, CraftingTerminalHandler> players = new WeakHashMap();
    private final Player player;
    private ItemStack craftingTerminal = ItemStack.f_41583_;
    private WTMenuHost menuHost;
    private MenuLocator locator;
    private HashMap<Item, Long> restockAbleItems = new HashMap();
    private MagnetHost magnetHost;

    private CraftingTerminalHandler(Player player) {
        this.player = player;
    }

    public static CraftingTerminalHandler getCraftingTerminalHandler(Player player) {
        if (players.containsKey(player)) {
            if (player == CraftingTerminalHandler.players.get((Object)player).player || !(player instanceof ServerPlayer) && CraftingTerminalHandler.players.get((Object)player).player instanceof ServerPlayer) {
                return players.get(player);
            }
            CraftingTerminalHandler.removePlayer(player);
        }
        CraftingTerminalHandler handler = new CraftingTerminalHandler(player);
        players.put(player, handler);
        return handler;
    }

    public static void removePlayer(Player player) {
        players.remove(player);
    }

    public void invalidateCache() {
        this.craftingTerminal = ItemStack.f_41583_;
        this.menuHost = null;
        this.locator = null;
        this.restockAbleItems.clear();
        this.magnetHost = null;
    }

    public ItemStack getCraftingTerminal() {
        Inventory inv = this.player.m_150109_();
        if (!this.craftingTerminal.m_41619_() && (inv.m_36063_(this.craftingTerminal) || Platform.trinketsPresent() && Platform.isStillPresentTrinkets(this.player, this.craftingTerminal))) {
            return this.craftingTerminal;
        }
        this.craftingTerminal = this.getMenuHost() == null ? ItemStack.f_41583_ : this.menuHost.getItemStack();
        return this.craftingTerminal;
    }

    @Nullable
    private WTMenuHost getMenuHost() {
        if (this.menuHost != null && this.menuHost.rangeCheck() && this.menuHost.stillValid()) {
            return this.menuHost;
        }
        this.locator = WUTHandler.findTerminal(this.player, "crafting");
        this.menuHost = this.locator == null ? null : (WTMenuHost)((Object)this.locator.locate(this.player, WTMenuHost.class));
        if (this.menuHost == null) {
            this.invalidateCache();
        }
        return this.menuHost;
    }

    @Nullable
    public MenuLocator getLocator() {
        if (this.getMenuHost() == null) {
            return null;
        }
        return this.locator;
    }

    @Nullable
    public IGrid getTargetGrid() {
        IGridNode n = this.menuHost.getActionableNode();
        if (n == null) {
            return null;
        }
        return this.menuHost.getActionableNode().getGrid();
    }

    public boolean inRange() {
        if (this.getMenuHost() == null) {
            return false;
        }
        return this.getMenuHost().rangeCheck();
    }

    public long getAccessibleAmount(ItemStack stack) {
        return (long)stack.m_41613_() + (this.restockAbleItems.get(stack.m_41720_()) == null ? 0L : this.restockAbleItems.get(stack.m_41720_()));
    }

    public boolean isRestockable(ItemStack stack) {
        return this.restockAbleItems.containsKey(stack.m_41720_());
    }

    public void setRestockAbleItems(HashMap<Item, Long> items) {
        this.restockAbleItems = items;
    }

    @Nullable
    public MagnetHost getMagnetHost() {
        if (this.magnetHost == null) {
            if (this.getCraftingTerminal().m_41619_()) {
                return null;
            }
            this.magnetHost = new MagnetHost(this);
        }
        return this.magnetHost;
    }
}

