/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.jei.CreatingFluxRecipe;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;

public class CreatingFluxRecipeCategory
implements IRecipeCategory<CreatingFluxRecipe> {
    public static final ResourceLocation TEXTURES = FluxNetworks.location("textures/gui/gui_creating_flux_recipe.png");
    public static final RecipeType<CreatingFluxRecipe> RECIPE_TYPE = RecipeType.create((String)"fluxnetworks", (String)"creating_flux", CreatingFluxRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer timer;

    public CreatingFluxRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, -20, 128, 80);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get()));
        this.timer = guiHelper.createTickTimer(60, 320, false);
    }

    @Nonnull
    public static List<CreatingFluxRecipe> getRecipes() {
        ArrayList<CreatingFluxRecipe> recipes = new ArrayList<CreatingFluxRecipe>();
        recipes.add(new CreatingFluxRecipe(Blocks.f_50752_, Blocks.f_50080_, new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get())));
        recipes.add(new CreatingFluxRecipe((Block)RegistryBlocks.FLUX_BLOCK.get(), Blocks.f_50080_, new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get())));
        return recipes;
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return List.of(new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get()));
    }

    @Nonnull
    public RecipeType<CreatingFluxRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return FluxTranslate.JEI_CREATING_FLUX.getComponent();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull CreatingFluxRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 25).addItemStack(recipe.input());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 25).addItemStack(recipe.output());
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull CreatingFluxRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 40.0 && mouseX < 80.0 && mouseY >= 10.0 && mouseY < 64.0) {
            return List.of(Component.m_237113_((String)"Y+2 = ").m_7220_((Component)recipe.crusher().m_49954_()), Component.m_237113_((String)"Y+1 = ").m_7220_(recipe.input().m_41786_()), Component.m_237113_((String)"Y+0 = ").m_7220_((Component)recipe.base().m_49954_()));
        }
        return Collections.emptyList();
    }

    public void draw(@Nonnull CreatingFluxRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        Quaternionf quat = new Quaternionf();
        quat.rotationXYZ(0.5235988f, 0.7853982f, 0.0f);
        guiGraphics.m_280168_().m_85836_();
        int value = this.timer.getValue();
        double offset = (float)(value > 160 ? 160 - (value - 160) : value) / 10.0f;
        guiGraphics.m_280168_().m_85837_(52.0, 10.0 + offset, 128.0);
        guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        guiGraphics.m_280168_().m_252781_(quat);
        dispatcher.renderSingleBlock(recipe.crusher().m_49966_(), guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(52.0f, 40.0f, 96.0f);
        guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        guiGraphics.m_280168_().m_252781_(quat);
        dispatcher.renderSingleBlock(recipe.base().m_49966_(), guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(63.0f, 36.0f, 112.0f);
        guiGraphics.m_280168_().m_85841_(16.0f, -16.0f, 16.0f);
        ItemStack toDisplay = value > 160 ? recipe.output() : recipe.input();
        guiGraphics.m_280168_().m_252781_(quat.rotationXYZ(toDisplay.m_41720_() instanceof BlockItem ? 0.5235988f : 0.0f, (-90.0f + 180.0f * ((float)value / (float)this.timer.getMaxValue())) * ((float)Math.PI / 180), 0.0f));
        itemRenderer.m_269128_(toDisplay, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, null, 0);
        guiGraphics.m_280168_().m_85849_();
        bufferSource.m_109911_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        String help = FluxTranslate.JEI_LEFT_CLICK.format(recipe.crusher().m_49954_().getString());
        guiGraphics.m_280056_(fontRenderer, help, 64 - fontRenderer.m_92895_(help) / 2, 68, -12566464, false);
    }
}

