/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.popup.PopupCustomColor;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;

public abstract class GuiTabEditAbstract
extends GuiTabCore {
    protected SecurityLevel mSecurityLevel;
    public ColorButton mColorButton;
    public FluxEditBox mNetworkName;
    public FluxEditBox mPassword;

    public GuiTabEditAbstract(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    public abstract void onEditSettingsChanged();

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.getNetwork().isValid() || this.getNavigationTab() == EnumNavigationTab.TAB_CREATE) {
            this.mNetworkName = FluxEditBox.create(FluxTranslate.NETWORK_NAME.get() + ": ", this.f_96547_, this.f_97735_ + 16, this.f_97736_ + 28, 144, 12).setOutlineColor(-8355712);
            this.mNetworkName.m_94199_(24);
            this.mNetworkName.m_94151_(string -> this.onEditSettingsChanged());
            this.m_142416_((GuiEventListener)this.mNetworkName);
            this.mPassword = FluxEditBox.create(FluxTranslate.NETWORK_PASSWORD.get() + ": ", this.f_96547_, this.f_97735_ + 16, this.f_97736_ + 62, 144, 12).setOutlineColor(-8355712).setTextInvisible();
            this.mPassword.m_94153_(string -> string != null && (string.isEmpty() || !FluxUtils.isBadPassword(string)));
            this.mPassword.m_94199_(16);
            this.mPassword.m_94151_(string -> this.onEditSettingsChanged());
            this.mPassword.m_94194_(this.mSecurityLevel == SecurityLevel.ENCRYPTED);
            this.m_142416_((GuiEventListener)this.mPassword);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid() || this.getNavigationTab() == EnumNavigationTab.TAB_CREATE) {
            gr.m_280137_(this.f_96547_, this.getNavigationTab().getTranslatedName(), this.f_97735_ + 88, this.f_97736_ + 10, -4934476);
            gr.m_280488_(this.f_96547_, FluxTranslate.NETWORK_SECURITY.get() + ": " + ChatFormatting.AQUA + this.mSecurityLevel.getName(), this.f_97735_ + 16, this.f_97736_ + 47, -8355712);
            gr.m_280488_(this.f_96547_, FluxTranslate.NETWORK_COLOR.get() + ":", this.f_97735_ + 16, this.f_97736_ + 89, -8355712);
            this.renderNetwork(gr, this.mNetworkName.m_94155_(), this.mColorButton.mColor, this.f_97736_ + 126);
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && mouseX >= (double)(this.f_97735_ + 36) && mouseX < (double)(this.f_97735_ + 96) && mouseY >= (double)(this.f_97736_ + 48) && mouseY < (double)(this.f_97736_ + 56)) {
            this.mSecurityLevel = (SecurityLevel)FluxUtils.cycle((Enum)this.mSecurityLevel, (Enum[])SecurityLevel.VALUES);
            this.mPassword.m_94194_(this.mSecurityLevel == SecurityLevel.ENCRYPTED);
            this.onEditSettingsChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof ColorButton) {
            this.mColorButton.setSelected(false);
            this.mColorButton = (ColorButton)button;
            this.mColorButton.setSelected(true);
            this.onEditSettingsChanged();
            if (mouseButton == 1) {
                this.openPopup(new PopupCustomColor(this, this.mColorButton.mColor));
            }
        }
    }

    @Override
    public void onPopupClose(GuiPopupCore<?> popUp) {
        super.onPopupClose(popUp);
        if (popUp instanceof PopupCustomColor) {
            this.mColorButton.mColor = ((PopupCustomColor)popUp).mCurrentColor;
            this.onEditSettingsChanged();
        }
    }
}

