/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import stone.mae2.MAE2;
import stone.mae2.parts.p2p.multi.CapabilityMultiP2PPart;

public class ItemMultiP2PPart
extends CapabilityMultiP2PPart<ItemMultiP2PPart, IItemHandler> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_items"));
    private static final IItemHandler NULL_ITEM_HANDLER = new NullItemHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public ItemMultiP2PPart(IPartItem<?> partItem) {
        super(partItem, ForgeCapabilities.ITEM_HANDLER);
        this.inputHandler = new InputItemHandler();
        this.outputHandler = new OutputItemHandler();
        this.emptyHandler = NULL_ITEM_HANDLER;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputItemHandler
    implements IItemHandler {
        private InputItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int remainder = stack.m_41613_();
            int outputTunnels = ItemMultiP2PPart.this.getOutputs().size();
            int amount = stack.m_41613_();
            if (outputTunnels == 0 || amount == 0) {
                return stack;
            }
            int amountPerOutput = amount / outputTunnels;
            int overflow = amountPerOutput == 0 ? amount : amount % amountPerOutput;
            for (ItemMultiP2PPart target : ItemMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    IItemHandler output = (IItemHandler)capabilityGuard.get();
                    int toSend = amountPerOutput + overflow;
                    if (toSend <= 0) break;
                    ItemStack stackCopy = stack.m_41777_();
                    stackCopy.m_41764_(toSend);
                    int sent = toSend - ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)stackCopy, (boolean)simulate).m_41613_();
                    overflow = toSend - sent;
                    remainder -= sent;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            if (!simulate) {
                ItemMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, amount - remainder);
            }
            if (remainder == stack.m_41613_()) {
                return stack;
            }
            if (remainder == 0) {
                return ItemStack.f_41583_;
            }
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(remainder);
            return copy;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    }

    private class OutputItemHandler
    implements IItemHandler {
        private OutputItemHandler() {
        }

        public int getSlots() {
            return ItemMultiP2PPart.this.getInputStream().mapToInt(input -> {
                try (CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    int n = ((IItemHandler)guard.get()).getSlots();
                    return n;
                }
            }).sum();
        }

        public ItemStack getStackInSlot(int slot) {
            List inputs = ItemMultiP2PPart.this.getInputs();
            int currentSlot = slot;
            for (ItemMultiP2PPart input : inputs) {
                CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();
                try {
                    IItemHandler handler = (IItemHandler)guard.get();
                    int slotCount = handler.getSlots();
                    if (currentSlot < slotCount) {
                        ItemStack itemStack = handler.getStackInSlot(currentSlot);
                        return itemStack;
                    }
                    currentSlot -= slotCount;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            List inputs = ItemMultiP2PPart.this.getInputs();
            int currentSlot = slot;
            for (ItemMultiP2PPart input : inputs) {
                CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();
                try {
                    IItemHandler handler = (IItemHandler)guard.get();
                    int slotCount = handler.getSlots();
                    if (currentSlot < slotCount) {
                        ItemStack itemStack = handler.extractItem(currentSlot, amount, simulate);
                        return itemStack;
                    }
                    currentSlot -= slotCount;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }

    private static class NullItemHandler
    implements IItemHandler {
        private NullItemHandler() {
        }

        public int getSlots() {
            return 0;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }
}

