/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.capabilities.Capabilities;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import net.minecraftforge.energy.IEnergyStorage;
import stone.mae2.MAE2;
import stone.mae2.parts.p2p.multi.CapabilityMultiP2PPart;

public class FEMultiP2PPart
extends CapabilityMultiP2PPart<FEMultiP2PPart, IEnergyStorage> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_fe"));
    private static final IEnergyStorage NULL_ENERGY_STORAGE = new NullEnergyStorage();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FEMultiP2PPart(IPartItem<?> partItem) {
        super(partItem, Capabilities.FORGE_ENERGY);
        this.inputHandler = new InputEnergyStorage();
        this.outputHandler = new OutputEnergyStorage();
        this.emptyHandler = NULL_ENERGY_STORAGE;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputEnergyStorage
    implements IEnergyStorage {
        private InputEnergyStorage() {
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int total = 0;
            int outputTunnels = FEMultiP2PPart.this.getOutputs().size();
            if (outputTunnels == 0 | maxReceive == 0) {
                return 0;
            }
            int amountPerOutput = maxReceive / outputTunnels;
            int overflow = amountPerOutput == 0 ? maxReceive : maxReceive % amountPerOutput;
            for (FEMultiP2PPart target : FEMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    IEnergyStorage output = (IEnergyStorage)capabilityGuard.get();
                    int toSend = amountPerOutput + overflow;
                    int received = output.receiveEnergy(toSend, simulate);
                    overflow = toSend - received;
                    total += received;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            if (!simulate) {
                FEMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, total);
            }
            return total;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return FEMultiP2PPart.this.getOutputStream().anyMatch(output -> {
                try (CapabilityMultiP2PPart.CapabilityGuard guard = output.getAdjacentCapability();){
                    boolean bl = ((IEnergyStorage)guard.get()).canReceive();
                    return bl;
                }
            });
        }

        public int getMaxEnergyStored() {
            int total = 0;
            for (FEMultiP2PPart t : FEMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = t.getAdjacentCapability();
                try {
                    total += ((IEnergyStorage)capabilityGuard.get()).getMaxEnergyStored();
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return total;
        }

        public int getEnergyStored() {
            int total = 0;
            for (FEMultiP2PPart t : FEMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = t.getAdjacentCapability();
                try {
                    total += ((IEnergyStorage)capabilityGuard.get()).getEnergyStored();
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return total;
        }
    }

    private class OutputEnergyStorage
    implements IEnergyStorage {
        private OutputEnergyStorage() {
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (maxExtract == 0) {
                return 0;
            }
            int toExtract = maxExtract;
            for (FEMultiP2PPart target : FEMultiP2PPart.this.getInputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    IEnergyStorage output = (IEnergyStorage)capabilityGuard.get();
                    if ((toExtract -= output.extractEnergy(toExtract, simulate)) > 0) continue;
                    break;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            int extracted = maxExtract - toExtract;
            if (!simulate) {
                FEMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, extracted);
            }
            return extracted;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public boolean canExtract() {
            return FEMultiP2PPart.this.getInputStream().anyMatch(input -> {
                try (CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    boolean bl = ((IEnergyStorage)guard.get()).canExtract();
                    return bl;
                }
            });
        }

        public boolean canReceive() {
            return false;
        }

        public int getMaxEnergyStored() {
            return FEMultiP2PPart.this.getInputStream().mapToInt(input -> {
                try (CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    int n = ((IEnergyStorage)guard.get()).getMaxEnergyStored();
                    return n;
                }
            }).sum();
        }

        public int getEnergyStored() {
            return FEMultiP2PPart.this.getInputStream().mapToInt(input -> {
                try (CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    int n = ((IEnergyStorage)guard.get()).getEnergyStored();
                    return n;
                }
            }).sum();
        }
    }

    private static class NullEnergyStorage
    implements IEnergyStorage {
        private NullEnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

