/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import stone.mae2.MAE2;
import stone.mae2.me.service.MultiP2PService;
import stone.mae2.parts.p2p.multi.CapabilityMultiP2PPart;

public class EUMultiP2PPart
extends CapabilityMultiP2PPart<EUMultiP2PPart, IEnergyContainer> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_eu"));
    private static final IEnergyContainer EMPTY_HANDLER = new EmptyHandler();

    public EUMultiP2PPart(IPartItem<?> partItem) {
        super(partItem, GTCapability.CAPABILITY_ENERGY_CONTAINER);
        this.inputHandler = new InputHandler();
        this.outputHandler = new OutputHandler();
        this.emptyHandler = EMPTY_HANDLER;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public Set<EUMultiP2PPart> getTickOutputs() {
        IGrid grid;
        if (this.getMainNode().isOnline() && (grid = this.getMainNode().getGrid()) != null) {
            return ((MultiP2PService)grid.getService(MultiP2PService.class)).getTickOutputs(this.getFrequency(), EUMultiP2PPart.class);
        }
        return Collections.emptySet();
    }

    public class InputHandler
    implements IEnergyContainer {
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            long toSend = amperage;
            long total = 0L;
            Iterator<EUMultiP2PPart> it = EUMultiP2PPart.this.getTickOutputs().iterator();
            while (it.hasNext()) {
                EUMultiP2PPart target = it.next();
                try (CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();){
                    IEnergyContainer output = (IEnergyContainer)capabilityGuard.get();
                    long received = output.acceptEnergyFromNetwork(target.getSide().m_122424_(), voltage, toSend);
                    total += received;
                    if ((toSend -= received) == 0L) {
                        break;
                    }
                }
                it.remove();
            }
            if (total > 0L) {
                EUMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, (double)total * (double)voltage * (double)FeCompat.ratio((boolean)false));
            }
            return total;
        }

        public boolean inputsEnergy(Direction side) {
            return EUMultiP2PPart.this.getSide() == side;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyStored());
                    }
                    catch (ArithmeticException e) {
                        long l = 0L;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getEnergyCapacity() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyCapacity());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputAmperage() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getInputAmperage());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputVoltage() {
            long maxVoltage = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    maxVoltage = Math.max(maxVoltage, ((IEnergyContainer)guard.get()).getInputVoltage());
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return maxVoltage;
        }
    }

    public class OutputHandler
    implements IEnergyContainer {
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        public boolean inputsEnergy(Direction side) {
            return false;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getInputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyStored());
                    }
                    catch (ArithmeticException e) {
                        long l = 0L;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getEnergyCapacity() {
            long total = 0L;
            for (EUMultiP2PPart part : EUMultiP2PPart.this.getInputs()) {
                CapabilityMultiP2PPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyCapacity());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }

    private static class EmptyHandler
    implements IEnergyContainer {
        private EmptyHandler() {
        }

        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        public boolean inputsEnergy(Direction side) {
            return false;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            return 0L;
        }

        public long getEnergyCapacity() {
            return 0L;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }
}

