/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import java.util.List;
import net.minecraft.core.Direction;
import stone.mae2.MAE2;

public class EUP2PTunnelPart
extends CapabilityP2PTunnelPart<EUP2PTunnelPart, IEnergyContainer> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/p2p_tunnel_eu"));
    private static final IEnergyContainer EMPTY_HANDLER = new EmptyHandler();

    public EUP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, GTCapability.CAPABILITY_ENERGY_CONTAINER);
        this.inputHandler = new InputHandler();
        this.outputHandler = new OutputHandler();
        this.emptyHandler = EMPTY_HANDLER;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public class InputHandler
    implements IEnergyContainer {
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            long toSend = amperage;
            long total = 0L;
            for (EUP2PTunnelPart target : EUP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = target.getAdjacentCapability();
                try {
                    long received = ((IEnergyContainer)guard.get()).acceptEnergyFromNetwork(target.getSide().m_122424_(), voltage, toSend);
                    total += received;
                    if ((toSend -= received) > 0L) continue;
                    break;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            if (total > 0L) {
                EUP2PTunnelPart.this.queueTunnelDrain(PowerUnits.FE, (double)total * (double)voltage * (double)FeCompat.ratio((boolean)false));
            }
            return total;
        }

        public boolean inputsEnergy(Direction side) {
            return EUP2PTunnelPart.this.getSide() == side;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            long total = 0L;
            for (EUP2PTunnelPart part : EUP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyStored());
                    }
                    catch (ArithmeticException e) {
                        long l = 0L;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getEnergyCapacity() {
            long total = 0L;
            for (EUP2PTunnelPart part : EUP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getEnergyCapacity());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputAmperage() {
            long total = 0L;
            for (EUP2PTunnelPart part : EUP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    try {
                        total = Math.addExact(total, ((IEnergyContainer)guard.get()).getInputAmperage());
                    }
                    catch (ArithmeticException e) {
                        long l = Long.MAX_VALUE;
                        if (guard != null) {
                            guard.close();
                        }
                        return l;
                    }
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return total;
        }

        public long getInputVoltage() {
            long maxVoltage = 0L;
            for (EUP2PTunnelPart part : EUP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = part.getAdjacentCapability();
                try {
                    maxVoltage = Math.max(maxVoltage, ((IEnergyContainer)guard.get()).getInputVoltage());
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return maxVoltage;
        }
    }

    public class OutputHandler
    implements IEnergyContainer {
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        public boolean inputsEnergy(Direction side) {
            return false;
        }

        public boolean outputsEnergy(Direction side) {
            return EUP2PTunnelPart.this.getSide() == side;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            EUP2PTunnelPart input = (EUP2PTunnelPart)EUP2PTunnelPart.this.getInput();
            if (input != null) {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    long l = ((IEnergyContainer)guard.get()).getEnergyStored();
                    return l;
                }
            }
            return 0L;
        }

        public long getEnergyCapacity() {
            EUP2PTunnelPart input = (EUP2PTunnelPart)EUP2PTunnelPart.this.getInput();
            if (input != null) {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    long l = ((IEnergyContainer)guard.get()).getEnergyCapacity();
                    return l;
                }
            }
            return 0L;
        }

        public long getOutputAmperage() {
            EUP2PTunnelPart input = (EUP2PTunnelPart)EUP2PTunnelPart.this.getInput();
            if (input != null) {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    long l = ((IEnergyContainer)guard.get()).getOutputAmperage();
                    return l;
                }
            }
            return 0L;
        }

        public long getOutputVoltage() {
            EUP2PTunnelPart input = (EUP2PTunnelPart)EUP2PTunnelPart.this.getInput();
            if (input != null) {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    long l = ((IEnergyContainer)guard.get()).getOutputVoltage();
                    return l;
                }
            }
            return 0L;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }

    private static class EmptyHandler
    implements IEnergyContainer {
        private EmptyHandler() {
        }

        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        public boolean inputsEnergy(Direction side) {
            return false;
        }

        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        public long getEnergyStored() {
            return 0L;
        }

        public long getEnergyCapacity() {
            return 0L;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }
}

