/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.me.service;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.GridBootingStatusChange;
import appeng.api.networking.events.GridPowerStatusChange;
import appeng.api.networking.ticking.ITickManager;
import appeng.hooks.ticking.TickHandler;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;
import stone.mae2.MAE2;
import stone.mae2.parts.p2p.multi.MultiP2PTunnelPart;

public class MultiP2PService
implements IGridService,
IGridServiceProvider {
    private final IGrid myGrid;
    private final Multimap<Short, MultiP2PTunnelPart<?>> inputs = LinkedHashMultimap.create();
    private final Multimap<Short, MultiP2PTunnelPart<?>> outputs = LinkedHashMultimap.create();
    private final Map<Short, Map<Class<?>, Set<MultiP2PTunnelPart<?>>>> tickOutputs = new HashMap();
    private long tickOutputTick = 0L;
    private final Random frequencyGenerator;

    public MultiP2PService(IGrid g) {
        this.myGrid = g;
        this.frequencyGenerator = new Random(g.hashCode() + 1);
    }

    public void wakeInputTunnels() {
        ITickManager tm = this.myGrid.getTickManager();
        for (MultiP2PTunnelPart multiP2PTunnelPart : this.inputs.values()) {
        }
    }

    public void removeNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof MultiP2PTunnelPart) {
            MultiP2PTunnelPart tunnel = (MultiP2PTunnelPart)((Object)object);
            if (tunnel.isOutput()) {
                this.outputs.remove((Object)tunnel.getFrequency(), (Object)tunnel);
            } else {
                this.inputs.remove((Object)tunnel.getFrequency(), (Object)tunnel);
            }
            this.updateTunnel(tunnel.getFrequency(), !tunnel.isOutput(), false);
        }
    }

    public void addNode(IGridNode node, @Nullable CompoundTag savedData) {
        Object object = node.getOwner();
        if (object instanceof MultiP2PTunnelPart) {
            MultiP2PTunnelPart tunnel = (MultiP2PTunnelPart)((Object)object);
            if (tunnel.isOutput()) {
                this.outputs.put((Object)tunnel.getFrequency(), (Object)tunnel);
            } else {
                this.inputs.put((Object)tunnel.getFrequency(), (Object)tunnel);
            }
            this.updateTunnel(tunnel.getFrequency(), !tunnel.isOutput(), false);
        }
    }

    private void updateTunnel(short freq, boolean updateOutputs, boolean configChange) {
        Collection in;
        if (updateOutputs) {
            for (MultiP2PTunnelPart p : this.outputs.get((Object)freq)) {
                if (configChange) {
                    p.onTunnelConfigChange();
                }
                p.onTunnelNetworkChange();
            }
        }
        if (!updateOutputs && (in = this.inputs.get((Object)freq)) != null) {
            if (configChange) {
                in.forEach(part -> part.onTunnelConfigChange());
            }
            in.forEach(part -> part.onTunnelNetworkChange());
        }
    }

    public void updateFreq(MultiP2PTunnelPart<?> t, short newFrequency) {
        if (this.outputs.containsValue(t)) {
            this.outputs.remove((Object)t.getFrequency(), t);
        }
        if (this.inputs.containsValue(t)) {
            this.inputs.remove((Object)t.getFrequency(), t);
        }
        short oldFrequency = t.getFrequency();
        t.setFrequency(newFrequency);
        if (t.isOutput()) {
            this.outputs.put((Object)t.getFrequency(), t);
        } else {
            this.inputs.put((Object)t.getFrequency(), t);
        }
        if (oldFrequency != newFrequency) {
            this.updateTunnel(oldFrequency, true, true);
            this.updateTunnel(oldFrequency, false, true);
        }
        this.updateTunnel(newFrequency, true, true);
        this.updateTunnel(newFrequency, false, true);
    }

    public short newFrequency() {
        short newFrequency;
        int cycles = 0;
        do {
            newFrequency = (short)this.frequencyGenerator.nextInt(65536);
            ++cycles;
        } while (newFrequency == 0 || this.inputs.containsKey((Object)newFrequency));
        if (cycles > 25) {
            MAE2.LOGGER.debug("Generating a new MultiP2P frequency '%1$d' took %2$d cycles", (Object)newFrequency, (Object)cycles);
        }
        return newFrequency;
    }

    public <T extends MultiP2PTunnelPart<T>> Stream<T> getOutputs(short freq, Class<T> c) {
        return this.outputs.get((Object)freq).stream().filter(c::isInstance).map(c::cast);
    }

    public <T extends MultiP2PTunnelPart<T>> Stream<T> getInputs(short freq, Class<T> c) {
        return this.inputs.get((Object)freq).stream().filter(c::isInstance).map(c::cast);
    }

    public <T extends MultiP2PTunnelPart<T>> Set<T> getTickOutputs(short freq, Class<T> c) {
        long thisTick = TickHandler.instance().getCurrentTick();
        if (this.tickOutputTick != thisTick) {
            this.tickOutputs.clear();
            this.tickOutputTick = thisTick;
        }
        Map classMap = this.tickOutputs.computeIfAbsent(freq, f -> new HashMap());
        Set ret = classMap.computeIfAbsent(c, _c -> this.outputs.get((Object)freq).stream().filter(c::isInstance).collect(Collectors.toCollection(HashSet::new)));
        return (Set)classMap.get(c);
    }

    static {
        GridHelper.addGridServiceEventHandler(GridBootingStatusChange.class, MultiP2PService.class, (service, evt) -> {
            if (!evt.isBooting()) {
                service.wakeInputTunnels();
            }
        });
        GridHelper.addGridServiceEventHandler(GridPowerStatusChange.class, MultiP2PService.class, (service, evt) -> service.wakeInputTunnels());
    }
}

