/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.item.faulty;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import stone.mae2.item.faulty.AoEPaste;
import stone.mae2.item.faulty.GlobalPaste;
import stone.mae2.item.faulty.Incrementing;

public abstract class FaultyCardMode {
    private static final Map<ResourceLocation, Supplier<FaultyCardMode>> REGISTRY = new HashMap<ResourceLocation, Supplier<FaultyCardMode>>();
    private static final NavigableSet<ResourceLocation> CYCLE_ORDER = new TreeSet<ResourceLocation>();
    private static final String MODE_TYPE = "type";
    private static final String FAULTY_DATA = "faulty_data";

    public static FaultyCardMode of(ItemStack stack) {
        CompoundTag data = FaultyCardMode.getData(stack);
        Supplier<FaultyCardMode> supplier = REGISTRY.get(new ResourceLocation(data.m_128461_(MODE_TYPE)));
        if (supplier == null) {
            return new AoEPaste();
        }
        return supplier.get().load(data);
    }

    public static CompoundTag getData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag == null ? new CompoundTag() : tag.m_128469_(FAULTY_DATA);
    }

    public static void register(ResourceLocation key, Supplier<FaultyCardMode> supplier) {
        REGISTRY.put(key, supplier);
        CYCLE_ORDER.add(key);
    }

    public static void register(String namespace, String path, Supplier<FaultyCardMode> supplier) {
        FaultyCardMode.register(new ResourceLocation(namespace, path), supplier);
    }

    public abstract ResourceLocation getType();

    public abstract InteractionResult onItemUseFirst(ItemStack var1, UseOnContext var2);

    public InteractionResultHolder<ItemStack> onItemUse(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public CompoundTag save(CompoundTag tag) {
        CompoundTag data = new CompoundTag();
        data.m_128359_(MODE_TYPE, this.getType().toString());
        tag.m_128365_(FAULTY_DATA, (Tag)data);
        return data;
    }

    protected FaultyCardMode load(CompoundTag tag) {
        return this;
    }

    protected abstract Component getName();

    public abstract int getTintColor();

    public static FaultyCardMode cycleMode(FaultyCardMode mode, boolean cycleForward) {
        ResourceLocation next;
        ResourceLocation current = mode.getType();
        ResourceLocation resourceLocation = next = cycleForward ? CYCLE_ORDER.higher(current) : CYCLE_ORDER.lower(current);
        if (next == null) {
            next = cycleForward ? (ResourceLocation)CYCLE_ORDER.first() : (ResourceLocation)CYCLE_ORDER.last();
        }
        return REGISTRY.get(next).get();
    }

    static {
        FaultyCardMode.register(new AoEPaste().getType(), AoEPaste::new);
        FaultyCardMode.register(new GlobalPaste().getType(), GlobalPaste::new);
        FaultyCardMode.register(new Incrementing().getType(), Incrementing::new);
    }
}

