/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.gui;

import com.ibm.icu.text.DecimalFormat;
import giselle.jei_mekanism_multiblocks.client.TooltipHelper;
import giselle.jei_mekanism_multiblocks.client.gui.ButtonWidget;
import giselle.jei_mekanism_multiblocks.client.gui.ContainerWidget;
import giselle.jei_mekanism_multiblocks.client.gui.SliderWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class SliderWithButtons<SLIDER extends SliderWidget>
extends ContainerWidget {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("+#;-#");
    public static int SHIFT_DELTA = 5;
    public static int NORMAL_DELTA = 1;
    private String translationKey;
    private final SLIDER slider;
    private final Map<ButtonWidget, Integer> button2DirectionMap;
    private final ButtonWidget minusButton;
    private final ButtonWidget plusButton;

    public SliderWithButtons(int pX, int pY, int pWidth, int pHeight, String translationKey, SLIDER slider) {
        super(pX, pY, pWidth, pHeight);
        this.translationKey = translationKey;
        this.slider = slider;
        this.addChild(this.slider);
        this.button2DirectionMap = new HashMap<ButtonWidget, Integer>();
        this.minusButton = this.createAdjustButton((Component)Component.m_237113_((String)"-"), -1);
        this.plusButton = this.createAdjustButton((Component)Component.m_237113_((String)"+"), 1);
        this.updateMessage();
        this.onHeightChanged();
    }

    public void m_257544_(@Nullable Tooltip pTooltip) {
        this.getSlider().m_257544_(pTooltip);
        for (Map.Entry<ButtonWidget, Integer> entry : this.button2DirectionMap.entrySet()) {
            this.updateAdjustButtonTooltip(entry.getKey(), entry.getValue());
        }
    }

    protected abstract String getDisplayValue();

    protected void updateMessage() {
        this.getSlider().m_93666_((Component)Component.m_237110_((String)this.translationKey, (Object[])new Object[]{this.getDisplayValue()}));
    }

    private ButtonWidget createAdjustButton(Component message, int direction) {
        ButtonWidget button = new ButtonWidget(0, 0, 0, 0, message);
        this.updateAdjustButtonTooltip(button, direction);
        button.addPressHandler(b -> {
            int delta = Screen.m_96638_() ? SHIFT_DELTA : NORMAL_DELTA;
            this.onAdjustButtonPress(delta * direction);
        });
        this.button2DirectionMap.put(button, direction);
        this.addChild(button);
        return button;
    }

    private void updateAdjustButtonTooltip(ButtonWidget button, int direction) {
        ArrayList<Component> elements = new ArrayList<Component>();
        elements.add((Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.click_normal", (Object[])new Object[]{DECIMAL_FORMAT.format((long)(direction * NORMAL_DELTA))}));
        elements.add((Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.click_shift", (Object[])new Object[]{DECIMAL_FORMAT.format((long)(direction * SHIFT_DELTA))}));
        button.m_257544_(TooltipHelper.mergeMessage(this.getSlider().m_278622_(), elements));
    }

    protected void onAdjustButtonPress(int delta) {
    }

    @Override
    protected void onWidthChanged() {
        super.onWidthChanged();
        this.updateChildrenBounds();
    }

    @Override
    protected void onHeightChanged() {
        super.onHeightChanged();
        int height = this.m_93694_();
        SLIDER slider = this.getSlider();
        slider.setHeight(height);
        ButtonWidget minusButton = this.getMinusButton();
        minusButton.m_93674_(height);
        minusButton.setHeight(height);
        ButtonWidget plusButton = this.getPlusButton();
        plusButton.m_93674_(height);
        plusButton.setHeight(height);
        this.updateChildrenBounds();
    }

    protected void updateChildrenBounds() {
        ButtonWidget plusButton = this.getPlusButton();
        plusButton.m_252865_(this.m_5711_() - plusButton.m_5711_());
        plusButton.m_253211_(0);
        ButtonWidget minusButton = this.getMinusButton();
        minusButton.m_252865_(plusButton.m_252754_() - minusButton.m_5711_());
        minusButton.m_253211_(plusButton.m_252907_());
        SLIDER slider = this.getSlider();
        slider.m_252865_(0);
        slider.m_253211_(minusButton.m_252907_());
        slider.m_93674_(minusButton.m_252754_() - slider.m_252754_());
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        this.updateMessage();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public ButtonWidget getMinusButton() {
        return this.minusButton;
    }

    public ButtonWidget getPlusButton() {
        return this.plusButton;
    }

    public SLIDER getSlider() {
        return this.slider;
    }
}

