/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collection;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.text.EnumColor;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.integration.computer.BaseComputerHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.ComputerMethodFactory;
import mekanism.common.integration.computer.MethodData;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.MethodFactory;
import mekanism.common.tile.TileEntityTeleporter;
import net.minecraft.world.item.ItemStack;

@MethodFactory(target=TileEntityTeleporter.class)
public class TileEntityTeleporter$ComputerHandler
extends ComputerMethodFactory<TileEntityTeleporter> {
    private final String[] NAMES_color = new String[]{"color"};
    private final String[] NAMES_name = new String[]{"name"};
    private final Class[] TYPES_473e3684 = new Class[]{String.class};
    private final Class[] TYPES_88e2323f = new Class[]{EnumColor.class};

    public TileEntityTeleporter$ComputerHandler() {
        this.register(MethodData.builder("getEnergyItem", TileEntityTeleporter$ComputerHandler::energySlot$getEnergyItem).returnType(ItemStack.class).methodDescription("Get the contents of the energy slot."));
        this.register(MethodData.builder("getFrequencies", TileEntityTeleporter$ComputerHandler::getFrequencies_0).returnType(Collection.class).returnExtra(TeleporterFrequency.class).methodDescription("Lists public frequencies"));
        this.register(MethodData.builder("hasFrequency", TileEntityTeleporter$ComputerHandler::hasFrequency_0).returnType(Boolean.TYPE));
        this.register(MethodData.builder("getFrequency", TileEntityTeleporter$ComputerHandler::getFrequency_0).returnType(TeleporterFrequency.class).methodDescription("Requires a frequency to be selected"));
        this.register(MethodData.builder("setFrequency", TileEntityTeleporter$ComputerHandler::setFrequency_1).methodDescription("Requires a public frequency to exist").requiresPublicSecurity().arguments(this.NAMES_name, this.TYPES_473e3684));
        this.register(MethodData.builder("createFrequency", TileEntityTeleporter$ComputerHandler::createFrequency_1).methodDescription("Requires frequency to not already exist and for it to be public so that it can make it as the player who owns the block. Also sets the frequency after creation").requiresPublicSecurity().arguments(this.NAMES_name, this.TYPES_473e3684));
        this.register(MethodData.builder("getFrequencyColor", TileEntityTeleporter$ComputerHandler::getFrequencyColor_0).returnType(EnumColor.class).methodDescription("Requires a frequency to be selected"));
        this.register(MethodData.builder("setFrequencyColor", TileEntityTeleporter$ComputerHandler::setFrequencyColor_1).methodDescription("Requires a frequency to be selected").requiresPublicSecurity().arguments(this.NAMES_color, this.TYPES_88e2323f));
        this.register(MethodData.builder("incrementFrequencyColor", TileEntityTeleporter$ComputerHandler::incrementFrequencyColor_0).methodDescription("Requires a frequency to be selected").requiresPublicSecurity());
        this.register(MethodData.builder("decrementFrequencyColor", TileEntityTeleporter$ComputerHandler::decrementFrequencyColor_0).methodDescription("Requires a frequency to be selected").requiresPublicSecurity());
        this.register(MethodData.builder("getActiveTeleporters", TileEntityTeleporter$ComputerHandler::getActiveTeleporters_0).returnType(Set.class).returnExtra(Coord4D.class).methodDescription("Requires a frequency to be selected"));
        this.register(MethodData.builder("getStatus", TileEntityTeleporter$ComputerHandler::getStatus_0).returnType(String.class));
    }

    public static Object energySlot$getEnergyItem(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.getStack(subject.energySlot));
    }

    public static Object getFrequencies_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getFrequencies(), helper::convert);
    }

    public static Object hasFrequency_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.hasFrequency());
    }

    public static Object getFrequency_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getFrequency());
    }

    public static Object setFrequency_1(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.setFrequency(helper.getString(0));
        return helper.voidResult();
    }

    public static Object createFrequency_1(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.createFrequency(helper.getString(0));
        return helper.voidResult();
    }

    public static Object getFrequencyColor_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getFrequencyColor());
    }

    public static Object setFrequencyColor_1(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.setFrequencyColor(helper.getEnum(0, EnumColor.class));
        return helper.voidResult();
    }

    public static Object incrementFrequencyColor_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.incrementFrequencyColor();
        return helper.voidResult();
    }

    public static Object decrementFrequencyColor_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        subject.decrementFrequencyColor();
        return helper.voidResult();
    }

    public static Object getActiveTeleporters_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getActiveTeleporters(), helper::convert);
    }

    public static Object getStatus_0(TileEntityTeleporter subject, BaseComputerHelper helper) throws ComputerException {
        return helper.convert(subject.getStatus());
    }
}

