/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnergyRecipeData
implements RecipeUpgradeData<EnergyRecipeData> {
    private final List<IEnergyContainer> energyContainers;

    EnergyRecipeData(ListTag containers) {
        int count = DataHandlerUtils.getMaxId(containers, "Container");
        this.energyContainers = new ArrayList<IEnergyContainer>(count);
        for (int i = 0; i < count; ++i) {
            this.energyContainers.add(BasicEnergyContainer.create(FloatingLong.MAX_VALUE, null));
        }
        DataHandlerUtils.readContainers(this.energyContainers, containers);
    }

    private EnergyRecipeData(List<IEnergyContainer> energyContainers) {
        this.energyContainers = energyContainers;
    }

    @Override
    @Nullable
    public EnergyRecipeData merge(EnergyRecipeData other) {
        ArrayList<IEnergyContainer> allContainers = new ArrayList<IEnergyContainer>(this.energyContainers);
        allContainers.addAll(other.energyContainers);
        return new EnergyRecipeData(allContainers);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.energyContainers.isEmpty()) {
            return true;
        }
        Item item = stack.m_41720_();
        Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY).resolve();
        final ArrayList<BasicEnergyContainer> energyContainers = new ArrayList<BasicEnergyContainer>();
        if (capability.isPresent()) {
            IStrictEnergyHandler energyHandler = (IStrictEnergyHandler)capability.get();
            for (container = 0; container < energyHandler.getEnergyContainerCount(); ++container) {
                energyContainers.add(BasicEnergyContainer.create(energyHandler.getMaxEnergy(container), null));
            }
        } else if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            TileEntityMekanism tile = this.getTileFromBlock(blockItem.m_40614_());
            if (tile == null || !tile.handles(SubstanceType.ENERGY)) {
                return false;
            }
            for (container = 0; container < tile.getEnergyContainerCount(); ++container) {
                energyContainers.add(BasicEnergyContainer.create(tile.getMaxEnergy(container), null));
            }
        } else {
            return false;
        }
        if (energyContainers.isEmpty()) {
            return true;
        }
        IMekanismStrictEnergyHandler outputHandler = new IMekanismStrictEnergyHandler(){

            @Override
            @NotNull
            public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
                return energyContainers;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IEnergyContainer energyContainer : this.energyContainers) {
            if (energyContainer.isEmpty()) continue;
            hasData = true;
            if (outputHandler.insertEnergy(energyContainer.getEnergy(), Action.EXECUTE).isZero()) continue;
            break;
        }
        if (hasData) {
            ItemDataUtils.writeContainers(stack, "EnergyContainers", energyContainers);
        }
        return true;
    }
}

