/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ElectrolysisRecipeSerializer<RECIPE extends ElectrolysisRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ElectrolysisRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        FluidStackIngredient inputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)input);
        GasStack leftGasOutput = SerializerHelper.getGasStack(json, "leftGasOutput");
        GasStack rightGasOutput = SerializerHelper.getGasStack(json, "rightGasOutput");
        FloatingLong energyMultiplier = FloatingLong.ONE;
        if (json.has("energyMultiplier") && (energyMultiplier = SerializerHelper.getFloatingLong(json, "energyMultiplier")).smallerThan(FloatingLong.ONE)) {
            throw new JsonSyntaxException("Expected energyMultiplier to be at least one.");
        }
        if (leftGasOutput.isEmpty() || rightGasOutput.isEmpty()) {
            throw new JsonSyntaxException("Electrolysis recipe outputs must not be empty.");
        }
        return this.factory.create(recipeId, inputIngredient, energyMultiplier, leftGasOutput, rightGasOutput);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            FluidStackIngredient input = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
            FloatingLong energyMultiplier = FloatingLong.readFromBuffer(buffer);
            GasStack leftGasOutput = GasStack.readFromPacket(buffer);
            GasStack rightGasOutput = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, input, energyMultiplier, leftGasOutput, rightGasOutput);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading electrolysis recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((ElectrolysisRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing electrolysis recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends ElectrolysisRecipe> {
        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, FloatingLong var3, GasStack var4, GasStack var5);
    }
}

