/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.model;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class FramedDrawerModelData
implements INBTSerializable<CompoundTag> {
    public static final ModelProperty<FramedDrawerModelData> FRAMED_PROPERTY = new ModelProperty();
    private Map<String, Item> design;
    private String code = "";

    public FramedDrawerModelData(Map<String, Item> design) {
        this.design = design;
        this.generateCode();
    }

    public Map<String, Item> getDesign() {
        return this.design;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        this.design.forEach((s, item) -> compoundTag.m_128359_(s, ForgeRegistries.ITEMS.getKey(item).toString()));
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.design = new HashMap<String, Item>();
        for (String allKey : nbt.m_128431_()) {
            this.design.put(allKey, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_(allKey))));
        }
        this.generateCode();
    }

    private void generateCode() {
        this.code = "";
        this.design.forEach((s, item) -> {
            this.code = this.code + s + ForgeRegistries.ITEMS.getKey(item).toString();
        });
    }

    public String getCode() {
        return this.code;
    }
}

