/*
 * Decompiled with CFR 0.152.
 */
package dev.stevendoesstuffs.refinedcrafterproxy;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigSpec;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u0013\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/stevendoesstuffs/refinedcrafterproxy/Config;", "", "builder", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "tiers", "Lnet/minecraftforge/common/ForgeConfigSpec$ConfigValue;", "Lcom/electronwill/nightconfig/core/Config;", "getCrafterEnergyUsage", "", "tier", "", "getCustomTiers", "", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "getMaximumSuccessfulCraftingUpdates", "upgrades", "getPatternsEnergyUsage", "getTier", "getUpdateInterval", "getUpgradesEnergyMultiplier", "", "Companion", "refinedcrafterproxy"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ndev/stevendoesstuffs/refinedcrafterproxy/Config\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForgeConfigSpec.ConfigValue<com.electronwill.nightconfig.core.Config> tiers;
    @NotNull
    private static final String DEFAULT_TIER = "default";
    @NotNull
    private static final String TIERS = "tiers";
    @NotNull
    private static final String DISPLAY_NAME = "displayName";
    @NotNull
    private static final String CRAFTER_ENERGY_USAGE = "crafterEnergyUsage";
    @NotNull
    private static final String PATTERNS_ENERGY_USAGE = "patternsEnergyUsage";
    @NotNull
    private static final String UPGRADES_ENERGY_MULTIPLIER = "upgradesEnergyMultiplier";
    @NotNull
    private static final String UPDATE_INTERVALS = "updateIntervals";
    @NotNull
    private static final String MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES = "maximumSuccessfulCraftingUpdates";
    @NotNull
    private static final Config CONFIG;
    @NotNull
    private static final ForgeConfigSpec CONFIG_SPEC;

    public Config(@NotNull ForgeConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String[] stringArray = new String[]{"Note: for technical reasons, if anything in the tiers section is invalid, it will reset the entire section.", "Luckily, forge backs up invalid configs in .toml.bak files, so look there if everything got reset."};
        builder.comment(stringArray);
        ForgeConfigSpec.ConfigValue configValue = builder.define(TIERS, Config::_init_$lambda$0, Config::_init_$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)configValue, (String)"builder.define(\n        \u2026   true\n                }");
        this.tiers = configValue;
    }

    @NotNull
    public final Set<String> getCustomTiers() {
        HashSet set = new HashSet(((com.electronwill.nightconfig.core.Config)this.tiers.get()).valueMap().keySet());
        set.remove(DEFAULT_TIER);
        return set;
    }

    private final com.electronwill.nightconfig.core.Config getTier(String tier) {
        com.electronwill.nightconfig.core.Config config;
        com.electronwill.nightconfig.core.Config config2 = (com.electronwill.nightconfig.core.Config)this.tiers.get();
        String string = tier;
        if (string == null) {
            string = DEFAULT_TIER;
        }
        if ((config = (com.electronwill.nightconfig.core.Config)config2.get(string)) == null) {
            Object object = ((com.electronwill.nightconfig.core.Config)this.tiers.get()).get(DEFAULT_TIER);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tiers.get().get(DEFAULT_TIER)");
            config = (com.electronwill.nightconfig.core.Config)object;
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Component getDisplayName(@Nullable String tier) {
        Component component;
        if (tier == null) return null;
        if (Intrinsics.areEqual((Object)tier, (Object)DEFAULT_TIER)) {
            return null;
        }
        com.electronwill.nightconfig.core.Config config = (com.electronwill.nightconfig.core.Config)((com.electronwill.nightconfig.core.Config)this.tiers.get()).get(tier);
        if (config != null) {
            com.electronwill.nightconfig.core.Config it = config;
            boolean bl = false;
            MutableComponent mutableComponent = Component.m_237113_((String)((String)it.get(DISPLAY_NAME)));
            config = mutableComponent;
            if (mutableComponent != null) {
                component = (Component)config;
                return component;
            }
        }
        component = (Component)Component.m_237113_((String)"ERROR").m_130940_(ChatFormatting.RED);
        return component;
    }

    public final int getCrafterEnergyUsage(@Nullable String tier) {
        Object object = this.getTier(tier).get(CRAFTER_ENERGY_USAGE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTier(tier).get(CRAFTER_ENERGY_USAGE)");
        return ((Number)object).intValue();
    }

    public final int getPatternsEnergyUsage(@Nullable String tier) {
        Object object = this.getTier(tier).get(PATTERNS_ENERGY_USAGE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTier(tier).get(PATTERNS_ENERGY_USAGE)");
        return ((Number)object).intValue();
    }

    public final double getUpgradesEnergyMultiplier(@Nullable String tier) {
        Object object = this.getTier(tier).get(UPGRADES_ENERGY_MULTIPLIER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTier(tier).get(UPGRADES_ENERGY_MULTIPLIER)");
        return ((Number)object).doubleValue();
    }

    public final int getUpdateInterval(@Nullable String tier, int upgrades) {
        return ((Number)((List)this.getTier(tier).get(UPDATE_INTERVALS)).get(RangesKt.coerceIn((int)upgrades, (int)0, (int)4))).intValue();
    }

    public final int getMaximumSuccessfulCraftingUpdates(@Nullable String tier, int upgrades) {
        return ((Number)((List)this.getTier(tier).get(MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES)).get(RangesKt.coerceIn((int)upgrades, (int)0, (int)4))).intValue();
    }

    private static final com.electronwill.nightconfig.core.Config _init_$lambda$0() {
        CommentedConfig defaultTier = CommentedConfig.inMemory();
        defaultTier.setComment(DISPLAY_NAME, "The display name of the tier. \nIf nonempty, the name of the block will be formatted as `Crafter Proxy [{displayName}]`.");
        defaultTier.add(DISPLAY_NAME, (Object)"");
        defaultTier.setComment(CRAFTER_ENERGY_USAGE, "The energy used for the crafter. \nMust be an integer >= 0.");
        defaultTier.add(CRAFTER_ENERGY_USAGE, (Object)4);
        defaultTier.setComment(PATTERNS_ENERGY_USAGE, "The energy used for every pattern in the crafter. \nMust be an integer >= 0.");
        defaultTier.add(PATTERNS_ENERGY_USAGE, (Object)1);
        defaultTier.setComment(UPGRADES_ENERGY_MULTIPLIER, "The multiplier for the energy usage of the upgrades in the crafter.\nThis does *not* multiply the total energy usage, only the portion used by upgrades.\nSee refinedstorage-server.toml#upgrades for the energy usage of specific upgrades.\nMust be a float >= 0.");
        defaultTier.add(UPGRADES_ENERGY_MULTIPLIER, (Object)1.0);
        defaultTier.setComment(UPDATE_INTERVALS, "The update interval of the crafter, \nwhere the (zero-indexed) index in the list is the number of speed upgrades.\nMust be a list of integers of length 5 with elements > 0.");
        Object[] objectArray = new Integer[]{10, 8, 6, 4, 2};
        defaultTier.add(UPDATE_INTERVALS, (Object)CollectionsKt.listOf((Object[])objectArray));
        defaultTier.setComment(MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES, "The maximum number of successful crafting updates per crafter update, \nwhere the (zero-indexed) index in the list is the number of speed upgrades.\nMust be a list of integers of length 5 with elements > 0.");
        objectArray = new Integer[]{1, 2, 3, 4, 5};
        defaultTier.add(MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES, (Object)CollectionsKt.listOf((Object[])objectArray));
        CommentedConfig config = CommentedConfig.inMemory();
        config.setComment(DEFAULT_TIER, "Special tier for crafters without a tier tag.\nFor values other than `default`, this is the value that appears within the tier tag.");
        config.add(DEFAULT_TIER, (Object)defaultTier);
        return (com.electronwill.nightconfig.core.Config)config;
    }

    private static final boolean lambda$3$lambda$1(Object x) {
        return !(x instanceof Integer) ? false : ((Number)x).intValue() > 0;
    }

    private static final boolean lambda$3$lambda$2(Object x) {
        return !(x instanceof Integer) ? false : ((Number)x).intValue() > 0;
    }

    private static final boolean _init_$lambda$3(Object it) {
        if (!(it instanceof com.electronwill.nightconfig.core.Config) || !((com.electronwill.nightconfig.core.Config)it).contains(DEFAULT_TIER)) {
            return false;
        }
        ConfigSpec spec = new ConfigSpec();
        spec.define(DISPLAY_NAME, (Object)"");
        spec.defineInRange(CRAFTER_ENERGY_USAGE, (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
        spec.defineInRange(PATTERNS_ENERGY_USAGE, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
        spec.defineInRange(UPGRADES_ENERGY_MULTIPLIER, (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.147483647E9));
        Object object = new Integer[]{10, 8, 6, 4, 2};
        spec.defineList(UPDATE_INTERVALS, CollectionsKt.listOf((Object[])object), Config::lambda$3$lambda$1);
        object = new Integer[]{1, 2, 3, 4, 5};
        spec.defineList(MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES, CollectionsKt.listOf((Object[])object), Config::lambda$3$lambda$2);
        Map map = ((com.electronwill.nightconfig.core.Config)it).valueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.valueMap()");
        for (Map.Entry entry : map.entrySet()) {
            Object config = entry.getValue();
            System.out.println(config);
            if (!(config instanceof com.electronwill.nightconfig.core.Config)) {
                return false;
            }
            if (!spec.isCorrect((com.electronwill.nightconfig.core.Config)config)) {
                return false;
            }
            if (((List)((com.electronwill.nightconfig.core.Config)config).get(UPDATE_INTERVALS)).size() == 5 && ((List)((com.electronwill.nightconfig.core.Config)config).get(MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES)).size() == 5) continue;
            return false;
        }
        return true;
    }

    private static final Config _init_$lambda$5(ForgeConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return new Config(builder);
    }

    @NotNull
    public static final Config getCONFIG() {
        return Companion.getCONFIG();
    }

    @NotNull
    public static final ForgeConfigSpec getCONFIG_SPEC() {
        return Companion.getCONFIG_SPEC();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Config::_init_$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"configure { builder: For\u2026er)\n                    }");
        Config config = (Config)((Map.Entry)pair).getKey();
        ForgeConfigSpec configSpec = (ForgeConfigSpec)((Map.Entry)pair).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
        CONFIG = config;
        Intrinsics.checkNotNullExpressionValue((Object)configSpec, (String)"configSpec");
        CONFIG_SPEC = configSpec;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/stevendoesstuffs/refinedcrafterproxy/Config$Companion;", "", "()V", "CONFIG", "Ldev/stevendoesstuffs/refinedcrafterproxy/Config;", "getCONFIG$annotations", "getCONFIG", "()Ldev/stevendoesstuffs/refinedcrafterproxy/Config;", "CONFIG_SPEC", "Lnet/minecraftforge/common/ForgeConfigSpec;", "getCONFIG_SPEC$annotations", "getCONFIG_SPEC", "()Lnet/minecraftforge/common/ForgeConfigSpec;", "CRAFTER_ENERGY_USAGE", "", "DEFAULT_TIER", "DISPLAY_NAME", "MAXIMUM_SUCCESSFUL_CRAFTING_UPDATES", "PATTERNS_ENERGY_USAGE", "TIERS", "UPDATE_INTERVALS", "UPGRADES_ENERGY_MULTIPLIER", "refinedcrafterproxy"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Config getCONFIG() {
            return CONFIG;
        }

        @JvmStatic
        public static /* synthetic */ void getCONFIG$annotations() {
        }

        @NotNull
        public final ForgeConfigSpec getCONFIG_SPEC() {
            return CONFIG_SPEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCONFIG_SPEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

