/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.dimension;

import commoble.hyperbox.blocks.ApertureBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlockEntity;
import commoble.hyperbox.dimension.HyperboxChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;

public class HyperboxWorldData
extends SavedData {
    public static final String DATA_KEY = "hyperbox";
    public static final String PARENT_WORLD_KEY = "parent_world";
    public static final String PARENT_POS_KEY = "parent_pos";
    public static final BlockPos DEFAULT_PARENT_POS = new BlockPos(0, 65, 0);
    private ResourceKey<Level> parentWorld = Level.f_46428_;
    private BlockPos parentPos = DEFAULT_PARENT_POS;

    public ResourceKey<Level> getParentWorld() {
        return this.parentWorld;
    }

    public BlockPos getParentPos() {
        return this.parentPos;
    }

    public static HyperboxWorldData getOrCreate(ServerLevel world) {
        return (HyperboxWorldData)world.m_8895_().m_164861_(HyperboxWorldData::load, HyperboxWorldData::create, DATA_KEY);
    }

    public static HyperboxWorldData load(CompoundTag nbt) {
        ResourceKey parentWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_(PARENT_WORLD_KEY)));
        BlockPos parentPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(PARENT_POS_KEY));
        return new HyperboxWorldData((ResourceKey<Level>)parentWorld, parentPos);
    }

    public static HyperboxWorldData create() {
        return new HyperboxWorldData((ResourceKey<Level>)Level.f_46428_, DEFAULT_PARENT_POS);
    }

    protected HyperboxWorldData(ResourceKey<Level> parentWorld, BlockPos parentPos) {
        this.parentWorld = parentWorld;
        this.parentPos = parentPos;
    }

    public void setWorldPos(MinecraftServer server, ServerLevel thisWorld, ResourceKey<Level> thisWorldKey, ResourceKey<Level> parentWorldKey, BlockPos parentPos, int color) {
        ResourceKey<Level> oldParentWorld = this.parentWorld;
        BlockPos oldParentPos = this.parentPos;
        if (!oldParentWorld.equals(parentWorldKey) || !oldParentPos.equals((Object)parentPos)) {
            HyperboxWorldData.clearOldParent(server, thisWorldKey, oldParentWorld, oldParentPos);
        }
        this.parentWorld = parentWorldKey;
        this.parentPos = parentPos;
        for (Direction dir : Direction.values()) {
            BlockPos aperturePos = HyperboxChunkGenerator.CENTER.m_5484_(dir, 7);
            BlockEntity blockEntity = thisWorld.m_7702_(aperturePos);
            if (!(blockEntity instanceof ApertureBlockEntity)) continue;
            ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
            aperture.setColor(color);
        }
        this.m_77762_();
    }

    protected static void clearOldParent(MinecraftServer server, ResourceKey<Level> thisWorldKey, ResourceKey<Level> oldParentKey, BlockPos oldParentPos) {
        BlockEntity blockEntity;
        ServerLevel oldParentWorld = server.m_129880_(oldParentKey);
        if (oldParentWorld != null && (blockEntity = oldParentWorld.m_7702_(oldParentPos)) instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            if (hyperbox.getLevelKey().filter(arg_0 -> thisWorldKey.equals(arg_0)).isPresent()) {
                oldParentWorld.m_7471_(oldParentPos, true);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128359_(PARENT_WORLD_KEY, this.parentWorld.m_135782_().toString());
        compound.m_128365_(PARENT_POS_KEY, (Tag)NbtUtils.m_129224_((BlockPos)this.parentPos));
        return compound;
    }
}

