/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.json.BaseSerializer;
import wallywhip.resourcechickens.json.ChickenData;

public class ChickenDataSerializer {
    public static final BaseSerializer<ChickenData> DATA = new BaseSerializer<ChickenData>(){

        @Override
        public ChickenData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray array;
            JsonObject obj = json.getAsJsonObject();
            ChickenData chickenData = new ChickenData();
            JsonElement element = obj.get("displayName");
            if (element != null) {
                chickenData.displayName = Component.m_237113_((String)element.getAsString());
            }
            if ((element = obj.get("eggLayTime")) != null) {
                chickenData.eggLayTime = element.getAsInt();
            }
            if ((element = obj.get("canBreed")) != null) {
                chickenData.canBreed = element.getAsBoolean();
            }
            if ((element = obj.get("dropItem")) != null) {
                String st;
                chickenData.dropItem = element.getAsString();
                if (chickenData.dropItem.startsWith("items:")) {
                    chickenData.dropItem = "tag:" + chickenData.dropItem.substring(6);
                }
                if ((element = obj.get("dropItemNBT")) != null && !(st = element.getAsString()).isEmpty()) {
                    try {
                        chickenData.dropItemNBT = TagParser.m_129359_((String)st);
                    }
                    catch (CommandSyntaxException e) {
                        chickenData.dropItemNBT = null;
                    }
                }
            }
            if ((element = obj.get("feedItem")) != null) {
                chickenData.feedItem = element.getAsString();
            }
            if ((element = obj.get("baseHealth")) != null) {
                chickenData.baseHealth = element.getAsDouble();
            }
            if ((element = obj.get("baseSpeed")) != null) {
                chickenData.baseSpeed = element.getAsDouble();
            }
            if ((element = obj.get("isFireImmune")) != null) {
                chickenData.isFireImmune = element.getAsBoolean();
            }
            if ((element = obj.get("conversion")) != null) {
                chickenData.conversionRequired = element.getAsInt();
            }
            if ((element = obj.get("eggColorForeground")) != null) {
                chickenData.eggPrimaryColor = Integer.parseInt(element.getAsString());
            }
            if ((element = obj.get("eggColorBackground")) != null) {
                chickenData.eggSecondaryColor = Integer.parseInt(element.getAsString());
            }
            if ((element = obj.get("hasTrait")) != null) {
                chickenData.hasTrait = element.getAsInt();
            }
            if ((element = obj.get("spawnNaturally")) != null) {
                chickenData.spawnNaturally = element.getAsBoolean();
            }
            if ((element = obj.get("spawnType")) != null) {
                chickenData.spawnType = MobCategory.values()[element.getAsInt()];
            }
            if ((element = obj.get("spawnLight")) != null) {
                chickenData.spawnLight = element.getAsInt();
            }
            if ((array = obj.getAsJsonArray("spawnBlocks")) != null) {
                chickenData.spawnBlocks = new ArrayList<Block>();
                array.forEach(blck -> {
                    ResourceLocation res = new ResourceLocation(blck.getAsString());
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(res);
                    if (block == null) {
                        if (ModList.get().isLoaded(res.m_135827_())) {
                            ResourceChickens.LOGGER.debug("SpawnBlocks Not Found {}", (Object)res);
                        }
                    } else {
                        chickenData.spawnBlocks.add(block);
                    }
                });
            }
            if ((element = obj.get("parentA")) != null) {
                chickenData.parentA = element.getAsString();
            }
            if ((element = obj.get("parentB")) != null) {
                chickenData.parentB = element.getAsString();
            }
            if ((element = obj.get("enabled")) != null) {
                chickenData.enabled = element.getAsBoolean();
            }
            return chickenData;
        }

        @Override
        public JsonElement serialize(ChickenData src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonObject();
        }

        @Override
        public Type getType() {
            return ChickenData.class;
        }
    };

    public static Gson initGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(DATA.getType(), DATA);
        return gson.create();
    }
}

