/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class LiquidEgg
extends EggItem {
    public final Fluid fluidType;

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        FluidHandlerItemStack fluidHandlerItemStack = new FluidHandlerItemStack(stack, 1000){

            @Nonnull
            public ItemStack getContainer() {
                return ItemStack.f_41583_;
            }

            @Nonnull
            public FluidStack getFluid() {
                return new FluidStack(LiquidEgg.this.fluidType, 1000);
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluid) {
                return false;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (maxDrain < 1000) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }
        };
        fluidHandlerItemStack.fill(new FluidStack(this.fluidType, 1000), IFluidHandler.FluidAction.EXECUTE);
        return fluidHandlerItemStack;
    }

    public LiquidEgg(Fluid fluid) {
        super(new Item.Properties().m_41487_(16));
        this.fluidType = fluid;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        BlockHitResult blockHitResult;
        ItemStack itemStack = playerIn.m_21120_(handIn);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)itemStack, (HitResult)(blockHitResult = LiquidEgg.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = blockHitResult.m_82425_();
            Direction direction = blockHitResult.m_82434_();
            BlockPos blockPos1 = blockPos.m_121945_(direction);
            if (worldIn.m_7966_(playerIn, blockPos) && playerIn.m_36204_(blockPos1, direction, itemStack)) {
                BlockPos blockPos2;
                BlockState blockState = worldIn.m_8055_(blockPos);
                BlockPos blockPos3 = blockPos2 = this.canBlockContainFluid(worldIn, blockPos, blockState) ? blockPos : blockPos1;
                if (blockState.m_60734_() instanceof AbstractCauldronBlock) {
                    if (this.fluidType == Fluids.f_76193_) {
                        worldIn.m_46597_(blockPos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
                        if (!playerIn.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)worldIn.m_5776_());
                    }
                    if (this.fluidType == Fluids.f_76195_) {
                        worldIn.m_46597_(blockPos, Blocks.f_152477_.m_49966_());
                        if (!playerIn.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)worldIn.m_5776_());
                    }
                }
                if (this.emptyContents(playerIn, worldIn, blockPos2, blockHitResult, itemStack)) {
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)playerIn;
                        CriteriaTriggers.f_10591_.m_285767_(sp, blockPos2, itemStack);
                    }
                    if (!playerIn.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)worldIn.m_5776_());
                }
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public boolean emptyContents(@Nullable Player playerIn, Level worldIn, BlockPos blockPos, @Nullable BlockHitResult blockHitResult, @Nullable ItemStack container) {
        Fluid fluid = this.fluidType;
        if (fluid instanceof FlowingFluid) {
            LiquidBlockContainer liquid;
            LiquidBlockContainer liquid2;
            FlowingFluid flowingfluid = (FlowingFluid)fluid;
            BlockState blockState = worldIn.m_8055_(blockPos);
            Block $$7 = blockState.m_60734_();
            boolean $$8 = blockState.m_60722_(this.fluidType);
            boolean flag2 = blockState.m_60795_() || $$8 || $$7 instanceof LiquidBlockContainer && (liquid2 = (LiquidBlockContainer)$$7).m_6044_((BlockGetter)worldIn, blockPos, blockState, this.fluidType);
            boolean flag1 = flag2;
            Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
            if (!flag1) {
                return blockHitResult != null && this.emptyContents(playerIn, worldIn, blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()), null, container);
            }
            if (containedFluidStack.isPresent() && this.fluidType.getFluidType().isVaporizedOnPlacement(worldIn, blockPos, (FluidStack)containedFluidStack.get())) {
                this.fluidType.getFluidType().onVaporize(playerIn, worldIn, blockPos, (FluidStack)containedFluidStack.get());
                return true;
            }
            if (worldIn.m_6042_().f_63857_() && this.fluidType.m_205067_(FluidTags.f_13131_)) {
                int l = blockPos.m_123341_();
                int i = blockPos.m_123342_();
                int j = blockPos.m_123343_();
                worldIn.m_5594_(playerIn, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.8f);
                for (int k = 0; k < 8; ++k) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
                }
                return true;
            }
            if ($$7 instanceof LiquidBlockContainer && (liquid = (LiquidBlockContainer)$$7).m_6044_((BlockGetter)worldIn, blockPos, blockState, this.fluidType) && this.fluidType == Fluids.f_76193_) {
                liquid.m_7361_((LevelAccessor)worldIn, blockPos, blockState, flowingfluid.m_76068_(false));
                this.playEmptySound(playerIn, (LevelAccessor)worldIn, blockPos);
                return true;
            }
            if (!worldIn.f_46443_ && $$8 && !blockState.m_278721_()) {
                worldIn.m_46961_(blockPos, true);
            }
            if (!worldIn.m_7731_(blockPos, this.fluidType.m_76145_().m_76188_(), 11) && !blockState.m_60819_().m_76170_()) {
                return false;
            }
            this.playEmptySound(playerIn, (LevelAccessor)worldIn, blockPos);
            return true;
        }
        return false;
    }

    private boolean canBlockContainFluid(Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer liquid;
        Block block = state.m_60734_();
        return block instanceof LiquidBlockContainer && (liquid = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.fluidType);
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        SoundEvent emptySound = this.fluidType.getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
        if (emptySound == null) {
            emptySound = this.fluidType.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        level.m_5594_(player, pos, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
    }
}

