/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entities.ChickenCatcherItemRenderer;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.json.ChickenData;

public class ChickenCatcherItem
extends Item {
    private static final MutableComponent componentChicken = Component.m_237115_((String)"entity.minecraft.chicken");

    public ChickenCatcherItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ChickenCatcherItemRenderer.getInstance();
            }
        });
    }

    @Nullable
    public static String getTypeFromStack(ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41737_("entityCaptured");
        if (compound != null) {
            return compound.m_128461_("id");
        }
        return null;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        if (itemStack.m_41788_()) {
            return itemStack.m_41786_();
        }
        ChickenData chickenData = initChickenRegistry.getChickenDataFromEntityID(ChickenCatcherItem.getTypeFromStack(itemStack));
        return chickenData == null ? componentChicken : chickenData.displayName;
    }

    public void m_7373_(@NotNull ItemStack itemStack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, tooltip, tooltipFlag);
        CompoundTag compound = itemStack.m_41737_("entityCaptured");
        if (compound != null) {
            ChickenData conv;
            if (itemStack.m_41788_()) {
                tooltip.add((Component)Component.m_237113_((String)itemStack.m_41783_().m_128461_("entityDescription")));
            }
            if (compound.m_128471_("analyzed")) {
                if (((Boolean)ResourceChickens.CONFIGURATION.compactTips.get()).booleanValue()) {
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.compact", (Object[])new Object[]{compound.m_128451_("gain"), compound.m_128451_("growth"), compound.m_128451_("strength")}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.gain", (Object[])new Object[]{compound.m_128451_("gain")}).m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.growth", (Object[])new Object[]{compound.m_128451_("growth")}).m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.strength", (Object[])new Object[]{compound.m_128451_("strength")}).m_130940_(ChatFormatting.GRAY));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.anal_no").m_130940_(ChatFormatting.GRAY));
            }
            CompoundTag nbt = compound.m_128469_("Mutation");
            if (!nbt.m_128456_() && (conv = initChickenRegistry.getChickenDataFromName(nbt.m_128461_("type"))) != null) {
                tooltip.add((Component)Component.m_237110_((String)"tip.resourcechickens.conv", (Object[])new Object[]{conv.displayName}).m_130940_(ChatFormatting.GRAY));
            }
            if (compound.m_128451_("Age") < 0) {
                tooltip.add((Component)Component.m_237115_((String)"tip.resourcechickens.is_baby").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag compound = context.m_43722_().m_41737_("entityCaptured");
        if (compound != null) {
            LivingEntity bird;
            EntityType type;
            BlockEntity blockEntity;
            if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == initBlocks.NEST_BLOCK.get() && (blockEntity = context.m_43725_().m_7702_(context.m_8083_())) instanceof NestTileEntity) {
                ChickenData chickenData;
                NestTileEntity tile = (NestTileEntity)blockEntity;
                if (tile.entityCaptured == null && (chickenData = initChickenRegistry.getChickenDataFromEntityID(compound.m_128461_("id"))) != null) {
                    if (context.m_43722_().m_41788_()) {
                        compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)context.m_43722_().m_41786_()));
                    }
                    tile.entitySet(compound, context.m_43722_().m_41784_().m_128461_("entityDescription"), true);
                    context.m_43725_().m_5594_(null, context.m_8083_(), context.m_43725_().f_46441_.m_188499_() ? SoundEvents.f_11752_ : (chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!context.m_43725_().f_46443_) {
                        ((ServerLevel)context.m_43725_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)initBlocks.NEST_BLOCK.get()).m_49966_()), (double)context.m_8083_().m_123341_() + 0.5, (double)context.m_8083_().m_123342_() + 0.2, (double)context.m_8083_().m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                    }
                    if (context.m_43723_() != null) {
                        context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if ((type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(compound.m_128461_("id")))) != null && (bird = (LivingEntity)type.m_20615_(context.m_43725_())) != null) {
                BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
                bird.m_20258_(compound);
                bird.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                bird.m_21153_(compound.m_128457_("Health"));
                if (context.m_43722_().m_41788_()) {
                    bird.m_6593_(context.m_43722_().m_41786_());
                }
                context.m_43725_().m_7967_((Entity)bird);
                context.m_43725_().m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.PLAYERS, 1.0f, 1.0f);
                context.m_43725_().m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, pos);
                if (context.m_43723_() != null) {
                    context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
                }
                return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }
}

