/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.items;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.items.ChickenCatcherItem;
import wallywhip.resourcechickens.json.ChickenData;

public class ChickenCatcher
extends Item {
    public ChickenCatcher(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemStack, @NotNull Player player, @NotNull LivingEntity living, @NotNull InteractionHand hand) {
        return ChickenCatcher.interactLivingEntity(itemStack, player, living, false);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        return ChickenCatcher.use(level, player, hand, false);
    }

    @NotNull
    public static InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand, boolean isCreative) {
        ItemStack itemStack = player.m_21120_(hand);
        if (((Boolean)ResourceChickens.CONFIGURATION.basherOnlyCreative.get()).booleanValue() && !isCreative) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        int r = (Integer)ResourceChickens.CONFIGURATION.basherFindRange.get();
        if (r == 0) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        AABB aabb = new AABB(player.m_20183_()).m_82400_((double)r);
        List lst = null;
        if (player.m_21206_().m_41720_() instanceof ChickenCatcherItem) {
            ChickenData chickenData = initChickenRegistry.getChickenDataFromEntityID(ChickenCatcherItem.getTypeFromStack(player.m_21206_()));
            if (chickenData != null) {
                lst = level.m_6443_(ResourceChickenEntity.class, aabb, ent -> ent.m_6084_() && ent.chickenData.entityType.get() == chickenData.entityType.get());
            }
        } else {
            lst = level.m_6443_(ResourceChickenEntity.class, aabb, ent -> ent.m_6084_());
        }
        if (lst == null || lst.isEmpty()) {
            player.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
        } else {
            lst.forEach(rce -> rce.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 0, false, false)));
        }
        player.m_21011_(hand, level.f_46443_);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public static InteractionResult interactLivingEntity(@NotNull ItemStack itemStack, @NotNull Player player, @NotNull LivingEntity living, boolean isCreative) {
        ChickenData chickenData = null;
        boolean vanilla = false;
        if (living instanceof ResourceChickenEntity) {
            ResourceChickenEntity rce = (ResourceChickenEntity)living;
            chickenData = rce.chickenData;
        } else if (living instanceof Chicken) {
            chickenData = initChickenRegistry.getChickenDataFromName("chicken");
            vanilla = true;
        }
        if (chickenData != null) {
            Level level = living.m_9236_();
            ItemStack chickenItem = chickenData.hasTrait == 1 ? new ItemStack((ItemLike)initItems.CHICKEN_ITEM_DUCK.get()) : new ItemStack((ItemLike)initItems.CHICKEN_ITEM.get());
            CompoundTag compoundStack = chickenItem.m_41784_();
            CompoundTag compound = new CompoundTag();
            if (vanilla) {
                compound.m_128379_("analyzed", (Boolean)ResourceChickens.CONFIGURATION.analyseChickens.get() == false);
                compound.m_128405_("growth", 1);
                compound.m_128405_("gain", 1);
                compound.m_128405_("strength", 1);
            }
            if (isCreative) {
                compound.m_128405_("growth", 10);
                compound.m_128405_("gain", 10);
                compound.m_128405_("strength", 10);
                compound.m_128405_("EggLayTime", ResourceChickens.calcNewEggLayTime(living.m_217043_(), chickenData, 10));
            }
            compound.m_128359_("id", EntityType.m_20613_((EntityType)((EntityType)chickenData.entityType.get())).toString());
            living.m_20240_(compound);
            compound.m_128473_("Motion");
            compound.m_128473_("Rotation");
            compound.m_128473_("Pos");
            compound.m_128350_("maxHealth", living.m_21233_());
            compoundStack.m_128365_("entityCaptured", (Tag)compound);
            compoundStack.m_128359_("entityDescription", chickenData.displayName.getString());
            chickenItem.m_41751_(compoundStack);
            if (living.m_8077_()) {
                chickenItem.m_41714_(living.m_7770_());
            }
            if (!level.f_46443_) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, living.m_20185_(), living.m_20186_() + 0.5, living.m_20189_(), 20, 0.5, 1.0, 0.5, 0.0);
            }
            living.m_5496_(SoundEvents.f_11752_, 1.0f, 1.0f);
            ItemEntity itemEntity = new ItemEntity(level, living.m_20185_(), living.m_20186_(), living.m_20189_(), chickenItem);
            level.m_7967_((Entity)itemEntity);
            living.m_142687_(Entity.RemovalReason.DISCARDED);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

