/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.init;

import net.minecraftforge.common.ForgeConfigSpec;

public class initConfigs {
    public final ForgeConfigSpec COMMON;
    public final ForgeConfigSpec CLIENT;
    public ForgeConfigSpec.IntValue masterSwitchBreeding;
    public ForgeConfigSpec.IntValue allowDeathDropResource;
    public ForgeConfigSpec.BooleanValue allowConvertingVanilla;
    public ForgeConfigSpec.BooleanValue OverrideVanillaChickens;
    public ForgeConfigSpec.BooleanValue allowCrossBreeding;
    public ForgeConfigSpec.BooleanValue allowFakeplayerBreeding;
    public ForgeConfigSpec.BooleanValue allowFakeplayerLootDrops;
    public ForgeConfigSpec.BooleanValue allowShearingChickens;
    public ForgeConfigSpec.BooleanValue analyseChickens;
    public ForgeConfigSpec.IntValue energyEggMax;
    public ForgeConfigSpec.BooleanValue allowInWorldDrops;
    public ForgeConfigSpec.BooleanValue allowEventTextures;
    public ForgeConfigSpec.BooleanValue seededChamber;
    public ForgeConfigSpec.BooleanValue spurtingChamber;
    public ForgeConfigSpec.IntValue chickenDropFeathers;
    public ForgeConfigSpec.IntValue chickenDropPoop;
    public ForgeConfigSpec.IntValue basherFindRange;
    public ForgeConfigSpec.BooleanValue basherOnlyCreative;
    public ForgeConfigSpec.BooleanValue renderLabels;
    public ForgeConfigSpec.BooleanValue renderItems;
    public ForgeConfigSpec.BooleanValue renderJEIAnim;
    public ForgeConfigSpec.BooleanValue compactTips;
    public ForgeConfigSpec.BooleanValue healthHearts;

    public initConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Resource Chickens");
        this.masterSwitchBreeding = builder.comment("Allow resource chickens to breed.  0= no breeding, 1= all can breed, 2= set by individual configs.  Default: 2").defineInRange("masterSwitchBreeding", 2, 0, 2);
        this.allowCrossBreeding = builder.comment("Allow resource chickens to cross-breed.  false= Can only breed with same type.  Default: true").define("allowCrossBreeding", true);
        this.OverrideVanillaChickens = builder.comment(new String[]{"Override Vanilla chickens.  Default: true", "If Vanilla chickens are spawned via spawn egg, commands or spawners they will be converted to Resource vanilla chickens", "The Basher will convert Vanilla chickens to Resource vanilla chickens"}).define("OverrideVanillaChickens", true);
        this.allowConvertingVanilla = builder.comment("Allow conversion of plain Resource Chickens.  Default: true").define("allowConvertingVanilla", true);
        this.allowDeathDropResource = builder.comment("% Chance that resource is dropped upon death. 0= No resource dropped.  Default: 80").defineInRange("allowDeathDropResource", 80, 0, 100);
        this.allowInWorldDrops = builder.comment(new String[]{"Allow chickens to drop resources naturally in world.  Default: false", "Note: Many dropped items (Item Entities) will start to cause lag"}).define("allowInWorldDrops", false);
        this.seededChamber = builder.comment("Stasis Chamber requires seeds to function.  Default: true").define("seededChamber", true);
        this.spurtingChamber = builder.comment(new String[]{"Stasis Chamber drops items into the world when it is full.  Default: false", "Note: Many dropped items (Item Entities) will start to cause lag"}).define("spurtingChamber", false);
        this.chickenDropFeathers = builder.comment(new String[]{"% chance chickens/ducks drop feathers.  0= no feather drops", "Applies to Stasis Chamber and in-world drops"}).defineInRange("chickenDropFeathers", 20, 0, 100);
        this.chickenDropPoop = builder.comment(new String[]{"% chance chickens/ducks drop manure.  0= no manure", "Applies to Stasis Chamber and in-world drops", "This applies to Vanilla chickens too"}).defineInRange("chickenDropPoop", 20, 0, 100);
        this.allowShearingChickens = builder.comment(new String[]{"Allow shearing of chickens/ducks to get feathers.  Default: true", "This applies to Vanilla chickens too"}).define("allowShearingChickens", true);
        this.analyseChickens = builder.comment("Chickens must be analysed before breeding or laying drops.  Default: false  N/I").define("analyseChickens", false);
        this.energyEggMax = builder.comment(new String[]{"Maximum energy a Battery Egg can hold.", "Strength stat affects the energy value"}).defineInRange("energyEggMax", 5000, 1, 100000);
        builder.pop();
        builder.push("Chicken Basher");
        this.basherFindRange = builder.comment("Distance to search for Resource Chickens.  0= off").defineInRange("basherFindRange", 150, 0, 1000);
        this.basherOnlyCreative = builder.comment("Only Creative Basher has search feature.  Default: true").define("basherOnlyCreative", true);
        builder.pop();
        builder.push("Fake Player Interaction");
        this.allowFakeplayerBreeding = builder.comment("Allow Fakeplayer/automation of resource chicken breeding.  Default: true").define("allowFakeplayerBreeding", true);
        this.allowFakeplayerLootDrops = builder.comment("Allow Fakeplayer kills to produce loot drops.  Default: true").define("allowFakeplayerLootDrops", true);
        builder.pop();
        this.COMMON = builder.build();
        builder = new ForgeConfigSpec.Builder();
        builder.push("Chickens");
        this.renderLabels = builder.comment("Render Nest labels for named chickens.  Default: true").define("renderLabels", true);
        this.renderItems = builder.comment("Render item drops in the Nest.  Default: true").define("renderItems", true);
        this.renderJEIAnim = builder.comment("Animate chickens in JEI.  Default: false  WIP: lighting?").define("renderJEIAnim", false);
        this.allowEventTextures = builder.comment("Allow chicken textures to change on special days.  Default: true").define("allowEventTextures", true);
        this.compactTips = builder.comment(new String[]{"Show Chicken stats as a compact tooltip.  Default: false", "Note: Jade will start to shrink if the tooltip is too big"}).define("compactTips", false);
        this.healthHearts = builder.comment("Show Chicken health in Animal Net and when bashed.  Default: true").define("healthHearts", true);
        builder.pop();
        this.CLIENT = builder.build();
    }
}

