/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.init;

import java.util.function.Function;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wallywhip.resourcechickens.blocks.NestRenderer;
import wallywhip.resourcechickens.entities.ChickenBakedItemModel;
import wallywhip.resourcechickens.entities.ResourceChickenRenderer;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initCustomTips;
import wallywhip.resourcechickens.init.initTiles;

@Mod.EventBusSubscriber(modid="resourcechickens", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class initClient {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        initChickenRegistry.DATA.forEach((id, chickenData) -> event.registerEntityRenderer((EntityType)chickenData.entityType.get(), ResourceChickenRenderer::new));
        event.registerEntityRenderer((EntityType)initChickenRegistry.DUCK_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)initChickenRegistry.XP_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)initChickenRegistry.ENERGY_EGG.get(), ThrownItemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)initTiles.NEST_BLOCK_TILE.get(), NestRenderer::new);
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation location = new ModelResourceLocation("resourcechickens", "catcher_item", "inventory");
        BakedModel model = (BakedModel)event.getModels().get(location);
        if (model != null) {
            event.getModels().put(location, new ChickenBakedItemModel(model));
        }
        location = new ModelResourceLocation("resourcechickens", "catcher_item_duck", "inventory");
        model = (BakedModel)event.getModels().get(location);
        if (model != null) {
            event.getModels().put(location, new ChickenBakedItemModel(model));
        }
    }

    @SubscribeEvent
    public static void onRegisterClientTooltipComponentFactoriesEvent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(initCustomTips.HealthComponent.class, Function.identity());
    }
}

