/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.TOP;

import java.util.function.Function;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;

public class TOPPlugin {
    private static final ResourceLocation ID = new ResourceLocation("resourcechickens");
    private static final String SID = ID.toString();
    private static final ProgressStyle progressStyle = new ProgressStyle().alternateFilledColor(Color.rgb((int)137, (int)113, (int)15)).filledColor(Color.rgb((int)194, (int)159, (int)14)).showText(false);

    private TOPPlugin() {
    }

    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", GetTheOneProbe::new);
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe iTheOneProbe) {
            iTheOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

                public String getID() {
                    return SID;
                }

                public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player playerEntity, Level world, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
                    if (entity instanceof ResourceChickenEntity) {
                        ResourceChickenEntity rce = (ResourceChickenEntity)entity;
                        if (((Boolean)rce.m_20088_().m_135370_(ResourceChickenEntity.ANALYZED)).booleanValue()) {
                            if (((Boolean)ResourceChickens.CONFIGURATION.compactTips.get()).booleanValue()) {
                                iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.compact", (Object[])new Object[]{rce.m_20088_().m_135370_(ResourceChickenEntity.GAIN), rce.m_20088_().m_135370_(ResourceChickenEntity.GROWTH), rce.m_20088_().m_135370_(ResourceChickenEntity.STRENGTH)}));
                            } else {
                                iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.gain", (Object[])new Object[]{rce.m_20088_().m_135370_(ResourceChickenEntity.GAIN)}));
                                iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.growth", (Object[])new Object[]{rce.m_20088_().m_135370_(ResourceChickenEntity.GROWTH)}));
                                iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.strength", (Object[])new Object[]{rce.m_20088_().m_135370_(ResourceChickenEntity.STRENGTH)}));
                            }
                        }
                        if (rce.chickenDataCONV != null) {
                            iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.conv", (Object[])new Object[]{rce.chickenDataCONV.displayName}));
                            iProbeInfo.progress(rce.conversionProgress, rce.chickenDataCONV.conversionRequired, (IProgressStyle)progressStyle);
                        }
                    }
                }
            });
            iTheOneProbe.registerProvider(new IProbeInfoProvider(){

                public ResourceLocation getID() {
                    return ID;
                }

                public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData iProbeHitData) {
                    BlockEntity blockEntity;
                    if (blockState.m_60734_() == initBlocks.NEST_BLOCK.get() && (blockEntity = world.m_7702_(iProbeHitData.getPos())) instanceof NestTileEntity) {
                        boolean seedsRequired;
                        NestTileEntity tile = (NestTileEntity)blockEntity;
                        boolean bl = seedsRequired = (Boolean)ResourceChickens.CONFIGURATION.seededChamber.get() != false && tile.foodLevel == 0;
                        if (tile.entityCaptured != null) {
                            int chickenAge;
                            if (tile.entityCustomName != null) {
                                iProbeInfo.mcText(tile.entityCustomName);
                            }
                            iProbeInfo.mcText(tile.chickenData.displayName);
                            if (!tile.storedItems.getStackInSlot(5).m_41619_()) {
                                if (!tile.isWarm) {
                                    iProbeInfo.mcText((Component)Component.m_237115_((String)"tip.resourcechickens.warm").m_130940_(ChatFormatting.YELLOW));
                                    return;
                                }
                                iProbeInfo.mcText((Component)Component.m_237115_((String)"tip.resourcechickens.growing"));
                                iProbeInfo.progress(24000 + tile.chickenAge, 24000, (IProgressStyle)progressStyle);
                                return;
                            }
                            if (tile.entityCaptured.m_128471_("analyzed")) {
                                if (((Boolean)ResourceChickens.CONFIGURATION.compactTips.get()).booleanValue()) {
                                    iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.compact", (Object[])new Object[]{tile.chickenGain, tile.chickenGrowth, tile.chickenStrength}));
                                } else {
                                    iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.gain", (Object[])new Object[]{tile.chickenGain}));
                                    iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.growth", (Object[])new Object[]{tile.chickenGrowth}));
                                    iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.strength", (Object[])new Object[]{tile.chickenStrength}));
                                }
                            }
                            if ((chickenAge = tile.chickenAge) < 0) {
                                iProbeInfo.mcText((Component)Component.m_237115_((String)"tip.resourcechickens.growing"));
                                iProbeInfo.progress(24000 + chickenAge, 24000, (IProgressStyle)progressStyle);
                                return;
                            }
                            if (tile.chickenData.eggLayTime != 0) {
                                if (!seedsRequired) {
                                    iProbeInfo.mcText((Component)Component.m_237110_((String)"tip.resourcechickens.egg", (Object[])new Object[]{ResourceChickens.formatTime(tile.eggLayTime)}));
                                }
                            } else {
                                iProbeInfo.mcText((Component)Component.m_237115_((String)"tip.resourcechickens.no_drop").m_130940_(ChatFormatting.YELLOW));
                            }
                        }
                        if (seedsRequired) {
                            iProbeInfo.mcText((Component)Component.m_237115_((String)"tip.resourcechickens.seeds").m_130940_(ChatFormatting.YELLOW));
                        } else {
                            iProbeInfo.mcText((Component)Component.m_237115_((String)"tip.resourcechickens.food"));
                            iProbeInfo.progress(tile.foodLevel, 100, (IProgressStyle)progressStyle);
                        }
                    }
                }
            });
            return null;
        }
    }
}

