/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.JEI;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.JEI.EntityIngredient;
import wallywhip.resourcechickens.compat.JEI.JEIPlugin;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.json.ChickenData;

public class JEIChickenBreedingCategory
implements IRecipeCategory<Recipe> {
    private static final ResourceLocation GUI_BACK = new ResourceLocation("resourcechickens", "textures/gui/jei.png");
    private static final ResourceLocation GUI_ICONS = new ResourceLocation("resourcechickens", "textures/gui/icons.png");
    private static final ResourceLocation ID = new ResourceLocation("resourcechickens", "breeding");
    public static final RecipeType<Recipe> RECIPE = new RecipeType(ID, Recipe.class);
    private final Component localizedName = Component.m_237115_((String)"jei.resourcechickens.breeding");
    private final IDrawable background;
    private final IDrawable icon;

    public JEIChickenBreedingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 19, 109, 18).addPadding(0, 0, 0, 0).build();
        this.icon = guiHelper.createDrawable(GUI_ICONS, 0, 0, 16, 16);
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.parentA.ID));
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.parentB.ID));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 1).addIngredient(JEIPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.child.ID));
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (((Boolean)ResourceChickens.CONFIGURATION.allowCrossBreeding.get()).booleanValue()) {
            initChickenRegistry.DATA.forEach((id, chickenData) -> {
                if (!chickenData.parentA.equals("") || !chickenData.parentB.equals("")) {
                    recipes.add(new Recipe(initChickenRegistry.getChickenDataFromEntityID(chickenData.parentA), initChickenRegistry.getChickenDataFromEntityID(chickenData.parentB), (ChickenData)chickenData));
                }
            });
        }
        return recipes;
    }

    public static class Recipe {
        private final ChickenData parentA;
        private final ChickenData parentB;
        private final ChickenData child;

        public Recipe(ChickenData parentA, ChickenData parentB, ChickenData child) {
            this.parentA = parentA;
            this.parentB = parentB;
            this.child = child;
        }
    }
}

