/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.Nest;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.entities.NestChickenModel;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class NestRenderer
implements BlockEntityRenderer<NestTileEntity> {
    private static final Quaternionf Axis$XP$rotationDegrees180 = Axis.f_252529_.m_252977_(180.0f);
    private static final Quaternionf Axis$ZP$rotationDegrees180 = Axis.f_252403_.m_252977_(180.0f);
    private static final NestChickenModel<ResourceChickenEntity> chickenModel = new NestChickenModel(NestChickenModel.createBodyLayer().m_171564_());
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final double[][] NORTH = new double[][]{{0.75, 0.15, 0.25}, {0.25, 0.15, 0.25}, {0.75, 0.15, 0.75}, {0.25, 0.15, 0.75}};
    private static final double[][] SOUTH = new double[][]{{0.25, 0.15, 0.75}, {0.75, 0.15, 0.75}, {0.25, 0.15, 0.25}, {0.75, 0.15, 0.25}};
    private static final double[][] EAST = new double[][]{{0.75, 0.15, 0.75}, {0.75, 0.15, 0.25}, {0.25, 0.15, 0.75}, {0.25, 0.15, 0.25}};
    private static final double[][] WEST = new double[][]{{0.25, 0.15, 0.25}, {0.25, 0.15, 0.75}, {0.75, 0.15, 0.25}, {0.75, 0.15, 0.75}};

    public NestRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(NestTileEntity tileEntity, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = (Direction)tileEntity.m_58900_().m_61143_((Property)Nest.FACING);
        if (!tileEntity.storedItems.getStackInSlot(5).m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.5f, 0.15f, 0.5f);
            matrixStack.m_252781_(mc.m_91290_().m_253208_());
            ItemStack stack = tileEntity.storedItems.getStackInSlot(5);
            BakedModel bakedModel = mc.m_91291_().m_174264_(stack, null, null, 0);
            mc.m_91291_().m_115143_(stack, ItemDisplayContext.GROUND, true, matrixStack, buffer, combinedLight, combinedOverlay, bakedModel);
            matrixStack.m_85849_();
        } else if (tileEntity.entityCaptured != null) {
            NestRenderer.chickenModel.f_102610_ = tileEntity.chickenAge < 0;
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.5f, NestRenderer.chickenModel.f_102610_ ? 1.4f : 1.32f, 0.5f);
            matrixStack.m_252781_(Axis.f_252392_.m_252977_(direction.m_122435_()));
            matrixStack.m_252781_(Axis$XP$rotationDegrees180);
            RenderType renderType = chickenModel.m_103119_(tileEntity.chickenTexture);
            VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
            chickenModel.m_7695_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.renderLabels.get()).booleanValue() && tileEntity.entityCustomName != null && NestRenderer.mc.f_91063_.m_109153_().m_90583_().m_82531_((double)tileEntity.m_58899_().m_123341_(), (double)tileEntity.m_58899_().m_123342_(), (double)tileEntity.m_58899_().m_123343_()) < 64.0) {
            NestRenderer.renderLabel(matrixStack, buffer, combinedLight, tileEntity.entityCustomName, tileEntity.chickenAge < 0);
        }
        if (((Boolean)ResourceChickens.CONFIGURATION.renderItems.get()).booleanValue() && NestRenderer.mc.f_91063_.m_109153_().m_90583_().m_82531_((double)tileEntity.m_58899_().m_123341_(), (double)tileEntity.m_58899_().m_123342_(), (double)tileEntity.m_58899_().m_123343_()) < 64.0) {
            for (int slot = 1; slot < 5; ++slot) {
                if (tileEntity.storedItems.getStackInSlot(slot).m_41619_()) continue;
                NestRenderer.renderItem(tileEntity.storedItems.getStackInSlot(slot), NestRenderer.getTranslation(slot - 1, direction), Axis.f_252436_.m_252977_(180.0f + direction.m_122435_()), matrixStack, buffer, combinedOverlay, combinedLight);
            }
        }
    }

    private static void renderLabel(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, Component text, boolean isBaby) {
        Font fontRenderer = NestRenderer.mc.f_91062_;
        matrixStack.m_85836_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        matrixStack.m_252880_(0.5f, isBaby ? 0.7f : 1.0f, 0.5f);
        matrixStack.m_85841_(0.02f, 0.02f, 0.02f);
        matrixStack.m_252781_(mc.m_91290_().m_253208_());
        matrixStack.m_252781_(Axis$ZP$rotationDegrees180);
        fontRenderer.m_272077_(text, offset, 0.0f, 0, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0x66000000, lightLevel);
        fontRenderer.m_272077_(text, offset, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, lightLevel);
        matrixStack.m_85849_();
    }

    private static void renderItem(ItemStack stack, double[] translation, Quaternionf rotation, PoseStack matrixStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(translation[0], translation[1], translation[2]);
        matrixStack.m_252781_(rotation);
        matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        BakedModel bakedModel = mc.m_91291_().m_174264_(stack, null, null, 0);
        mc.m_91291_().m_115143_(stack, ItemDisplayContext.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, bakedModel);
        matrixStack.m_85849_();
    }

    private static double[] getTranslation(int slot, Direction direction) {
        return switch (direction) {
            default -> NORTH[slot];
            case Direction.SOUTH -> SOUTH[slot];
            case Direction.WEST -> WEST[slot];
            case Direction.EAST -> EAST[slot];
        };
    }
}

