/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;

public class Nest
extends BaseEntityBlock {
    private static final TagKey<Block> WARMING_BLOCKS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("resourcechickens", "warming_blocks"));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape shapeCHICKEN_N = Stream.of(Block.m_49796_((double)5.0, (double)1.1, (double)5.0, (double)11.0, (double)8.1, (double)11.0), Block.m_49796_((double)7.0, (double)6.1, (double)1.0, (double)9.0, (double)8.1, (double)3.0), Block.m_49796_((double)6.0, (double)8.1, (double)0.0, (double)10.0, (double)10.1, (double)2.0), Block.m_49796_((double)11.0, (double)4.1, (double)5.0, (double)12.0, (double)8.1, (double)11.0), Block.m_49796_((double)4.0, (double)4.1, (double)5.0, (double)5.0, (double)8.1, (double)11.0), Block.m_49796_((double)6.0, (double)6.1, (double)2.0, (double)10.0, (double)12.1, (double)5.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeCHICKEN_S = Stream.of(Block.m_49796_((double)5.0, (double)1.1, (double)5.0, (double)11.0, (double)8.1, (double)11.0), Block.m_49796_((double)7.0, (double)6.1, (double)13.0, (double)9.0, (double)8.1, (double)15.0), Block.m_49796_((double)6.0, (double)8.1, (double)14.0, (double)10.0, (double)10.1, (double)16.0), Block.m_49796_((double)4.0, (double)4.1, (double)5.0, (double)5.0, (double)8.1, (double)11.0), Block.m_49796_((double)11.0, (double)4.1, (double)5.0, (double)12.0, (double)8.1, (double)11.0), Block.m_49796_((double)6.0, (double)6.1, (double)11.0, (double)10.0, (double)12.1, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeCHICKEN_W = Stream.of(Block.m_49796_((double)5.0, (double)1.1, (double)5.0, (double)11.0, (double)8.1, (double)11.0), Block.m_49796_((double)1.0, (double)6.1, (double)7.0, (double)3.0, (double)8.1, (double)9.0), Block.m_49796_((double)0.0, (double)8.1, (double)6.0, (double)2.0, (double)10.1, (double)10.0), Block.m_49796_((double)5.0, (double)4.1, (double)4.0, (double)11.0, (double)8.1, (double)5.0), Block.m_49796_((double)5.0, (double)4.1, (double)11.0, (double)11.0, (double)8.1, (double)12.0), Block.m_49796_((double)2.0, (double)6.1, (double)6.0, (double)5.0, (double)12.1, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeCHICKEN_E = Stream.of(Block.m_49796_((double)5.0, (double)1.1, (double)5.0, (double)11.0, (double)8.1, (double)11.0), Block.m_49796_((double)13.0, (double)6.1, (double)7.0, (double)15.0, (double)8.1, (double)9.0), Block.m_49796_((double)14.0, (double)8.1, (double)6.0, (double)16.0, (double)10.1, (double)10.0), Block.m_49796_((double)5.0, (double)4.1, (double)11.0, (double)11.0, (double)8.1, (double)12.0), Block.m_49796_((double)5.0, (double)4.1, (double)4.0, (double)11.0, (double)8.1, (double)5.0), Block.m_49796_((double)11.0, (double)6.1, (double)6.0, (double)14.0, (double)12.1, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeNEST = Stream.of(Block.m_49796_((double)12.0, (double)2.1, (double)5.0, (double)13.0, (double)3.1, (double)7.0), Block.m_49796_((double)5.0, (double)0.1, (double)5.0, (double)11.0, (double)1.1, (double)11.0), Block.m_49796_((double)12.0, (double)1.1, (double)7.0, (double)13.0, (double)2.1, (double)9.0), Block.m_49796_((double)3.0, (double)1.1, (double)7.0, (double)4.0, (double)2.1, (double)9.0), Block.m_49796_((double)4.0, (double)0.1, (double)7.0, (double)5.0, (double)1.1, (double)9.0), Block.m_49796_((double)11.0, (double)0.1, (double)7.0, (double)12.0, (double)1.1, (double)9.0), Block.m_49796_((double)7.0, (double)1.1, (double)3.0, (double)9.0, (double)2.1, (double)4.0), Block.m_49796_((double)7.0, (double)0.1, (double)4.0, (double)9.0, (double)1.1, (double)5.0), Block.m_49796_((double)7.0, (double)0.1, (double)11.0, (double)9.0, (double)1.1, (double)12.0), Block.m_49796_((double)7.0, (double)1.1, (double)12.0, (double)9.0, (double)2.1, (double)13.0), Block.m_49796_((double)4.0, (double)1.1, (double)9.0, (double)5.0, (double)2.1, (double)11.0), Block.m_49796_((double)11.0, (double)1.1, (double)9.0, (double)12.0, (double)2.1, (double)11.0), Block.m_49796_((double)11.0, (double)2.1, (double)11.0, (double)12.0, (double)3.1, (double)12.0), Block.m_49796_((double)11.0, (double)2.1, (double)4.0, (double)12.0, (double)3.1, (double)5.0), Block.m_49796_((double)4.0, (double)2.1, (double)4.0, (double)5.0, (double)3.1, (double)5.0), Block.m_49796_((double)4.0, (double)2.1, (double)11.0, (double)5.0, (double)3.1, (double)12.0), Block.m_49796_((double)11.0, (double)1.1, (double)5.0, (double)12.0, (double)2.1, (double)7.0), Block.m_49796_((double)4.0, (double)1.1, (double)5.0, (double)5.0, (double)2.1, (double)7.0), Block.m_49796_((double)13.0, (double)2.1, (double)7.0, (double)14.0, (double)3.1, (double)9.0), Block.m_49796_((double)2.0, (double)2.1, (double)7.0, (double)3.0, (double)3.1, (double)9.0), Block.m_49796_((double)7.0, (double)2.1, (double)2.0, (double)9.0, (double)3.1, (double)3.0), Block.m_49796_((double)7.0, (double)2.1, (double)13.0, (double)9.0, (double)3.1, (double)14.0), Block.m_49796_((double)12.0, (double)2.1, (double)9.0, (double)13.0, (double)3.1, (double)11.0), Block.m_49796_((double)9.0, (double)2.1, (double)12.0, (double)11.0, (double)3.1, (double)13.0), Block.m_49796_((double)5.0, (double)2.1, (double)12.0, (double)7.0, (double)3.1, (double)13.0), Block.m_49796_((double)5.0, (double)1.1, (double)11.0, (double)7.0, (double)2.1, (double)12.0), Block.m_49796_((double)5.0, (double)1.1, (double)4.0, (double)7.0, (double)2.1, (double)5.0), Block.m_49796_((double)9.0, (double)1.1, (double)4.0, (double)11.0, (double)2.1, (double)5.0), Block.m_49796_((double)9.0, (double)1.1, (double)11.0, (double)11.0, (double)2.1, (double)12.0), Block.m_49796_((double)3.0, (double)2.1, (double)9.0, (double)4.0, (double)3.1, (double)11.0), Block.m_49796_((double)3.0, (double)2.1, (double)5.0, (double)4.0, (double)3.1, (double)7.0), Block.m_49796_((double)5.0, (double)2.1, (double)3.0, (double)7.0, (double)3.1, (double)4.0), Block.m_49796_((double)9.0, (double)2.1, (double)3.0, (double)11.0, (double)3.1, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] NEST_SHAPES = new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_N, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_S, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_W, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_E, (BooleanOp)BooleanOp.f_82695_)};
    private static final VoxelShape shapeCHICKEN_BABY_N = Stream.of(Block.m_49796_((double)6.0, (double)2.5, (double)4.0, (double)10.0, (double)8.35, (double)7.0), Block.m_49796_((double)7.0, (double)2.95, (double)3.0, (double)9.0, (double)4.5, (double)5.0), Block.m_49796_((double)6.0, (double)4.5, (double)2.0, (double)10.0, (double)6.35, (double)4.0), Block.m_49796_((double)6.5, (double)1.25, (double)7.0, (double)9.5, (double)2.5, (double)10.0), Block.m_49796_((double)6.0, (double)2.5, (double)7.0, (double)10.0, (double)5.1, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeCHICKEN_BABY_E = Stream.of(Block.m_49796_((double)9.0, (double)2.5, (double)6.0, (double)12.0, (double)8.35, (double)10.0), Block.m_49796_((double)11.0, (double)2.95, (double)7.0, (double)13.0, (double)4.5, (double)9.0), Block.m_49796_((double)12.0, (double)4.5, (double)6.0, (double)14.0, (double)6.35, (double)10.0), Block.m_49796_((double)6.0, (double)1.25, (double)6.5, (double)9.0, (double)2.5, (double)9.5), Block.m_49796_((double)6.0, (double)2.5, (double)6.0, (double)9.0, (double)5.1, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeCHICKEN_BABY_S = Stream.of(Block.m_49796_((double)6.0, (double)2.5, (double)8.95, (double)10.0, (double)8.35, (double)11.95), Block.m_49796_((double)7.0, (double)2.95, (double)10.95, (double)9.0, (double)4.5, (double)12.95), Block.m_49796_((double)6.0, (double)4.5, (double)11.95, (double)10.0, (double)6.35, (double)13.95), Block.m_49796_((double)6.5, (double)1.25, (double)6.0, (double)9.5, (double)2.5, (double)8.95), Block.m_49796_((double)6.0, (double)2.5, (double)6.0, (double)10.0, (double)5.1, (double)8.95)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape shapeCHICKEN_BABY_W = Stream.of(Block.m_49796_((double)4.0, (double)2.5, (double)6.0, (double)7.0, (double)8.35, (double)10.0), Block.m_49796_((double)3.0, (double)2.95, (double)7.0, (double)5.0, (double)4.5, (double)9.0), Block.m_49796_((double)2.0, (double)4.5, (double)6.0, (double)4.0, (double)6.35, (double)10.0), Block.m_49796_((double)7.0, (double)1.25, (double)6.5, (double)10.05, (double)2.5, (double)9.5), Block.m_49796_((double)7.0, (double)2.5, (double)6.0, (double)10.05, (double)5.1, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] NEST_SHAPES_BABY = new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83040_(), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_BABY_N, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_BABY_S, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_BABY_W, (BooleanOp)BooleanOp.f_82695_), Shapes.m_83113_((VoxelShape)shapeNEST, (VoxelShape)shapeCHICKEN_BABY_E, (BooleanOp)BooleanOp.f_82695_)};

    public Nest() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60978_(0.5f).m_60918_(SoundType.f_56740_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            if (tile.chickenData != null && tile.storedItems.getStackInSlot(5).m_41619_()) {
                return tile.chickenAge < 0 ? NEST_SHAPES_BABY[((Direction)state.m_61143_((Property)FACING)).ordinal()] : NEST_SHAPES[((Direction)state.m_61143_((Property)FACING)).ordinal()];
            }
        }
        return shapeNEST;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : Nest.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)initTiles.NEST_BLOCK_TILE.get()), NestTileEntity::serverTick);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return super.rotate(state, world, pos, direction);
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new NestTileEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            ItemStack itemStack = player.m_21120_(hand);
            if (player.m_6144_() && itemStack.m_41619_()) {
                for (int a = 1; a < tile.storedItems.getSlots(); ++a) {
                    if (!player.m_36356_(tile.storedItems.getStackInSlot(a)) || a != 5) continue;
                    tile.entityRemove(true);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
            if (tile.storedItems.isItemValid(0, itemStack)) {
                ItemStack returned;
                int transferred = itemStack.m_41613_();
                if (transferred != (returned = tile.storedItems.insertItem(0, itemStack, false)).m_41613_()) {
                    if (!player.m_7500_()) {
                        player.m_21008_(hand, returned);
                    }
                    if (tile.entityCaptured != null) {
                        for (int a = 0; a < 4; ++a) {
                            double d0 = level.f_46441_.m_188583_() * 0.2;
                            double d1 = level.f_46441_.m_188583_() * 0.2;
                            double d2 = level.f_46441_.m_188583_() * 0.2;
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, (double)((float)pos.m_123341_() + level.f_46441_.m_188501_()), (double)pos.m_123342_() + 0.75, (double)((float)pos.m_123343_() + level.f_46441_.m_188501_()), d0, d1, d2);
                        }
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12507_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return level.f_46443_ ? InteractionResult.CONSUME : InteractionResult.FAIL;
            }
            if (tile.storedItems.isItemValid(5, itemStack)) {
                ItemStack returned;
                int transferred;
                if (tile.entityCaptured == null && (transferred = itemStack.m_41613_()) != (returned = tile.storedItems.insertItem(5, itemStack, false)).m_41613_()) {
                    if (!level.f_46443_) {
                        ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)initBlocks.NEST_BLOCK.get()).m_49966_()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                    }
                    if (!player.m_7500_()) {
                        player.m_21008_(hand, returned);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12507_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return level.f_46443_ ? InteractionResult.CONSUME : InteractionResult.FAIL;
            }
            if (itemStack.m_41720_() instanceof NameTagItem) {
                if (tile.entityCaptured != null) {
                    tile.entitySetCustomName(itemStack.m_41737_("display"));
                    tile.sendRenderUpdates();
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof NestTileEntity) {
                LivingEntity bird;
                NestTileEntity tile = (NestTileEntity)blockEntity;
                if (tile.storedItems.getStackInSlot(5).m_41619_() && tile.entityCaptured != null && (bird = (LivingEntity)((EntityType)tile.chickenData.entityType.get()).m_20615_(level)) != null) {
                    level.m_5594_(null, pos, level.f_46441_.m_188499_() ? SoundEvents.f_11752_ : (tile.chickenData.hasTrait == 1 ? (SoundEvent)initSounds.DUCK_AMBIENT.get() : SoundEvents.f_11750_), SoundSource.BLOCKS, 1.0f, 1.0f);
                    bird.m_20258_(tile.entityCaptured);
                    bird.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    bird.m_21153_(tile.entityCaptured.m_128457_("Health"));
                    level.m_7967_((Entity)bird);
                }
                tile.storedItems.getStacks().forEach(item -> Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)item));
            }
            level.m_46747_(pos);
        }
    }

    public void m_6861_(@NotNull BlockState p_60509_, @NotNull Level p_60510_, @NotNull BlockPos p_60511_, @NotNull Block p_60512_, @NotNull BlockPos p_60513_, boolean p_60514_) {
        BlockEntity blockEntity;
        super.m_6861_(p_60509_, p_60510_, p_60511_, p_60512_, p_60513_, p_60514_);
        if (p_60511_.m_7495_().equals((Object)p_60513_) && (blockEntity = p_60510_.m_7702_(p_60511_)) instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            tile.isWarm = p_60510_.m_8055_(p_60513_).m_204336_(WARMING_BLOCKS);
            tile.m_6596_();
        }
    }

    public void m_6402_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity p_49850_, @NotNull ItemStack p_49851_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NestTileEntity) {
            NestTileEntity tile = (NestTileEntity)blockEntity;
            tile.isWarm = level.m_8055_(pos.m_7495_()).m_204336_(WARMING_BLOCKS);
            tile.m_6596_();
        }
    }
}

