/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.biomes;

import com.google.gson.JsonArray;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import wallywhip.resourcechickens.init.initBiomeModifiers;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.json.ChickenData;

public record ChickenBiomeModifier(List<HolderSet<Biome>> whitelist, List<HolderSet<Biome>> blacklist, MobSpawnSettings.SpawnerData spawns) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        ChickenData chickenData;
        if (phase.equals((Object)BiomeModifier.Phase.ADD) && (chickenData = initChickenRegistry.DATA.get(this.spawns().f_48404_.m_147048_())) != null && chickenData.spawnNaturally && !ChickenBiomeModifier.isInList(this.blacklist, biome) && ChickenBiomeModifier.isInList(this.whitelist(), biome)) {
            if (biome.m_203543_().isPresent()) {
                if (chickenData.biomesWhitelist == null) {
                    chickenData.biomesWhitelist = new JsonArray();
                }
                chickenData.biomesWhitelist.add(((ResourceKey)biome.m_203543_().get()).m_135782_().toString());
            }
            builder.getMobSpawnSettings().m_48376_(this.spawns().f_48404_.m_20674_(), this.spawns());
        }
    }

    private static boolean isInList(List<HolderSet<Biome>> biomes, Holder<Biome> biome) {
        return biomes.stream().anyMatch(b -> b.m_203333_(biome));
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)initBiomeModifiers.SPAWN_MODIFIER.get();
    }

    public static Codec<ChickenBiomeModifier> makeCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47432_.listOf().fieldOf("whitelist").forGetter(ChickenBiomeModifier::whitelist), (App)Biome.f_47432_.listOf().fieldOf("blacklist").orElse(new ArrayList()).forGetter(ChickenBiomeModifier::blacklist), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawners").forGetter(ChickenBiomeModifier::spawns)).apply((Applicative)instance, ChickenBiomeModifier::new));
    }
}

