/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens;

import com.mojang.logging.LogUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wallywhip.resourcechickens.compat.TOP.TOPPlugin;
import wallywhip.resourcechickens.entities.DuckEggProjectileEntity;
import wallywhip.resourcechickens.entities.EnergyEggProjectileEntity;
import wallywhip.resourcechickens.entities.ResourceChickenEntity;
import wallywhip.resourcechickens.entities.XpEggProjectileEntity;
import wallywhip.resourcechickens.init.initBiomeModifiers;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenConfigs;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initConfigs;
import wallywhip.resourcechickens.init.initCreativeTab;
import wallywhip.resourcechickens.init.initCustomTips;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.items.ChickenCatcherItemDispenser;
import wallywhip.resourcechickens.items.LiquidEggDispenser;
import wallywhip.resourcechickens.items.ManureItemDispenser;
import wallywhip.resourcechickens.json.ChickenData;

@Mod(value="resourcechickens")
public class ResourceChickens {
    public static final String MOD_ID = "resourcechickens";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final initConfigs CONFIGURATION = new initConfigs();
    private static final ResourceLocation FOOLISH_LOC = new ResourceLocation("resourcechickens", "textures/entity/vanilla/chicken_fool.png");
    private static final ResourceLocation[] FESTIVE_LOC = new ResourceLocation[]{new ResourceLocation("resourcechickens", "textures/entity/vanilla/chicken_fest1.png"), new ResourceLocation("resourcechickens", "textures/entity/vanilla/chicken_fest2.png")};
    private static boolean isFestive = false;
    private static boolean isFoolish = false;

    public ResourceChickens() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ResourceChickens.CONFIGURATION.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ResourceChickens.CONFIGURATION.CLIENT);
        IEventBus MOD_EVENTBUS = FMLJavaModLoadingContext.get().getModEventBus();
        initSounds.SOUNDS.register(MOD_EVENTBUS);
        initCreativeTab.TAB_GROUP.register(MOD_EVENTBUS);
        initItems.ITEMS.register(MOD_EVENTBUS);
        initBlocks.BLOCKS.register(MOD_EVENTBUS);
        initTiles.TILES.register(MOD_EVENTBUS);
        initChickenRegistry.ENTITY_TYPES.register(MOD_EVENTBUS);
        initBiomeModifiers.MODIFIERS.register(MOD_EVENTBUS);
        initChickenConfigs.loadConfigs();
        MOD_EVENTBUS.addListener(this::onModConfigEvent);
        MOD_EVENTBUS.addListener(initChickenRegistry::onEntityAttributeCreationEvent);
        MOD_EVENTBUS.addListener(this::onFMLCommonSetupEvent);
        MOD_EVENTBUS.addListener(this::onInterModEnqueueEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTooltipEvent(RenderTooltipEvent.GatherComponents event) {
        initCustomTips.onRenderTooltipEvent(event);
    }

    private void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            TOPPlugin.register();
        }
    }

    public void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MOD_ID) && event.getConfig().getType() == ModConfig.Type.CLIENT) {
            if (((Boolean)ResourceChickens.CONFIGURATION.allowEventTextures.get()).booleanValue()) {
                LocalDate date = LocalDate.now();
                int dd = date.getDayOfMonth();
                int mm = date.getMonthValue();
                isFestive = dd > 20 && mm == 12;
                isFoolish = dd == 1 && mm == 4;
            } else {
                isFoolish = false;
                isFestive = false;
            }
        }
    }

    private void onFMLCommonSetupEvent(FMLCommonSetupEvent event) {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.WATER_EGG.get()), (DispenseItemBehavior)new LiquidEggDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.LAVA_EGG.get()), (DispenseItemBehavior)new LiquidEggDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.CHICKEN_ITEM.get()), (DispenseItemBehavior)new ChickenCatcherItemDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.CHICKEN_ITEM_DUCK.get()), (DispenseItemBehavior)new ChickenCatcherItemDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.MANURE.get()), (DispenseItemBehavior)new ManureItemDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.EGG_DUCK.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(@NotNull Level level, @NotNull Position position, @NotNull ItemStack itemStack) {
                return (Projectile)Util.m_137469_((Object)((Object)new DuckEggProjectileEntity(level, position)), projectile -> projectile.m_37446_(itemStack));
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.ENERGY_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(@NotNull Level level, @NotNull Position position, @NotNull ItemStack itemStack) {
                return (Projectile)Util.m_137469_((Object)((Object)new EnergyEggProjectileEntity(level, position)), projectile -> projectile.m_37446_(itemStack));
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)initItems.EGG_XP.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(@NotNull Level level, @NotNull Position position, @NotNull ItemStack itemStack) {
                return (Projectile)Util.m_137469_((Object)((Object)new XpEggProjectileEntity(level, position)), projectile -> projectile.m_37446_(itemStack));
            }
        });
        ComposterBlock.f_51914_.put((Object)((Item)initItems.MANURE.get()).m_5456_(), 0.65f);
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ResourceChickenEntity) {
            return;
        }
        if (!((Boolean)ResourceChickens.CONFIGURATION.OverrideVanillaChickens.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_6095_() == EntityType.f_20555_) {
            Level level;
            event.setCanceled(true);
            ChickenData chickenData = initChickenRegistry.DATA.get("chicken");
            if (chickenData != null && (level = event.getEntity().m_9236_()) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                CompoundTag compound = event.getEntity().m_20240_(new CompoundTag());
                compound.m_128359_("id", "resourcechickens:chicken");
                compound.m_128473_("UUID");
                Entity bird = EntityType.m_20645_((CompoundTag)compound, (Level)sl, entity -> {
                    entity.m_7678_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), entity.m_146908_(), entity.m_146909_());
                    return entity;
                });
                if (bird != null) {
                    sl.m_8860_(bird);
                }
            }
        }
    }

    public static int calcNewEggLayTime(RandomSource r, ChickenData chickenData, int growth) {
        if (chickenData.eggLayTime == 0) {
            return 0;
        }
        int egg = r.m_188503_(chickenData.eggLayTime) + chickenData.eggLayTime;
        return (int)Math.max(1.0f, (float)egg * (10.0f - (float)growth + 1.0f) / 10.0f);
    }

    public static int calcDropQuantity(int gain) {
        if (gain < 5) {
            return 1;
        }
        if (gain < 10) {
            return 2;
        }
        return 3;
    }

    public static List<ItemStack> calcDrops(int gain, ChickenData chickenData, int fortune) {
        Random r;
        ItemStack itemStack;
        ArrayList<ItemStack> lst = new ArrayList<ItemStack>();
        if (!chickenData.dropItem.isEmpty() && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItem)).m_41619_()) {
            if (chickenData.dropItemNBT != null) {
                itemStack.m_41751_(chickenData.dropItemNBT.m_6426_());
            }
            int dropQuantity = 1;
            if (itemStack.m_150930_((Item)initItems.ENERGY_EGG.get())) {
                itemStack.m_41784_().m_128405_("energy", (int)((float)gain / 10.0f) * (Integer)ResourceChickens.CONFIGURATION.energyEggMax.get());
            } else {
                dropQuantity = ResourceChickens.calcDropQuantity(gain) + fortune;
            }
            if (itemStack.m_41753_()) {
                itemStack.m_41764_(dropQuantity);
                lst.add(itemStack);
            } else {
                for (int a = 0; a < dropQuantity; ++a) {
                    ItemStack itm = itemStack.m_41777_();
                    lst.add(itm);
                }
            }
        }
        if ((r = new Random()).nextInt(100) + 1 <= (Integer)ResourceChickens.CONFIGURATION.chickenDropFeathers.get()) {
            lst.add(new ItemStack((ItemLike)(chickenData.hasTrait == 1 ? (ItemLike)initItems.FEATHER_DUCK.get() : Items.f_42402_)));
        }
        if (r.nextInt(100) + 1 <= (Integer)ResourceChickens.CONFIGURATION.chickenDropPoop.get()) {
            lst.add(new ItemStack((ItemLike)initItems.MANURE.get()));
        }
        return lst;
    }

    public static String formatTime(int milli) {
        int secs = milli / 20;
        int mins = secs / 60;
        int hours = mins / 60;
        if (hours == 0) {
            return String.format("%02d:%02d", mins, secs % 60);
        }
        return String.format("%02d:%02d:%02d", hours, mins, secs % 60);
    }

    public static ItemStack getDropItem(String dropItem) {
        Item item;
        if (dropItem.startsWith("tag:")) {
            ResourceLocation ID = ResourceLocation.m_135820_((String)dropItem.substring(4));
            if (ID != null) {
                TagKey tagKey;
                ITagManager tagBlocks;
                TagKey tagKey2;
                ITagManager tagItems = ForgeRegistries.ITEMS.tags();
                if (tagItems != null && tagItems.isKnownTagName(tagKey2 = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ID))) {
                    RandomSource random = RandomSource.m_216327_();
                    Optional item2 = tagItems.getTag(tagKey2).getRandomElement(random);
                    if (item2.isPresent()) {
                        return new ItemStack((ItemLike)item2.get());
                    }
                }
                if ((tagBlocks = ForgeRegistries.BLOCKS.tags()) != null && tagBlocks.isKnownTagName(tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)ID))) {
                    RandomSource random = RandomSource.m_216327_();
                    Optional block = tagBlocks.getTag(tagKey).getRandomElement(random);
                    if (block.isPresent()) {
                        return new ItemStack((ItemLike)block.get());
                    }
                }
            }
            return ItemStack.f_41583_;
        }
        ResourceLocation ID = ResourceLocation.m_135820_((String)dropItem);
        if (ID != null && (item = (Item)ForgeRegistries.ITEMS.getValue(ID)) != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }

    public static boolean matchDropItem(String dropItem, Item item) {
        if (dropItem.startsWith("tag:")) {
            TagKey tagKey;
            ITagManager tagItems;
            ResourceLocation ID = ResourceLocation.m_135820_((String)dropItem.substring(4));
            if (ID != null && (tagItems = ForgeRegistries.ITEMS.tags()) != null && tagItems.isKnownTagName(tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)ID))) {
                return tagItems.getTag(tagKey).contains((Object)item);
            }
            return false;
        }
        ResourceLocation ID = ResourceLocation.m_135820_((String)dropItem);
        if (ID != null) {
            return ForgeRegistries.ITEMS.getValue(ID) == item;
        }
        return false;
    }

    public static ResourceLocation getTexture(ResourceChickenEntity entityIn) {
        if (isFestive && entityIn.chickenData.ID.equals("chicken")) {
            long l = entityIn.m_20148_().getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && entityIn.chickenData.ID.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return entityIn.chickenData.chickenTexture;
    }

    public static ResourceLocation getTexture(ChickenData chickenData, UUID uuid) {
        if (isFestive && chickenData.ID.equals("chicken")) {
            long l = uuid.getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && chickenData.ID.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return chickenData.chickenTexture;
    }
}

