/*
 * Decompiled with CFR 0.152.
 */
package com.drd.ad_extendra.worldgen.feature;

import com.drd.ad_extendra.common.blocks.IcicleBlock;
import com.drd.ad_extendra.worldgen.feature.configuration.IcicleConfiguration;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class IcicleFeature
extends Feature<IcicleConfiguration> {
    public IcicleFeature(Codec<IcicleConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<IcicleConfiguration> pContext) {
        WorldGenLevel levelaccessor = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        RandomSource randomsource = pContext.m_225041_();
        IcicleConfiguration config = (IcicleConfiguration)pContext.m_159778_();
        Optional<Direction> optional = IcicleFeature.getTipDirection((LevelAccessor)levelaccessor, blockpos, randomsource);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = blockpos.m_121945_(optional.get().m_122424_());
        IcicleFeature.createPatchOfDripstoneBlocks((LevelAccessor)levelaccessor, randomsource, blockpos1, config);
        int i = randomsource.m_188501_() < config.chanceOfTallerDripstone && DripstoneUtils.m_159664_((BlockState)levelaccessor.m_8055_(blockpos.m_121945_(optional.get()))) ? 2 : 1;
        IcicleBlock.growPointedDripstone((LevelAccessor)levelaccessor, blockpos, optional.get(), i, false, config.stone_provider.m_213972_(randomsource, blockpos).m_60734_());
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        boolean flag = pLevel.m_8055_(pPos.m_7494_()).m_60804_((BlockGetter)pLevel, pPos.m_7494_());
        boolean flag1 = pLevel.m_8055_(pPos.m_7495_()).m_60804_((BlockGetter)pLevel, pPos.m_7495_());
        if (flag && flag1) {
            return Optional.of(pRandom.m_188499_() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfDripstoneBlocks(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, IcicleConfiguration pConfig) {
        Block block = pConfig.stone_provider.m_213972_(pRandom, pPos).m_60734_();
        Block block2 = pConfig.base_stone_provider.m_213972_(pRandom, pPos).m_60734_();
        IcicleFeature.placeDripstoneBlockIfPossible(pLevel, pPos, block, block2);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (pRandom.m_188501_() > pConfig.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = pPos.m_121945_(direction);
            IcicleFeature.placeDripstoneBlockIfPossible(pLevel, blockpos, block, block2);
            if (pRandom.m_188501_() > pConfig.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.m_121945_(Direction.m_235672_((RandomSource)pRandom));
            IcicleFeature.placeDripstoneBlockIfPossible(pLevel, blockpos1, block, block2);
            if (pRandom.m_188501_() > pConfig.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.m_121945_(Direction.m_235672_((RandomSource)pRandom));
            IcicleFeature.placeDripstoneBlockIfPossible(pLevel, blockpos2, block, block2);
        }
    }

    protected static boolean placeDripstoneBlockIfPossible(LevelAccessor pLevel, BlockPos pPos, Block block, Block block2) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (blockstate.m_60713_(block2)) {
            Direction direction = null;
            if (!IcicleFeature.getTipDirection(pLevel, pPos, pLevel.m_213780_()).isEmpty()) {
                direction = IcicleFeature.getTipDirection(pLevel, pPos, pLevel.m_213780_()).get();
            }
            IcicleBlock.growPointedDripstone(pLevel, pPos, direction == null ? Direction.UP : direction, pLevel.m_213780_().m_216339_(1, 8), true, block);
            return true;
        }
        return false;
    }
}

