/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardVillagers;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.goals.AttackEntityDaytimeGoal;
import tallestegg.guardvillagers.entities.ai.goals.GetOutOfWaterGoal;
import tallestegg.guardvillagers.entities.ai.goals.GolemFloatWaterGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGolemGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGuardAndPlayerGoal;

@Mod.EventBusSubscriber(modid="guardvillagers")
public class HandlerEvents {
    private static final Predicate<LivingEntity> ISNT_BABY = mob -> !mob.m_6162_();

    @SubscribeEvent
    public static void onEntityTarget(LivingChangeTargetEvent event) {
        boolean isVillager;
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (target == null || entity.m_6095_() == GuardEntityType.GUARD.get()) {
            return;
        }
        boolean bl = isVillager = target.m_6095_() == EntityType.f_20492_ || target.m_6095_() == GuardEntityType.GUARD.get();
        if (isVillager) {
            List list = entity.m_9236_().m_45976_(Mob.class, entity.m_20191_().m_82377_(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (Mob mob : list) {
                if (mob.m_5448_() != null || mob.m_6095_() != GuardEntityType.GUARD.get() && mob.m_6095_() != EntityType.f_20460_) continue;
                if (mob.m_5647_() != null && entity.m_5647_() != null && entity.m_5647_().m_83536_(mob.m_5647_())) {
                    return;
                }
                mob.m_6710_(entity);
            }
        }
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (target instanceof Guard) {
                golem.m_6710_(null);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        boolean isGolem;
        LivingEntity entity = event.getEntity();
        Entity trueSource = event.getSource().m_7639_();
        if (entity == null || trueSource == null) {
            return;
        }
        boolean isVillager = entity.m_6095_() == EntityType.f_20492_ || entity.m_6095_() == GuardEntityType.GUARD.get();
        boolean bl = isGolem = isVillager || entity.m_6095_() == EntityType.f_20460_;
        if (isGolem && trueSource.m_6095_() == GuardEntityType.GUARD.get() && !GuardConfig.guardArrowsHurtVillagers) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if (isVillager && event.getSource().m_7639_() instanceof Mob) {
            List list = trueSource.m_9236_().m_45976_(Mob.class, trueSource.m_20191_().m_82377_(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (Mob mob : list) {
                boolean type = mob.m_6095_() == GuardEntityType.GUARD.get() || mob.m_6095_() == EntityType.f_20460_;
                boolean trueSourceGolem = trueSource.m_6095_() == GuardEntityType.GUARD.get() || trueSource.m_6095_() == EntityType.f_20460_;
                if (trueSourceGolem || !type || mob.m_5448_() != null) continue;
                if (mob.m_5647_() != null && entity.m_5647_() != null && entity.m_5647_().m_83536_(mob.m_5647_())) {
                    return;
                }
                mob.m_6710_((LivingEntity)((Mob)event.getSource().m_7639_()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getHitVec().m_82425_();
        BlockState originalBlock = player.m_9236_().m_8055_(pos);
        if (((Boolean)GuardConfig.COMMON.multiFollow.get()).booleanValue() && originalBlock.m_60734_() instanceof BellBlock && (blockEntity = level.m_7702_(pos)) instanceof BellBlockEntity) {
            BellBlockEntity bellBlockEntity = (BellBlockEntity)blockEntity;
            if (!bellBlockEntity.f_58814_) {
                List list = player.m_9236_().m_45976_(Guard.class, player.m_20191_().m_82377_(32.0, 32.0, 32.0));
                for (Guard guard : list) {
                    if (!GuardVillagers.canFollow(player)) continue;
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    guard.setFollowing(!guard.isFollowing());
                    guard.m_216990_((SoundEvent)GuardSounds.GUARD_YES.get());
                    if (guard.isFollowing()) {
                        guard.setOwnerId(player.m_20148_());
                        guard.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 1));
                        level.m_5594_(null, pos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        continue;
                    }
                    guard.m_21195_(MobEffects.f_19619_);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            LivingEntity livingEntity2;
            AbstractHorse horse = (AbstractHorse)livingEntity;
            Vec3 vec3 = new Vec3((double)horse.f_20900_, (double)horse.f_20901_, (double)horse.f_20902_);
            if (horse.m_217005_() && (livingEntity2 = horse.m_6688_()) instanceof Guard) {
                Guard guard = (Guard)livingEntity2;
                horse.m_7910_((float)horse.m_21133_(Attributes.f_22279_));
                horse.m_7023_(vec3);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Zombie zombie;
            Mob mob = (Mob)entity;
            if (mob instanceof Raider && ((Raider)mob).m_37886_() && GuardConfig.RaidAnimals) {
                mob.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal(mob, Animal.class, false));
            }
            if (((Boolean)GuardConfig.COMMON.MobsAttackGuards.get()).booleanValue() && mob instanceof Enemy && !GuardConfig.MobBlackList.contains(mob.m_20078_())) {
                if (!(mob instanceof Spider)) {
                    mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(mob, Guard.class, false));
                } else {
                    mob.f_21346_.m_25352_(3, new AttackEntityDaytimeGoal<Guard>((Spider)mob, Guard.class));
                }
            }
            if (mob instanceof AbstractIllager) {
                AbstractIllager illager = (AbstractIllager)mob;
                if (GuardConfig.IllagersRunFromPolarBears) {
                    illager.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)illager, PolarBear.class, 6.0f, 1.0, 1.2));
                }
                illager.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)illager, Guard.class, false));
            }
            if (mob instanceof AbstractVillager) {
                AbstractVillager abstractvillager = (AbstractVillager)mob;
                if (GuardConfig.VillagersRunFromPolarBears) {
                    abstractvillager.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)abstractvillager, PolarBear.class, 6.0f, 1.0, 1.2));
                }
                if (GuardConfig.WitchesVillager) {
                    abstractvillager.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)abstractvillager, Witch.class, 6.0f, 1.0, 1.2));
                }
            }
            if (mob instanceof Villager) {
                Villager villager = (Villager)mob;
                if (GuardConfig.BlackSmithHealing) {
                    villager.f_21345_.m_25352_(1, (Goal)new HealGolemGoal((Mob)villager));
                }
                if (GuardConfig.ClericHealing) {
                    villager.f_21345_.m_25352_(1, (Goal)new HealGuardAndPlayerGoal((Mob)villager, 1.0, 100, 0, 10.0f));
                }
            }
            if (mob instanceof IronGolem) {
                IronGolem golem = (IronGolem)mob;
                HurtByTargetGoal tolerateFriendlyFire = new HurtByTargetGoal((PathfinderMob)golem, new Class[]{Guard.class}).m_26044_(new Class[0]);
                golem.f_21346_.f_25345_.stream().map(it -> it.f_25994_).filter(it -> it instanceof HurtByTargetGoal).findFirst().ifPresent(angerGoal -> {
                    golem.f_21346_.m_25363_(angerGoal);
                    golem.f_21346_.m_25352_(2, (Goal)tolerateFriendlyFire);
                });
                if (((Boolean)GuardConfig.COMMON.ironGolemFloat.get()).booleanValue()) {
                    golem.f_21345_.m_25352_(1, (Goal)new GolemFloatWaterGoal((Mob)golem));
                    golem.f_21345_.m_25352_(0, (Goal)new GetOutOfWaterGoal((PathfinderMob)golem, 1.0));
                }
            }
            if (mob instanceof Zombie && !((zombie = (Zombie)mob) instanceof NeutralMob)) {
                zombie.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Guard.class, false));
            }
            if (mob instanceof Ravager) {
                Ravager ravager = (Ravager)mob;
                ravager.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)ravager, Guard.class, false));
            }
            if (mob instanceof Witch) {
                Witch witch = (Witch)mob;
                if (GuardConfig.WitchesVillager) {
                    witch.f_21346_.m_25352_(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, AbstractVillager.class, 10, true, false, ISNT_BABY));
                    witch.f_21346_.m_25352_(3, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, IronGolem.class, 10, true, false, null));
                    witch.f_21346_.m_25352_(2, (Goal)new NearestAttackableWitchTargetGoal((Raider)witch, Guard.class, 10, true, false, null));
                }
            }
            if (mob instanceof Cat) {
                Cat cat = (Cat)mob;
                cat.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)cat, AbstractIllager.class, 12.0f, 1.0, 1.2));
            }
        }
    }
}

