/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankScreenAddon
extends BasicScreenAddon {
    private IFluidTank tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;

    public TankScreenAddon(int posX, int posY, IFluidTank tank, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluid().isEmpty()) {
            TextureAtlasSprite sprite;
            AbstractTexture texture;
            FluidStack fluidStack = this.tank.getFluid();
            double stored = this.tank.getFluidAmount();
            double capacity = this.tank.getCapacity();
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = (int)(stored / capacity * (double)(area.height - topBottomPadding));
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation flowing = renderProperties.getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).m_118316_(flowing)) != null) {
                Color color = new Color(renderProperties.getTintColor(fluidStack));
                guiGraphics.m_280246_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
                RenderSystem.enableBlend();
                guiGraphics.m_280159_(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST), this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().m_205067_(Tags.Fluids.GASEOUS) ? 0 : area.height - topBottomPadding - offset), 0, (int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST)), offset, sprite);
                RenderSystem.disableBlend();
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        ITankAsset asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        AssetUtil.drawAsset(guiGraphics, screen, asset, guiX + this.getPosX(), guiY + this.getPosY());
    }

    @Override
    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> strings = new ArrayList<Component>();
        strings.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.titanium.tank.fluid").getString())).m_7220_((Component)(this.tank.getFluid().isEmpty() ? Component.m_237115_((String)"tooltip.titanium.tank.empty").m_130940_(ChatFormatting.WHITE) : Component.m_237115_((String)this.tank.getFluid().getFluid().getFluidType().getDescriptionId()))).m_130940_(ChatFormatting.WHITE));
        strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.amount").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidAmount()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getCapacity()) + ChatFormatting.DARK_AQUA + "mb"))));
        if (!Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().m_41619_() && Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                boolean isBucket = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().m_41720_() instanceof BucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem) {
                    strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.can_fill_from_item").m_130940_(ChatFormatting.BLUE));
                }
                if (canDrainFromItem) {
                    strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.can_drain_from_item").m_130940_(ChatFormatting.GOLD));
                }
                if (canFillFromItem) {
                    strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.action_fill").m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (canDrainFromItem) {
                    strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.action_drain").m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (!canDrainFromItem && !canFillFromItem) {
                    strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.no_action").m_130940_(ChatFormatting.RED));
                }
            });
        } else {
            strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.no_tank").m_130940_(ChatFormatting.DARK_GRAY));
        }
        return strings;
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Screen screen;
        if (!Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().m_41619_() && Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && (screen = Minecraft.m_91087_().f_91080_) instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).m_6262_() instanceof ILocatable) {
            if (!this.m_5953_(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.PLAYERS, 1.0f, 1.0f, RandomSource.m_216327_(), Minecraft.m_91087_().f_91074_.m_20183_()));
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).m_6262_();
            CompoundTag compoundNBT = new CompoundTag();
            if (this.tank instanceof FluidTankComponent) {
                compoundNBT.m_128359_("Name", ((FluidTankComponent)this.tank).getName());
            } else {
                compoundNBT.m_128379_("Invalid", true);
            }
            Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                boolean isBucket = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().m_41720_() instanceof BucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem && button == 0) {
                    compoundNBT.m_128379_("Fill", true);
                }
                if (canDrainFromItem && button == 1) {
                    compoundNBT.m_128379_("Fill", false);
                }
            });
            Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -3, compoundNBT));
            return true;
        }
        return false;
    }
}

